/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.colors.gradients.StrategyBasedLinearGradientBuilder;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BackgroundImage;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssGradientUtil;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackgroundApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundApplierUtil.class);

    private BackgroundApplierUtil() {
    }

    public static void applyBackground(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String backgroundImageStr;
        String backgroundColorStr = cssProps.get("background-color");
        if (backgroundColorStr != null && !"transparent".equals(backgroundColorStr)) {
            float[] rgbaColor = CssUtils.parseRgbaColor((String)backgroundColorStr);
            DeviceRgb color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
            float opacity = rgbaColor[3];
            Background backgroundColor = new Background((Color)color, opacity);
            element.setProperty(6, (Object)backgroundColor);
        }
        if ((backgroundImageStr = cssProps.get("background-image")) != null) {
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(backgroundImageStr);
            CssDeclarationValueTokenizer.Token currentToken = tokenizer.getNextValidToken();
            while (currentToken != null && currentToken.getType() == CssDeclarationValueTokenizer.TokenType.COMMA) {
                currentToken = tokenizer.getNextValidToken();
            }
            backgroundImageStr = currentToken != null ? currentToken.getValue() : null;
        }
        BackgroundImage backgroundImage = null;
        if (backgroundImageStr != null && !"none".equals(backgroundImageStr)) {
            boolean repeatX = true;
            boolean repeatY = true;
            String backgroundRepeatStr = cssProps.get("background-repeat");
            if (backgroundRepeatStr != null) {
                repeatX = "repeat".equals(backgroundRepeatStr) || "repeat-x".equals(backgroundRepeatStr);
                boolean bl = repeatY = "repeat".equals(backgroundRepeatStr) || "repeat-y".equals(backgroundRepeatStr);
            }
            if (CssGradientUtil.isCssLinearGradientValue((String)backgroundImageStr)) {
                float em = CssUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
                float rem = context.getCssContext().getRootFontSize();
                try {
                    StrategyBasedLinearGradientBuilder gradientBuilder = CssGradientUtil.parseCssLinearGradient((String)backgroundImageStr, (float)em, (float)rem);
                    if (gradientBuilder != null) {
                        backgroundImage = new BackgroundImage((AbstractLinearGradientBuilder)gradientBuilder);
                    }
                }
                catch (StyledXMLParserException e) {
                    LOGGER.warn(MessageFormatUtil.format((String)"Invalid gradient declaration: {0}", (Object[])new Object[]{backgroundImageStr}));
                }
            } else {
                PdfXObject image = context.getResourceResolver().retrieveImageExtended(CssUtils.extractUrl((String)backgroundImageStr));
                if (image != null) {
                    if (image instanceof PdfImageXObject) {
                        backgroundImage = new BackgroundImage((PdfImageXObject)image, repeatX, repeatY);
                    } else if (image instanceof PdfFormXObject) {
                        backgroundImage = new BackgroundImage((PdfFormXObject)image, repeatX, repeatY);
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        if (backgroundImage != null) {
            element.setProperty(90, backgroundImage);
        }
    }
}

