/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.util;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.page.CssMarginRule;
import com.itextpdf.styledxmlparser.css.page.CssPageRule;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import java.util.Collection;

public class CssStyleSheetAnalyzer {
    private CssStyleSheetAnalyzer() {
    }

    public static boolean checkPagesCounterPresence(CssStyleSheet styleSheet) {
        return CssStyleSheetAnalyzer.checkPagesCounterPresence(styleSheet.getStatements());
    }

    private static boolean checkPagesCounterPresence(Collection<CssStatement> statements) {
        boolean pagesCounterPresent = false;
        for (CssStatement statement : statements) {
            if (statement instanceof CssMarginRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssMarginRule)statement).getStatements());
                continue;
            }
            if (statement instanceof CssMediaRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssMediaRule)statement).getStatements());
                continue;
            }
            if (statement instanceof CssPageRule) {
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(((CssPageRule)statement).getStatements());
                continue;
            }
            if (!(statement instanceof CssRuleSet)) continue;
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence((CssRuleSet)statement);
        }
        return pagesCounterPresent;
    }

    private static boolean checkPagesCounterPresence(CssRuleSet ruleSet) {
        boolean pagesCounterPresent = false;
        for (CssDeclaration declaration : ruleSet.getImportantDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(declaration);
        }
        for (CssDeclaration declaration : ruleSet.getNormalDeclarations()) {
            pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkPagesCounterPresence(declaration);
        }
        return pagesCounterPresent;
    }

    private static boolean checkPagesCounterPresence(CssDeclaration declaration) {
        boolean pagesCounterPresent = false;
        if ("content".equals(declaration.getProperty())) {
            CssDeclarationValueTokenizer.Token token;
            CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(declaration.getExpression());
            while ((token = tokenizer.getNextValidToken()) != null) {
                String[] params;
                String paramsStr;
                if (token.isString()) continue;
                if (token.getValue().startsWith("counters(")) {
                    paramsStr = token.getValue().substring("counters".length() + 1, token.getValue().length() - 1);
                    params = paramsStr.split(",");
                    pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkCounterFunctionParamsForPagesReferencePresence(params);
                    continue;
                }
                if (!token.getValue().startsWith("counter(")) continue;
                paramsStr = token.getValue().substring("counter".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                pagesCounterPresent = pagesCounterPresent || CssStyleSheetAnalyzer.checkCounterFunctionParamsForPagesReferencePresence(params);
            }
        }
        return pagesCounterPresent;
    }

    private static boolean checkCounterFunctionParamsForPagesReferencePresence(String[] params) {
        return params.length > 0 && "pages".equals(params[0].trim());
    }
}

