/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFontsDir() {
        String winDir = System.getenv("windir");
        String fileSeparator = System.getProperty("file.separator");
        return winDir + fileSeparator + "fonts";
    }

    public static String getFileName(String file) {
        return new File(file).getName();
    }

    public static boolean fileExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isFile();
        }
        return false;
    }

    public static boolean directoryExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    public static String[] listFilesInDirectory(String path, boolean recursive) {
        File[] files;
        File root;
        if (path != null && (root = new File(path)).exists() && root.isDirectory() && (files = root.listFiles()) != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (File file : files) {
                if (file.isDirectory() && recursive) {
                    FileUtil.listAllFiles(file.getAbsolutePath(), list);
                    continue;
                }
                list.add(file.getAbsolutePath());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    private static void listAllFiles(String dir, List<String> list) {
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtil.listAllFiles(file.getAbsolutePath(), list);
                    continue;
                }
                list.add(file.getAbsolutePath());
            }
        }
    }

    public static PrintWriter createPrintWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter(output, encoding));
    }
}

