/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.CidFont;
import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.FontConstants;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontRegisterProvider;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.util.ArrayUtil;
import java.text.MessageFormat;
import java.util.Set;

public final class FontProgramFactory {
    private static FontRegisterProvider fontRegisterProvider = new FontRegisterProvider();

    private FontProgramFactory() {
    }

    public static FontProgram createFont() throws java.io.IOException {
        return FontProgramFactory.createFont("Helvetica");
    }

    public static FontProgram createFont(String name) throws java.io.IOException {
        return FontProgramFactory.createFont(name, null, true);
    }

    public static FontProgram createFont(String font, boolean cached) throws java.io.IOException {
        return FontProgramFactory.createFont(font, null, cached);
    }

    public static FontProgram createFont(byte[] font) throws java.io.IOException {
        return FontProgramFactory.createFont(null, font, false);
    }

    public static FontProgram createFont(String name, byte[] font, boolean cached) throws java.io.IOException {
        FontProgram fontBuilt;
        FontProgram fontFound;
        boolean isCidFont;
        String baseName = FontProgram.getBaseName(name);
        boolean isBuiltinFonts14 = FontConstants.BUILTIN_FONTS_14.contains(name);
        boolean bl = isCidFont = !isBuiltinFonts14 && FontCache.isPredefinedCidFont(baseName);
        if (cached && name != null && (fontFound = FontCache.getFont(name)) != null) {
            return fontFound;
        }
        if (name == null) {
            if (font != null) {
                try {
                    return new TrueTypeFont(font);
                }
                catch (Exception exception) {
                    try {
                        return new Type1Font(null, null, font, null);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            throw new IOException("font.is.not.recognized");
        }
        if (isBuiltinFonts14 || name.toLowerCase().endsWith(".afm") || name.toLowerCase().endsWith(".pfm")) {
            fontBuilt = new Type1Font(name, null, font, null);
        } else if (baseName.toLowerCase().endsWith(".ttf") || baseName.toLowerCase().endsWith(".otf") || baseName.toLowerCase().indexOf(".ttc,") > 0) {
            fontBuilt = font != null ? new TrueTypeFont(font) : new TrueTypeFont(name);
        } else if (isCidFont) {
            fontBuilt = new CidFont(name, FontCache.getCompatibleCmaps(baseName));
        } else {
            throw new IOException("font {0} is.not.recognized").setMessageParams(name);
        }
        return cached ? FontCache.saveFont(fontBuilt, name) : fontBuilt;
    }

    public static FontProgram createType1Font(String name, byte[] afm, byte[] pfb, boolean cached) throws java.io.IOException {
        FontProgram fontProgram;
        if (cached && name != null && (fontProgram = FontCache.getFont(name)) != null) {
            return fontProgram;
        }
        fontProgram = new Type1Font(name, null, afm, pfb);
        return cached && name != null ? FontCache.saveFont(fontProgram, name) : fontProgram;
    }

    public static FontProgram createType1Font(byte[] afm, byte[] pfb) throws java.io.IOException {
        return FontProgramFactory.createType1Font(null, afm, pfb, false);
    }

    public static FontProgram createType1Font(String metricsPath, String binaryPath, boolean cached) throws java.io.IOException {
        FontProgram fontProgram;
        if (cached && metricsPath != null && (fontProgram = FontCache.getFont(metricsPath)) != null) {
            return fontProgram;
        }
        fontProgram = new Type1Font(metricsPath, binaryPath, null, null);
        return cached && metricsPath != null ? FontCache.saveFont(fontProgram, metricsPath) : fontProgram;
    }

    public static FontProgram createType1Font(String metricsPath, String binaryPath) throws java.io.IOException {
        return FontProgramFactory.createType1Font(metricsPath, binaryPath, true);
    }

    public static FontProgram createFont(String ttcPath, int ttcIndex, boolean cached) throws java.io.IOException {
        FontProgram fontFound;
        if (cached && (fontFound = FontCache.getFont(ttcPath + ttcIndex)) != null) {
            return fontFound;
        }
        TrueTypeFont fontBuilt = new TrueTypeFont(ttcPath, ttcIndex);
        return cached ? FontCache.saveFont(fontBuilt, ttcPath + ttcIndex) : fontBuilt;
    }

    public static FontProgram createFont(byte[] ttc, int ttcIndex, boolean cached) throws java.io.IOException {
        String ttcNameKey;
        FontProgram fontFound;
        if (cached && (fontFound = FontCache.getFont(ttcNameKey = MessageFormat.format("{0}{1}", ArrayUtil.hashCode(ttc), ttcIndex))) != null) {
            return fontFound;
        }
        TrueTypeFont fontBuilt = new TrueTypeFont(ttc, ttcIndex);
        String ttcNameKey2 = MessageFormat.format("{0}{1}", ArrayUtil.hashCode(ttc), ttcIndex);
        return cached ? FontCache.saveFont(fontBuilt, ttcNameKey2) : fontBuilt;
    }

    public static FontProgram createRegisteredFont(String fontName, int style, boolean cached) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, style, cached);
    }

    public static FontProgram createRegisteredFont(String fontName, int style) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, style);
    }

    public static FontProgram createRegisteredFont(String fontName) throws java.io.IOException {
        return fontRegisterProvider.getFont(fontName, -1);
    }

    public static void registerFontFamily(String familyName, String fullName, String path) {
        fontRegisterProvider.registerFontFamily(familyName, fullName, path);
    }

    public static void registerFont(String path) {
        FontProgramFactory.registerFont(path, null);
    }

    public static void registerFont(String path, String alias) {
        fontRegisterProvider.registerFont(path, alias);
    }

    public static int registerFontDirectory(String dir) {
        return fontRegisterProvider.registerFontDirectory(dir);
    }

    public static int registerSystemFontDirectories() {
        return fontRegisterProvider.registerSystemFontDirectories();
    }

    public static Set<String> getRegisteredFonts() {
        return fontRegisterProvider.getRegisteredFonts();
    }

    public static Set<String> getRegisteredFontFamilies() {
        return fontRegisterProvider.getRegisteredFontFamilies();
    }

    public static boolean isRegisteredFont(String fontname) {
        return fontRegisterProvider.isRegisteredFont(fontname);
    }
}

