/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TrueTypeFontSubset {
    static final String[] tableNamesSimple = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final String[] tableNamesCmap = new String[]{"cmap", "OS/2"};
    static final String[] tableNamesExtra = new String[]{"cmap", "OS/2", "name"};
    static final int[] entrySelectors = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4};
    static final int TABLE_CHECKSUM = 0;
    static final int TABLE_OFFSET = 1;
    static final int TABLE_LENGTH = 2;
    static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int WE_HAVE_A_SCALE = 8;
    static final int MORE_COMPONENTS = 32;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    protected Map<String, int[]> tableDirectory;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean includeCmap;
    protected boolean includeExtras;
    protected boolean locaShortTable;
    protected int[] locaTable;
    protected Set<Integer> glyphsUsed;
    protected List<Integer> glyphsInList;
    protected int tableGlyphOffset;
    protected int[] newLocaTable;
    protected byte[] newLocaTableOut;
    protected byte[] newGlyfTable;
    protected int glyfTableRealSize;
    protected int locaTableRealSize;
    protected byte[] outFont;
    protected int fontPtr;
    protected int directoryOffset;

    TrueTypeFontSubset(String fileName, RandomAccessFileOrArray rf, Set<Integer> glyphsUsed, int directoryOffset, boolean includeCmap, boolean includeExtras) {
        this.fileName = fileName;
        this.rf = rf;
        this.glyphsUsed = glyphsUsed;
        this.includeCmap = includeCmap;
        this.includeExtras = includeExtras;
        this.directoryOffset = directoryOffset;
        this.glyphsInList = new ArrayList<Integer>(glyphsUsed);
    }

    byte[] process() throws java.io.IOException {
        try {
            this.createTableDirectory();
            this.readLoca();
            this.flatGlyphs();
            this.createNewGlyphTables();
            this.locaToBytes();
            this.assembleFont();
            byte[] byArray = this.outFont;
            return byArray;
        }
        finally {
            try {
                this.rf.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void assembleFont() throws java.io.IOException {
        int[] tableLocation;
        int fullFontSize = 0;
        ArrayList tableNames = new ArrayList();
        Collections.addAll(tableNames, tableNamesSimple);
        if (this.includeExtras) {
            Collections.addAll(tableNames, tableNamesExtra);
        } else if (this.includeCmap) {
            Collections.addAll(tableNames, tableNamesCmap);
        }
        int tablesUsed = 2;
        for (String name : tableNames) {
            if (name.equals("glyf") || name.equals("loca") || (tableLocation = this.tableDirectory.get(name)) == null) continue;
            ++tablesUsed;
            fullFontSize += tableLocation[2] + 3 & 0xFFFFFFFC;
        }
        fullFontSize += this.newLocaTableOut.length;
        fullFontSize += this.newGlyfTable.length;
        int reference = 16 * tablesUsed + 12;
        this.outFont = new byte[fullFontSize += reference];
        this.fontPtr = 0;
        this.writeFontInt(65536);
        this.writeFontShort(tablesUsed);
        int selector = entrySelectors[tablesUsed];
        this.writeFontShort((1 << selector) * 16);
        this.writeFontShort(selector);
        this.writeFontShort((tablesUsed - (1 << selector)) * 16);
        for (String name : tableNames) {
            int len;
            tableLocation = this.tableDirectory.get(name);
            if (tableLocation == null) continue;
            this.writeFontString(name);
            switch (name) {
                case "glyf": {
                    this.writeFontInt(this.calculateChecksum(this.newGlyfTable));
                    len = this.glyfTableRealSize;
                    break;
                }
                case "loca": {
                    this.writeFontInt(this.calculateChecksum(this.newLocaTableOut));
                    len = this.locaTableRealSize;
                    break;
                }
                default: {
                    this.writeFontInt(tableLocation[0]);
                    len = tableLocation[2];
                }
            }
            this.writeFontInt(reference);
            this.writeFontInt(len);
            reference += len + 3 & 0xFFFFFFFC;
        }
        block18: for (String name : tableNames) {
            tableLocation = this.tableDirectory.get(name);
            if (tableLocation == null) continue;
            switch (name) {
                case "glyf": {
                    System.arraycopy(this.newGlyfTable, 0, this.outFont, this.fontPtr, this.newGlyfTable.length);
                    this.fontPtr += this.newGlyfTable.length;
                    this.newGlyfTable = null;
                    continue block18;
                }
                case "loca": {
                    System.arraycopy(this.newLocaTableOut, 0, this.outFont, this.fontPtr, this.newLocaTableOut.length);
                    this.fontPtr += this.newLocaTableOut.length;
                    this.newLocaTableOut = null;
                    continue block18;
                }
            }
            this.rf.seek(tableLocation[1]);
            this.rf.readFully(this.outFont, this.fontPtr, tableLocation[2]);
            this.fontPtr += tableLocation[2] + 3 & 0xFFFFFFFC;
        }
    }

    protected void createTableDirectory() throws java.io.IOException {
        this.tableDirectory = new HashMap<String, int[]>();
        this.rf.seek(this.directoryOffset);
        int id = this.rf.readInt();
        if (id != 65536) {
            throw new IOException("1.is.not.a.true.type.file").setMessageParams(this.fileName);
        }
        int num_tables = this.rf.readUnsignedShort();
        this.rf.skipBytes(6);
        for (int k = 0; k < num_tables; ++k) {
            String tag = this.readStandardString(4);
            int[] tableLocation = new int[]{this.rf.readInt(), this.rf.readInt(), this.rf.readInt()};
            this.tableDirectory.put(tag, tableLocation);
        }
    }

    protected void readLoca() throws java.io.IOException {
        int[] tableLocation = this.tableDirectory.get("head");
        if (tableLocation == null) {
            throw new IOException("table.1.does.not.exist.in.2", "head").setMessageParams(this.fileName);
        }
        this.rf.seek(tableLocation[1] + 51);
        this.locaShortTable = this.rf.readUnsignedShort() == 0;
        tableLocation = this.tableDirectory.get("loca");
        if (tableLocation == null) {
            throw new IOException("table.1.does.not.exist.in.2", "loca").setMessageParams(this.fileName);
        }
        this.rf.seek(tableLocation[1]);
        if (this.locaShortTable) {
            int entries = tableLocation[2] / 2;
            this.locaTable = new int[entries];
            for (int k = 0; k < entries; ++k) {
                this.locaTable[k] = this.rf.readUnsignedShort() * 2;
            }
        } else {
            int entries = tableLocation[2] / 4;
            this.locaTable = new int[entries];
            for (int k = 0; k < entries; ++k) {
                this.locaTable[k] = this.rf.readInt();
            }
        }
    }

    protected void createNewGlyphTables() throws java.io.IOException {
        this.newLocaTable = new int[this.locaTable.length];
        int[] activeGlyphs = new int[this.glyphsInList.size()];
        for (int k = 0; k < activeGlyphs.length; ++k) {
            activeGlyphs[k] = this.glyphsInList.get(k);
        }
        Arrays.sort(activeGlyphs);
        int glyfSize = 0;
        for (int glyph : activeGlyphs) {
            glyfSize += this.locaTable[glyph + 1] - this.locaTable[glyph];
        }
        this.glyfTableRealSize = glyfSize;
        glyfSize = glyfSize + 3 & 0xFFFFFFFC;
        this.newGlyfTable = new byte[glyfSize];
        int glyfPtr = 0;
        int listGlyf = 0;
        for (int k = 0; k < this.newLocaTable.length; ++k) {
            this.newLocaTable[k] = glyfPtr;
            if (listGlyf >= activeGlyphs.length || activeGlyphs[listGlyf] != k) continue;
            ++listGlyf;
            this.newLocaTable[k] = glyfPtr;
            int start = this.locaTable[k];
            int len = this.locaTable[k + 1] - start;
            if (len <= 0) continue;
            this.rf.seek(this.tableGlyphOffset + start);
            this.rf.readFully(this.newGlyfTable, glyfPtr, len);
            glyfPtr += len;
        }
    }

    protected void locaToBytes() {
        this.locaTableRealSize = this.locaShortTable ? this.newLocaTable.length * 2 : this.newLocaTable.length * 4;
        this.newLocaTableOut = new byte[this.locaTableRealSize + 3 & 0xFFFFFFFC];
        this.outFont = this.newLocaTableOut;
        this.fontPtr = 0;
        for (int k = 0; k < this.newLocaTable.length; ++k) {
            if (this.locaShortTable) {
                this.writeFontShort(this.newLocaTable[k] / 2);
                continue;
            }
            this.writeFontInt(this.newLocaTable[k]);
        }
    }

    protected void flatGlyphs() throws java.io.IOException {
        int[] tableLocation = this.tableDirectory.get("glyf");
        if (tableLocation == null) {
            throw new IOException("table.1.does.not.exist.in.2").setMessageParams("glyf", this.fileName);
        }
        Integer glyph0 = 0;
        if (!this.glyphsUsed.contains(glyph0)) {
            this.glyphsUsed.add(glyph0);
            this.glyphsInList.add(glyph0);
        }
        this.tableGlyphOffset = tableLocation[1];
        for (int k = 0; k < this.glyphsInList.size(); ++k) {
            int glyph = this.glyphsInList.get(k);
            this.checkGlyphComposite(glyph);
        }
    }

    protected void checkGlyphComposite(int glyph) throws java.io.IOException {
        int start = this.locaTable[glyph];
        if (start == this.locaTable[glyph + 1]) {
            return;
        }
        this.rf.seek(this.tableGlyphOffset + start);
        short numContours = this.rf.readShort();
        if (numContours >= 0) {
            return;
        }
        this.rf.skipBytes(8);
        while (true) {
            int flags = this.rf.readUnsignedShort();
            Integer cGlyph = this.rf.readUnsignedShort();
            if (!this.glyphsUsed.contains(cGlyph)) {
                this.glyphsUsed.add(cGlyph);
                this.glyphsInList.add(cGlyph);
            }
            if ((flags & 0x20) == 0) {
                return;
            }
            int skip = (flags & 1) != 0 ? 4 : 2;
            if ((flags & 8) != 0) {
                skip += 2;
            } else if ((flags & 0x40) != 0) {
                skip += 4;
            }
            if ((flags & 0x80) != 0) {
                skip += 8;
            }
            this.rf.skipBytes(skip);
        }
    }

    protected String readStandardString(int length) throws java.io.IOException {
        byte[] buf = new byte[length];
        this.rf.readFully(buf);
        try {
            return new String(buf, "Cp1252");
        }
        catch (Exception e) {
            throw new IOException("TrueType font", e);
        }
    }

    protected void writeFontShort(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontInt(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 24);
        this.outFont[this.fontPtr++] = (byte)(n >> 16);
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontString(String s) {
        byte[] b = PdfEncodings.convertToBytes(s, "Cp1252");
        System.arraycopy(b, 0, this.outFont, this.fontPtr, b.length);
        this.fontPtr += b.length;
    }

    protected int calculateChecksum(byte[] b) {
        int len = b.length / 4;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int ptr = 0;
        for (int k = 0; k < len; ++k) {
            v3 += b[ptr++] & 0xFF;
            v2 += b[ptr++] & 0xFF;
            v1 += b[ptr++] & 0xFF;
            v0 += b[ptr++] & 0xFF;
        }
        return v0 + (v1 << 8) + (v2 << 16) + (v3 << 24);
    }
}

