/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.LanguageRecord;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.ScriptRecord;
import com.itextpdf.io.font.otf.TagAndLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenTypeScript {
    public final String DEFAULT_SCRIPT = "DFLT";
    private OpenTypeFontTableReader openTypeReader;
    private List<ScriptRecord> records;

    public OpenTypeScript(OpenTypeFontTableReader openTypeReader, int locationScriptTable) throws IOException {
        TagAndLocation[] tagsLocs;
        this.openTypeReader = openTypeReader;
        this.records = new ArrayList<ScriptRecord>();
        openTypeReader.rf.seek(locationScriptTable);
        for (TagAndLocation tagLoc : tagsLocs = openTypeReader.readTagAndLocations(locationScriptTable)) {
            this.readScriptRecord(tagLoc);
        }
    }

    public List<ScriptRecord> getScriptRecords() {
        return this.records;
    }

    public LanguageRecord getLanguageRecord(String[] scripts, String language) {
        ScriptRecord scriptFound = null;
        ScriptRecord scriptDefault = null;
        for (ScriptRecord sr : this.records) {
            if (!"DFLT".equals(sr.tag)) continue;
            scriptDefault = sr;
            break;
        }
        for (String script : scripts) {
            for (ScriptRecord sr : this.records) {
                if (sr.tag.equals(script)) {
                    scriptFound = sr;
                    break;
                }
                if (!"DFLT".equals(script)) continue;
                scriptDefault = sr;
            }
            if (scriptFound != null) break;
        }
        if (scriptFound == null) {
            scriptFound = scriptDefault;
        }
        if (scriptFound == null) {
            return null;
        }
        LanguageRecord lang = null;
        for (LanguageRecord lr : scriptFound.languages) {
            if (!lr.tag.equals(language)) continue;
            lang = lr;
            break;
        }
        if (lang == null) {
            lang = scriptFound.defaultLanguage;
        }
        return lang;
    }

    private void readScriptRecord(TagAndLocation tagLoc) throws IOException {
        this.openTypeReader.rf.seek(tagLoc.location);
        int locationDefaultLanguage = this.openTypeReader.rf.readUnsignedShort();
        if (locationDefaultLanguage > 0) {
            locationDefaultLanguage += tagLoc.location;
        }
        TagAndLocation[] tagsLocs = this.openTypeReader.readTagAndLocations(tagLoc.location);
        ScriptRecord srec = new ScriptRecord();
        srec.tag = tagLoc.tag;
        srec.languages = new LanguageRecord[tagsLocs.length];
        for (int k = 0; k < tagsLocs.length; ++k) {
            srec.languages[k] = this.readLanguageRecord(tagsLocs[k]);
        }
        if (locationDefaultLanguage > 0) {
            TagAndLocation t = new TagAndLocation();
            t.tag = "";
            t.location = locationDefaultLanguage;
            srec.defaultLanguage = this.readLanguageRecord(t);
        }
        this.records.add(srec);
    }

    private LanguageRecord readLanguageRecord(TagAndLocation tagLoc) throws IOException {
        LanguageRecord rec = new LanguageRecord();
        this.openTypeReader.rf.seek(tagLoc.location + 2);
        rec.featureRequired = this.openTypeReader.rf.readUnsignedShort();
        int count = this.openTypeReader.rf.readUnsignedShort();
        rec.features = this.openTypeReader.readUShortArray(count);
        rec.tag = tagLoc.tag;
        return rec;
    }
}

