/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.MappedChannelRandomAccessSource;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;

public class FileChannelRandomAccessSource
implements IRandomAccessSource,
Serializable {
    private static final long serialVersionUID = -7550288945325499416L;
    private final FileChannel channel;
    private final MappedChannelRandomAccessSource source;

    public FileChannelRandomAccessSource(FileChannel channel) throws IOException {
        this.channel = channel;
        if (channel.size() == 0L) {
            throw new IOException("File size is 0 bytes");
        }
        this.source = new MappedChannelRandomAccessSource(channel, 0L, channel.size());
        this.source.open();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.channel.close();
    }

    @Override
    public int get(long position) throws IOException {
        return this.source.get(position);
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        return this.source.get(position, bytes, off, len);
    }

    @Override
    public long length() {
        return this.source.length();
    }
}

