/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.ArrayRandomAccessSource;
import com.itextpdf.io.source.FileChannelRandomAccessSource;
import com.itextpdf.io.source.GetBufferedRandomAccessSource;
import com.itextpdf.io.source.GroupedRandomAccessSource;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.MapFailedException;
import com.itextpdf.io.source.PagedChannelRandomAccessSource;
import com.itextpdf.io.source.RAFRandomAccessSource;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;

public final class RandomAccessSourceFactory
implements Serializable {
    private static final long serialVersionUID = -8958482579413233761L;
    private boolean forceRead = false;
    private boolean usePlainRandomAccess = false;
    private boolean exclusivelyLockFile = false;

    public RandomAccessSourceFactory setForceRead(boolean forceRead) {
        this.forceRead = forceRead;
        return this;
    }

    public RandomAccessSourceFactory setUsePlainRandomAccess(boolean usePlainRandomAccess) {
        this.usePlainRandomAccess = usePlainRandomAccess;
        return this;
    }

    public RandomAccessSourceFactory setExclusivelyLockFile(boolean exclusivelyLockFile) {
        this.exclusivelyLockFile = exclusivelyLockFile;
        return this;
    }

    public IRandomAccessSource createSource(byte[] data) {
        return new ArrayRandomAccessSource(data);
    }

    public IRandomAccessSource createSource(RandomAccessFile raf) throws IOException {
        return new RAFRandomAccessSource(raf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRandomAccessSource createSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            IRandomAccessSource iRandomAccessSource = this.createSource(stream);
            return iRandomAccessSource;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IRandomAccessSource createSource(InputStream inputStream) throws IOException {
        return this.createSource(StreamUtil.inputStreamToArray(inputStream));
    }

    public IRandomAccessSource createBestSource(String filename) throws IOException {
        File file = new File(filename);
        if (!file.canRead()) {
            if (filename.startsWith("file:/") || filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("jar:") || filename.startsWith("wsjar:") || filename.startsWith("wsjar:") || filename.startsWith("vfszip:")) {
                return this.createSource(new URL(filename));
            }
            return this.createByReadingToMemory(filename);
        }
        if (this.forceRead) {
            return this.createByReadingToMemory(new FileInputStream(filename));
        }
        String openMode = this.exclusivelyLockFile ? "rw" : "r";
        RandomAccessFile raf = new RandomAccessFile(file, openMode);
        if (this.exclusivelyLockFile) {
            raf.getChannel().lock();
        }
        if (this.usePlainRandomAccess) {
            return new RAFRandomAccessSource(raf);
        }
        try {
            if (raf.length() <= 0L) {
                return new RAFRandomAccessSource(raf);
            }
            try {
                return this.createBestSource(raf.getChannel());
            }
            catch (MapFailedException e) {
                return new RAFRandomAccessSource(raf);
            }
        }
        catch (Exception e) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public IRandomAccessSource createBestSource(FileChannel channel) throws IOException {
        if (channel.size() <= 0x4000000L) {
            return new GetBufferedRandomAccessSource(new FileChannelRandomAccessSource(channel));
        }
        return new GetBufferedRandomAccessSource(new PagedChannelRandomAccessSource(channel));
    }

    public IRandomAccessSource createRanged(IRandomAccessSource source, long[] ranges) throws IOException {
        IRandomAccessSource[] sources = new IRandomAccessSource[ranges.length / 2];
        for (int i = 0; i < ranges.length; i += 2) {
            sources[i / 2] = new WindowRandomAccessSource(source, ranges[i], ranges[i + 1]);
        }
        return new GroupedRandomAccessSource(sources);
    }

    private IRandomAccessSource createByReadingToMemory(String filename) throws IOException {
        InputStream stream = ResourceUtil.getResourceStream(filename);
        if (stream == null) {
            throw new IOException(MessageFormat.format("{0} not found as file or resource.", filename));
        }
        return this.createByReadingToMemory(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRandomAccessSource createByReadingToMemory(InputStream stream) throws IOException {
        try {
            ArrayRandomAccessSource arrayRandomAccessSource = new ArrayRandomAccessSource(StreamUtil.inputStreamToArray(stream));
            return arrayRandomAccessSource;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

