/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.FontCacheKey;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapByteCid;
import com.itextpdf.io.font.cmap.CMapCidToCodepoint;
import com.itextpdf.io.font.cmap.CMapCidUni;
import com.itextpdf.io.font.cmap.CMapCodepointToCid;
import com.itextpdf.io.font.cmap.CMapLocationResource;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.font.cmap.CMapUniCid;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.io.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class FontCache {
    private static final Map<String, Map<String, Object>> allCidFonts = new LinkedHashMap<String, Map<String, Object>>();
    private static final Map<String, Set<String>> registryNames = new HashMap<String, Set<String>>();
    private static final String CJK_REGISTRY_FILENAME = "cjk_registry.properties";
    private static final String FONTS_PROP = "fonts";
    private static final String REGISTRY_PROP = "Registry";
    private static final String W_PROP = "W";
    private static final String W2_PROP = "W2";
    private static Map<FontCacheKey, FontProgram> fontCache = new ConcurrentHashMap<FontCacheKey, FontProgram>();

    protected static boolean isPredefinedCidFont(String fontName) {
        if (!registryNames.containsKey(FONTS_PROP)) {
            return false;
        }
        return registryNames.get(FONTS_PROP).contains(fontName);
    }

    public static String getCompatibleCidFont(String cmap) {
        for (Map.Entry<String, Set<String>> e : registryNames.entrySet()) {
            if (!e.getValue().contains(cmap)) continue;
            String registry = e.getKey();
            for (Map.Entry<String, Map<String, Object>> e1 : allCidFonts.entrySet()) {
                if (!registry.equals(e1.getValue().get(REGISTRY_PROP))) continue;
                return e1.getKey();
            }
        }
        return null;
    }

    public static Set<String> getCompatibleCmaps(String fontName) {
        Map<String, Object> cidFonts = FontCache.getAllPredefinedCidFonts().get(fontName);
        if (cidFonts == null) {
            return null;
        }
        String registry = (String)cidFonts.get(REGISTRY_PROP);
        return registryNames.get(registry);
    }

    public static Map<String, Map<String, Object>> getAllPredefinedCidFonts() {
        return allCidFonts;
    }

    public static Map<String, Set<String>> getRegistryNames() {
        return registryNames;
    }

    public static CMapCidUni getCid2UniCmap(String uniMap) {
        CMapCidUni cidUni = new CMapCidUni();
        return FontCache.parseCmap(uniMap, cidUni);
    }

    public static CMapUniCid getUni2CidCmap(String uniMap) {
        return FontCache.parseCmap(uniMap, new CMapUniCid());
    }

    public static CMapByteCid getByte2CidCmap(String cmap) {
        CMapByteCid uniCid = new CMapByteCid();
        return FontCache.parseCmap(cmap, uniCid);
    }

    public static CMapCidToCodepoint getCidToCodepointCmap(String cmap) {
        CMapCidToCodepoint cidByte = new CMapCidToCodepoint();
        return FontCache.parseCmap(cmap, cidByte);
    }

    public static CMapCodepointToCid getCodepointToCidCmap(String uniMap) {
        return FontCache.parseCmap(uniMap, new CMapCodepointToCid());
    }

    public static void clearSavedFonts() {
        fontCache.clear();
    }

    public static FontProgram getFont(String fontName) {
        return fontCache.get(FontCacheKey.create(fontName));
    }

    static FontProgram getFont(FontCacheKey key) {
        return fontCache.get(key);
    }

    public static FontProgram saveFont(FontProgram font, String fontName) {
        return FontCache.saveFont(font, FontCacheKey.create(fontName));
    }

    static FontProgram saveFont(FontProgram font, FontCacheKey key) {
        FontProgram fontFound = fontCache.get(key);
        if (fontFound != null) {
            return fontFound;
        }
        fontCache.put(key, font);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRegistry() throws IOException {
        try (InputStream resource = ResourceUtil.getResourceStream("com/itextpdf/io/font/cmap/cjk_registry.properties");){
            Properties p = new Properties();
            p.load(resource);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String value = (String)entry.getValue();
                String[] splitValue = value.split(" ");
                HashSet<String> set = new HashSet<String>();
                for (String s : splitValue) {
                    if (s.length() == 0) continue;
                    set.add(s);
                }
                registryNames.put((String)entry.getKey(), set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> readFontProperties(String name) throws IOException {
        try (InputStream resource = ResourceUtil.getResourceStream("com/itextpdf/io/font/cmap/" + name + ".properties");){
            Properties p = new Properties();
            p.load(resource);
            HashMap<String, Object> fontProperties = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                fontProperties.put((String)entry.getKey(), entry.getValue());
            }
            fontProperties.put(W_PROP, FontCache.createMetric((String)fontProperties.get(W_PROP)));
            fontProperties.put(W2_PROP, FontCache.createMetric((String)fontProperties.get(W2_PROP)));
            HashMap<String, Object> hashMap = fontProperties;
            return hashMap;
        }
    }

    private static IntHashtable createMetric(String s) {
        IntHashtable h = new IntHashtable();
        StringTokenizer tk = new StringTokenizer(s);
        while (tk.hasMoreTokens()) {
            int n1 = Integer.parseInt(tk.nextToken());
            h.put(n1, Integer.parseInt(tk.nextToken()));
        }
        return h;
    }

    private static <T extends AbstractCMap> T parseCmap(String name, T cmap) {
        try {
            CMapParser.parseCid(name, cmap, new CMapLocationResource());
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException("I/O exception.", e);
        }
        return cmap;
    }

    static {
        try {
            FontCache.loadRegistry();
            for (String font : registryNames.get(FONTS_PROP)) {
                allCidFonts.put(font, FontCache.readFontProperties(font));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

