/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.action;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFileAttachmentAnnotation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTarget
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -5814265943827690509L;

    private PdfTarget(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfTarget create(PdfDictionary pdfObject) {
        return new PdfTarget(pdfObject);
    }

    private static PdfTarget create(PdfName r) {
        PdfTarget pdfTarget = new PdfTarget(new PdfDictionary());
        pdfTarget.put(PdfName.R, r);
        return pdfTarget;
    }

    public static PdfTarget createParentTarget() {
        return PdfTarget.create(PdfName.P);
    }

    public static PdfTarget createChildTarget() {
        return PdfTarget.create(PdfName.C);
    }

    public static PdfTarget createChildTarget(String embeddedFileName) {
        return PdfTarget.create(PdfName.C).put(PdfName.N, new PdfString(embeddedFileName));
    }

    public static PdfTarget createChildTarget(String namedDestination, String annotationIdentifier) {
        return PdfTarget.create(PdfName.C).put(PdfName.P, new PdfString(namedDestination)).put(PdfName.A, new PdfString(annotationIdentifier));
    }

    public static PdfTarget createChildTarget(int pageNumber, int annotationIndex) {
        return PdfTarget.create(PdfName.C).put(PdfName.P, new PdfNumber(pageNumber - 1)).put(PdfName.A, new PdfNumber(annotationIndex));
    }

    public PdfTarget setName(String name) {
        return this.put(PdfName.N, new PdfString(name));
    }

    public String getName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.N).toString();
    }

    public PdfTarget setAnnotation(PdfFileAttachmentAnnotation pdfAnnotation, PdfDocument pdfDocument) {
        PdfPage page = pdfAnnotation.getPage();
        if (null == page) {
            throw new PdfException("Annotation shall have reference to page.");
        }
        this.put(PdfName.P, new PdfNumber(pdfDocument.getPageNumber(page) - 1));
        int indexOfAnnotation = -1;
        List<PdfAnnotation> annots = page.getAnnotations();
        for (int i = 0; i < annots.size(); ++i) {
            if (annots.get(i) == null || !((PdfDictionary)pdfAnnotation.getPdfObject()).equals(annots.get(i).getPdfObject())) continue;
            indexOfAnnotation = i;
            break;
        }
        this.put(PdfName.A, new PdfNumber(indexOfAnnotation));
        return this;
    }

    public PdfFileAttachmentAnnotation getAnnotation(PdfDocument pdfDocument) {
        PdfNameTree destsTree;
        Map<String, PdfObject> dests;
        PdfArray pdfArray;
        PdfObject pValue = ((PdfDictionary)this.getPdfObject()).get(PdfName.P);
        PdfPage page = null;
        if (pValue instanceof PdfNumber) {
            page = pdfDocument.getPage(((PdfNumber)pValue).intValue() + 1);
        } else if (pValue instanceof PdfString && null != (pdfArray = (PdfArray)(dests = (destsTree = pdfDocument.getCatalog().getNameTree(PdfName.Dests)).getNames()).get(((PdfString)pValue).getValue()))) {
            page = pdfArray.get(0) instanceof PdfNumber ? pdfDocument.getPage(((PdfNumber)pdfArray.get(0)).intValue()) : pdfDocument.getPage((PdfDictionary)pdfArray.get(0));
        }
        List<PdfAnnotation> pageAnnotations = null;
        if (null != page) {
            pageAnnotations = page.getAnnotations();
        }
        PdfObject aValue = ((PdfDictionary)this.getPdfObject()).get(PdfName.A);
        PdfFileAttachmentAnnotation resultAnnotation = null;
        if (null != pageAnnotations) {
            if (aValue instanceof PdfNumber) {
                resultAnnotation = (PdfFileAttachmentAnnotation)pageAnnotations.get(((PdfNumber)aValue).intValue());
            } else if (aValue instanceof PdfString) {
                for (PdfAnnotation annotation : pageAnnotations) {
                    if (!aValue.equals(annotation.getName())) continue;
                    resultAnnotation = (PdfFileAttachmentAnnotation)annotation;
                    break;
                }
            }
        }
        if (null == resultAnnotation) {
            Logger logger = LoggerFactory.getLogger(PdfTarget.class);
            logger.error("Some fields in target dictionary are not set or incorrect. Null will be returned.");
        }
        return resultAnnotation;
    }

    public PdfTarget setTarget(PdfTarget target) {
        return this.put(PdfName.T, (PdfObject)target.getPdfObject());
    }

    public PdfTarget getTarget() {
        PdfDictionary targetDictObject = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.T);
        return targetDictObject != null ? new PdfTarget(targetDictObject) : null;
    }

    public PdfTarget put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

