/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.GreekAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.ListItemRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import java.io.IOException;
import java.util.ArrayList;

public class ListRenderer
extends BlockRenderer {
    public ListRenderer(List modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        if (!this.hasOwnProperty(40)) {
            ArrayList<Object> symbolRenderers = new ArrayList<Object>();
            int listItemNum = this.getProperty(36, 1);
            for (int i = 0; i < this.childRenderers.size(); ++i) {
                if (!(((IRenderer)this.childRenderers.get(i)).getModelElement() instanceof ListItem)) continue;
                IRenderer currentSymbolRenderer = this.makeListSymbolRenderer(listItemNum++, (IRenderer)this.childRenderers.get(i));
                symbolRenderers.add(currentSymbolRenderer);
                LayoutResult layoutResult = currentSymbolRenderer.layout(layoutContext);
                if (layoutResult.getStatus() == 1) continue;
                return new LayoutResult(3, null, null, this);
            }
            float maxSymbolWidth = 0.0f;
            for (IRenderer iRenderer : symbolRenderers) {
                maxSymbolWidth = Math.max(maxSymbolWidth, iRenderer.getOccupiedArea().getBBox().getWidth());
            }
            Float symbolIndent = (Float)this.modelElement.getProperty(39);
            listItemNum = 0;
            for (IRenderer childRenderer : this.childRenderers) {
                childRenderer.deleteOwnProperty(44);
                childRenderer.setProperty(44, Float.valueOf(childRenderer.getProperty(44, Float.valueOf(0.0f)).floatValue() + maxSymbolWidth + (symbolIndent != null ? symbolIndent.floatValue() : 0.0f)));
                if (!(childRenderer.getModelElement() instanceof ListItem)) continue;
                IRenderer symbolRenderer = (IRenderer)symbolRenderers.get(listItemNum++);
                ((ListItemRenderer)childRenderer).addSymbolRenderer(symbolRenderer, maxSymbolWidth);
            }
        }
        return super.layout(layoutContext);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ListRenderer((List)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = super.createSplitRenderer(layoutResult);
        splitRenderer.setProperty(40, true);
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = super.createOverflowRenderer(layoutResult);
        overflowRenderer.setProperty(40, true);
        return overflowRenderer;
    }

    protected IRenderer makeListSymbolRenderer(int index, IRenderer renderer) {
        Object defaultListSymbol = renderer.getProperty(37);
        if (defaultListSymbol instanceof Text) {
            return new TextRenderer((Text)defaultListSymbol).setParent(this);
        }
        if (defaultListSymbol instanceof Image) {
            return new ImageRenderer((Image)defaultListSymbol).setParent(this);
        }
        if (defaultListSymbol instanceof ListNumberingType) {
            IRenderer textRenderer;
            String numberText;
            ListNumberingType numberingType = (ListNumberingType)((Object)defaultListSymbol);
            switch (numberingType) {
                case DECIMAL: {
                    numberText = String.valueOf(index);
                    break;
                }
                case ROMAN_LOWER: {
                    numberText = RomanNumbering.toRomanLowerCase((int)index);
                    break;
                }
                case ROMAN_UPPER: {
                    numberText = RomanNumbering.toRomanUpperCase((int)index);
                    break;
                }
                case ENGLISH_LOWER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase((int)index);
                    break;
                }
                case ENGLISH_UPPER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase((int)index);
                    break;
                }
                case GREEK_LOWER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberLowerCase((int)index);
                    break;
                }
                case GREEK_UPPER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberUpperCase((int)index);
                    break;
                }
                case ZAPF_DINGBATS_1: {
                    numberText = String.valueOf((char)(index + 171));
                    break;
                }
                case ZAPF_DINGBATS_2: {
                    numberText = String.valueOf((char)(index + 181));
                    break;
                }
                case ZAPF_DINGBATS_3: {
                    numberText = String.valueOf((char)(index + 191));
                    break;
                }
                case ZAPF_DINGBATS_4: {
                    numberText = String.valueOf((char)(index + 201));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Text textElement = new Text(renderer.getProperty(41) + numberText + renderer.getProperty(42));
            if (numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER || numberingType == ListNumberingType.ZAPF_DINGBATS_1 || numberingType == ListNumberingType.ZAPF_DINGBATS_2 || numberingType == ListNumberingType.ZAPF_DINGBATS_3 || numberingType == ListNumberingType.ZAPF_DINGBATS_4) {
                final String constantFont = numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER ? "Symbol" : "ZapfDingbats";
                textRenderer = new TextRenderer(textElement){

                    @Override
                    public void draw(DrawContext drawContext) {
                        try {
                            this.setProperty(20, PdfFontFactory.createFont((String)constantFont));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        super.draw(drawContext);
                    }
                }.setParent(this);
                try {
                    textRenderer.setProperty(20, PdfFontFactory.createFont((String)constantFont));
                }
                catch (IOException iOException) {}
            } else {
                textRenderer = new TextRenderer(textElement).setParent(this);
            }
            return textRenderer;
        }
        throw new IllegalStateException();
    }
}

