/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FontFamilySplitter {
    private static final Pattern FONT_FAMILY_PATTERN = Pattern.compile("^ *([\\w-]+) *$");
    private static final Pattern FONT_FAMILY_PATTERN_QUOTED = Pattern.compile("^ *(('[\\w -]+')|(\"[\\w -]+\")) *$");
    private static final Pattern FONT_FAMILY_PATTERN_QUOTED_SELECT = Pattern.compile("[\\w-]+( +[\\w-]+)*");

    public static List<String> splitFontFamily(String fontFamilies) {
        if (fontFamilies == null) {
            return null;
        }
        String[] names = fontFamilies.split(",");
        ArrayList<String> result = new ArrayList<String>(names.length);
        for (String name : names) {
            Matcher selectMatcher;
            if (FONT_FAMILY_PATTERN.matcher(name).matches()) {
                result.add(name.trim());
                continue;
            }
            if (!FONT_FAMILY_PATTERN_QUOTED.matcher(name).matches() || !(selectMatcher = FONT_FAMILY_PATTERN_QUOTED_SELECT.matcher(name)).find()) continue;
            result.add(selectMatcher.group());
        }
        return result;
    }

    public static String removeQuotes(String fontFamily) {
        Matcher selectMatcher = FONT_FAMILY_PATTERN_QUOTED_SELECT.matcher(fontFamily);
        if (selectMatcher.find()) {
            return selectMatcher.group();
        }
        return null;
    }
}

