/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.property.LineHeight;
import com.itextpdf.layout.property.RenderingMode;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.TextRenderer;

class LineHeightHelper {
    private static float DEFAULT_LINE_HEIGHT_COEFF = 1.15f;

    private LineHeightHelper() {
    }

    static float[] getActualAscenderDescender(AbstractRenderer renderer) {
        float lineHeight = LineHeightHelper.calculateLineHeight(renderer);
        float[] fontAscenderDescender = LineHeightHelper.getFontAscenderDescenderNormalized(renderer);
        float leading = lineHeight - (fontAscenderDescender[0] - fontAscenderDescender[1]);
        float ascender = fontAscenderDescender[0] + leading / 2.0f;
        float descender = fontAscenderDescender[1] - leading / 2.0f;
        return new float[]{ascender, descender};
    }

    static float[] getFontAscenderDescenderNormalized(AbstractRenderer renderer) {
        PdfFont font = renderer.resolveFirstPdfFont();
        float fontSize = renderer.getPropertyAsUnitValue(24).getValue();
        float[] fontAscenderDescenderFromMetrics = TextRenderer.calculateAscenderDescender(font, RenderingMode.HTML_MODE);
        float fontAscender = fontAscenderDescenderFromMetrics[0] / 1000.0f * fontSize;
        float fontDescender = fontAscenderDescenderFromMetrics[1] / 1000.0f * fontSize;
        return new float[]{fontAscender, fontDescender};
    }

    static float calculateLineHeight(AbstractRenderer renderer) {
        float lineHeightValue;
        LineHeight lineHeight = (LineHeight)renderer.getProperty(124);
        float fontSize = renderer.getPropertyAsUnitValue(24).getValue();
        if (lineHeight == null || lineHeight.isNormalValue() || lineHeight.getValue() < 0.0f) {
            lineHeightValue = DEFAULT_LINE_HEIGHT_COEFF * fontSize;
            float[] fontAscenderDescender = LineHeightHelper.getFontAscenderDescenderNormalized(renderer);
            float fontAscenderDescenderSum = fontAscenderDescender[0] - fontAscenderDescender[1];
            if (fontAscenderDescenderSum > lineHeightValue) {
                lineHeightValue = fontAscenderDescenderSum;
            }
        } else {
            lineHeightValue = lineHeight.isFixedValue() ? lineHeight.getValue() : lineHeight.getValue() * fontSize;
        }
        return lineHeightValue;
    }
}

