/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.tagutils.WaitingTagsManager;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.HashSet;
import java.util.Set;

class TableTaggingPriorToOneFiveVersionRule
implements ITaggingRule {
    private Set<TaggingHintKey> finishForbidden = new HashSet<TaggingHintKey>();

    TableTaggingPriorToOneFiveVersionRule() {
    }

    @Override
    public boolean onTagFinish(LayoutTaggingHelper taggingHelper, TaggingHintKey taggingHintKey) {
        String role;
        if (taggingHintKey.getAccessibleElement() != null && ("THead".equals(role = taggingHintKey.getAccessibleElement().getAccessibilityProperties().getRole()) || "TFoot".equals(role))) {
            this.finishForbidden.add(taggingHintKey);
            return false;
        }
        for (TaggingHintKey hint : taggingHelper.getAccessibleKidsHint(taggingHintKey)) {
            String role2 = hint.getAccessibleElement().getAccessibilityProperties().getRole();
            if (!"TBody".equals(role2) && !"THead".equals(role2) && !"TFoot".equals(role2)) continue;
            this.removeTagUnavailableInPriorToOneDotFivePdf(hint, taggingHelper);
        }
        return true;
    }

    private void removeTagUnavailableInPriorToOneDotFivePdf(TaggingHintKey taggingHintKey, LayoutTaggingHelper taggingHelper) {
        taggingHelper.replaceKidHint(taggingHintKey, taggingHelper.getAccessibleKidsHint(taggingHintKey));
        PdfDocument pdfDocument = taggingHelper.getPdfDocument();
        WaitingTagsManager waitingTagsManager = pdfDocument.getTagStructureContext().getWaitingTagsManager();
        TagTreePointer tagPointer = new TagTreePointer(pdfDocument);
        if (waitingTagsManager.tryMovePointerToWaitingTag(tagPointer, (Object)taggingHintKey)) {
            waitingTagsManager.removeWaitingState((Object)taggingHintKey);
            tagPointer.removeTag();
        }
        if (this.finishForbidden.remove(taggingHintKey)) {
            taggingHintKey.setFinished();
        }
    }
}

