/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.headings;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HeadingsChecker {
    private static final Pattern Hn_PATTERN = Pattern.compile("^H([1-6])$");
    private final PdfUAValidationContext context;
    private final Set<IRenderer> hRendererParents = new HashSet<IRenderer>();
    private final Set<PdfDictionary> hPdfDictParents = new HashSet<PdfDictionary>();
    private int previousHn = -1;
    private boolean wasAtLeastOneH = false;

    public HeadingsChecker(PdfUAValidationContext context) {
        this.context = context;
    }

    public void checkLayoutElement(Object rendererObj) {
        IRenderer renderer = (IRenderer)rendererObj;
        IPropertyContainer element = renderer.getModelElement();
        if (element instanceof IAccessibleElement) {
            IAccessibleElement accessibleElement = (IAccessibleElement)element;
            String role = this.context.resolveToStandardRole(accessibleElement.getAccessibilityProperties().getRole());
            this.checkHnSequence(role);
            if ("H".equals(role)) {
                IRenderer parent = renderer.getParent();
                if (this.hRendererParents.contains(parent)) {
                    throw new PdfUAConformanceException("A node contains more than one H tag.");
                }
                if (parent != null) {
                    this.hRendererParents.add(parent);
                }
            }
            this.checkHAndHnUsing(role);
        }
    }

    public void checkStructElement(IStructureNode structNode) {
        String role = this.context.resolveToStandardRole(structNode);
        if (role == null) {
            return;
        }
        this.checkHnSequence(role);
        if ("H".equals(role)) {
            PdfDictionary parent = HeadingsChecker.extractPdfDictFromNode(structNode.getParent());
            if (this.hPdfDictParents.contains(parent)) {
                throw new PdfUAConformanceException("A node contains more than one H tag.");
            }
            if (parent != null) {
                this.hPdfDictParents.add(parent);
            }
        }
        this.checkHAndHnUsing(role);
    }

    private void checkHnSequence(String role) {
        int currHn = HeadingsChecker.extractNumber(role);
        if (currHn != -1) {
            if (this.previousHn == -1) {
                if (currHn != 1) {
                    throw new PdfUAConformanceException("Heading level 1 is skipped in a descending sequence of header levels.");
                }
            } else if (currHn - this.previousHn > 1) {
                throw new PdfUAConformanceException(MessageFormatUtil.format((String)"Heading level {0} is skipped in a descending sequence of header levels.", (Object[])new Object[]{this.previousHn + 1}));
            }
            this.previousHn = currHn;
        }
    }

    private void checkHAndHnUsing(String role) {
        if ("H".equals(role)) {
            this.wasAtLeastOneH = true;
        }
        if (this.wasAtLeastOneH && this.previousHn != -1) {
            throw new PdfUAConformanceException("Document uses both H and H# tags.");
        }
    }

    private static int extractNumber(String heading) {
        if (heading == null) {
            return -1;
        }
        Matcher matcher = Hn_PATTERN.matcher(heading);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private static PdfDictionary extractPdfDictFromNode(IStructureNode node) {
        if (node instanceof PdfStructTreeRoot) {
            return (PdfDictionary)((PdfStructTreeRoot)node).getPdfObject();
        }
        if (node instanceof PdfStructElem) {
            return (PdfDictionary)((PdfStructElem)node).getPdfObject();
        }
        return null;
    }

    public static class HeadingHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final HeadingsChecker checker;

        public HeadingHandler(PdfUAValidationContext context) {
            super(context);
            this.checker = new HeadingsChecker(context);
        }

        public void nextElement(IStructureNode elem) {
            this.checker.checkStructElement(elem);
        }
    }
}

