/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.AbstractResultMatrix;
import com.itextpdf.pdfua.checkers.utils.tables.TableCellIterator;
import java.util.ArrayList;
import java.util.List;

final class CellResultMatrix
extends AbstractResultMatrix<Cell> {
    public CellResultMatrix(Table table, PdfUAValidationContext context) {
        super(new TableCellIterator(table, context));
    }

    @Override
    List<byte[]> getHeaders(Cell cell) {
        PdfObject headerArray = CellResultMatrix.getAttribute(cell.getAccessibilityProperties(), PdfName.Headers);
        if (headerArray == null) {
            return null;
        }
        if (!headerArray.isArray()) {
            return new ArrayList<byte[]>();
        }
        PdfArray array = (PdfArray)headerArray;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (PdfObject pdfObject : array) {
            result.add(((PdfString)pdfObject).getValueBytes());
        }
        return result;
    }

    @Override
    String getScope(Cell cell) {
        PdfName pdfStr = (PdfName)CellResultMatrix.getAttribute(cell.getAccessibilityProperties(), PdfName.Scope);
        return pdfStr == null ? null : pdfStr.getValue();
    }

    @Override
    byte[] getElementId(Cell cell) {
        return cell.getAccessibilityProperties().getStructureElementId();
    }

    @Override
    String getRole(Cell cell) {
        return ((TableCellIterator)this.iterator).context.resolveToStandardRole(cell.getAccessibilityProperties().getRole());
    }

    private static PdfObject getAttribute(AccessibilityProperties props, PdfName name) {
        for (PdfStructureAttributes attributes : props.getAttributesList()) {
            PdfObject obj = ((PdfDictionary)attributes.getPdfObject()).get(name);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }
}

