/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.SignatureUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtvVerification {
    private Logger LOGGER = LoggerFactory.getLogger(LtvVerification.class);
    private PdfDocument document;
    private SignatureUtil sgnUtil;
    private PdfAcroForm acroForm;
    private Map<PdfName, ValidationData> validated = new HashMap<PdfName, ValidationData>();
    private boolean used = false;
    private String securityProviderCode = null;

    public LtvVerification(PdfDocument document) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)true);
        this.sgnUtil = new SignatureUtil(document);
    }

    public LtvVerification(PdfDocument document, String securityProviderCode) {
        this(document);
        this.securityProviderCode = securityProviderCode;
    }

    public boolean addVerification(String signatureName, IOcspClient ocsp, ICrlClient crl, CertificateOption certOption, Level level, CertificateInclusion certInclude) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("Verification already output.");
        }
        PdfPKCS7 pk = this.sgnUtil.readSignatureData(signatureName, this.securityProviderCode);
        this.LOGGER.info("Adding verification for " + signatureName);
        Certificate[] xc = pk.getCertificates();
        X509Certificate signingCert = pk.getSigningCertificate();
        ValidationData vd = new ValidationData();
        for (int k = 0; k < xc.length; ++k) {
            Collection<byte[]> cims;
            X509Certificate cert = (X509Certificate)xc[k];
            this.LOGGER.info("Certificate: " + cert.getSubjectDN());
            if (certOption == CertificateOption.SIGNING_CERTIFICATE && !cert.equals(signingCert)) continue;
            byte[] ocspEnc = null;
            if (ocsp != null && level != Level.CRL && (ocspEnc = ocsp.getEncoded(cert, this.getParent(cert, xc), null)) != null) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocspEnc));
                this.LOGGER.info("OCSP added");
            }
            if (crl != null && (level == Level.CRL || level == Level.OCSP_CRL || level == Level.OCSP_OPTIONAL_CRL && ocspEnc == null) && (cims = crl.getEncoded(cert, null)) != null) {
                for (byte[] cim : cims) {
                    boolean dup = false;
                    for (byte[] b : vd.crls) {
                        if (!Arrays.equals(b, cim)) continue;
                        dup = true;
                        break;
                    }
                    if (dup) continue;
                    vd.crls.add(cim);
                    this.LOGGER.info("CRL added");
                }
            }
            if (certInclude != CertificateInclusion.YES) continue;
            vd.certs.add(cert.getEncoded());
        }
        if (vd.crls.size() == 0 && vd.ocsps.size() == 0) {
            return false;
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private X509Certificate getParent(X509Certificate cert, Certificate[] certs) {
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate parent = (X509Certificate)certs[i];
            if (!cert.getIssuerDN().equals(parent.getSubjectDN())) continue;
            try {
                cert.verify(parent.getPublicKey());
                return parent;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean addVerification(String signatureName, Collection<byte[]> ocsps, Collection<byte[]> crls, Collection<byte[]> certs) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("Verification already output.");
        }
        ValidationData vd = new ValidationData();
        if (ocsps != null) {
            for (byte[] ocsp : ocsps) {
                vd.ocsps.add(LtvVerification.buildOCSPResponse(ocsp));
            }
        }
        if (crls != null) {
            for (byte[] crl : crls) {
                vd.crls.add(crl);
            }
        }
        if (certs != null) {
            for (byte[] cert : certs) {
                vd.certs.add(cert);
            }
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    private static byte[] buildOCSPResponse(byte[] basicOcspResponse) throws IOException {
        DEROctetString doctet = new DEROctetString(basicOcspResponse);
        OCSPResponseStatus respStatus = new OCSPResponseStatus(0);
        ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1OctetString)doctet);
        OCSPResponse ocspResponse = new OCSPResponse(respStatus, responseBytes);
        return new OCSPResp(ocspResponse).getEncoded();
    }

    private PdfName getSignatureHashKey(String signatureName) throws NoSuchAlgorithmException, IOException {
        PdfSignature sig = this.sgnUtil.getSignature(signatureName);
        PdfString contents = sig.getContents();
        byte[] bc = PdfEncodings.convertToBytes((String)contents.getValue(), null);
        byte[] bt = null;
        if (PdfName.ETSI_RFC3161.equals((Object)sig.getSubFilter())) {
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(bc));
            ASN1Primitive pkcs = din.readObject();
            bc = pkcs.getEncoded();
        }
        bt = LtvVerification.hashBytesSha1(bc);
        return new PdfName(LtvVerification.convertToHex(bt));
    }

    private static byte[] hashBytesSha1(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest sh = MessageDigest.getInstance("SHA1");
        return sh.digest(b);
    }

    public void merge() {
        if (this.used || this.validated.size() == 0) {
            return;
        }
        this.used = true;
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        PdfObject dss = catalog.get(PdfName.DSS);
        if (dss == null) {
            this.createDss();
        } else {
            this.updateDss();
        }
    }

    private void updateDss() {
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        catalog.setModified();
        PdfDictionary dss = catalog.getAsDictionary(PdfName.DSS);
        PdfArray ocsps = dss.getAsArray(PdfName.OCSPs);
        PdfArray crls = dss.getAsArray(PdfName.CRLs);
        PdfArray certs = dss.getAsArray(PdfName.Certs);
        dss.remove(PdfName.OCSPs);
        dss.remove(PdfName.CRLs);
        dss.remove(PdfName.Certs);
        PdfDictionary vrim = dss.getAsDictionary(PdfName.VRI);
        if (vrim != null) {
            for (PdfName n : vrim.keySet()) {
                PdfDictionary vri;
                if (!this.validated.containsKey(n) || (vri = vrim.getAsDictionary(n)) == null) continue;
                LtvVerification.deleteOldReferences(ocsps, vri.getAsArray(PdfName.OCSP));
                LtvVerification.deleteOldReferences(crls, vri.getAsArray(PdfName.CRL));
                LtvVerification.deleteOldReferences(certs, vri.getAsArray(PdfName.Cert));
            }
        }
        if (ocsps == null) {
            ocsps = new PdfArray();
        }
        if (crls == null) {
            crls = new PdfArray();
        }
        if (certs == null) {
            certs = new PdfArray();
        }
        if (vrim == null) {
            vrim = new PdfDictionary();
        }
        this.outputDss(dss, vrim, ocsps, crls, certs);
    }

    private static void deleteOldReferences(PdfArray all, PdfArray toDelete) {
        if (all == null || toDelete == null) {
            return;
        }
        for (PdfObject pi : toDelete) {
            PdfIndirectReference pir = pi.getIndirectReference();
            if (pir == null) continue;
            for (int k = 0; k < all.size(); ++k) {
                PdfIndirectReference pod = all.get(k).getIndirectReference();
                if (pod == null || pir.getObjNumber() != pod.getObjNumber()) continue;
                all.remove(k);
                --k;
            }
        }
    }

    private void createDss() {
        this.outputDss(new PdfDictionary(), new PdfDictionary(), new PdfArray(), new PdfArray(), new PdfArray());
    }

    private void outputDss(PdfDictionary dss, PdfDictionary vrim, PdfArray ocsps, PdfArray crls, PdfArray certs) {
        PdfCatalog catalog = this.document.getCatalog();
        if (this.document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) < 0) {
            catalog.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        }
        for (PdfName vkey : this.validated.keySet()) {
            PdfStream ps;
            PdfArray ocsp = new PdfArray();
            PdfArray crl = new PdfArray();
            PdfArray cert = new PdfArray();
            PdfDictionary vri = new PdfDictionary();
            for (byte[] b : this.validated.get((Object)vkey).crls) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                crl.add((PdfObject)ps);
                crls.add((PdfObject)ps);
                crls.setModified();
            }
            for (byte[] b : this.validated.get((Object)vkey).ocsps) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ocsp.add((PdfObject)ps);
                ocsps.add((PdfObject)ps);
                ocsps.setModified();
            }
            for (byte[] b : this.validated.get((Object)vkey).certs) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                cert.add((PdfObject)ps);
                certs.add((PdfObject)ps);
                certs.setModified();
            }
            if (ocsp.size() > 0) {
                ocsp.makeIndirect(this.document);
                vri.put(PdfName.OCSP, (PdfObject)ocsp);
            }
            if (crl.size() > 0) {
                crl.makeIndirect(this.document);
                vri.put(PdfName.CRL, (PdfObject)crl);
            }
            if (cert.size() > 0) {
                cert.makeIndirect(this.document);
                vri.put(PdfName.Cert, (PdfObject)cert);
            }
            vri.makeIndirect(this.document);
            vrim.put(vkey, (PdfObject)vri);
        }
        vrim.makeIndirect(this.document);
        vrim.setModified();
        dss.put(PdfName.VRI, (PdfObject)vrim);
        if (ocsps.size() > 0) {
            ocsps.makeIndirect(this.document);
            dss.put(PdfName.OCSPs, (PdfObject)ocsps);
        }
        if (crls.size() > 0) {
            crls.makeIndirect(this.document);
            dss.put(PdfName.CRLs, (PdfObject)crls);
        }
        if (certs.size() > 0) {
            certs.makeIndirect(this.document);
            dss.put(PdfName.Certs, (PdfObject)certs);
        }
        dss.makeIndirect(this.document);
        dss.setModified();
        catalog.put(PdfName.DSS, (PdfObject)dss);
    }

    public static String convertToHex(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer();
        for (byte b : bytes) {
            buf.appendHex(b);
        }
        return PdfEncodings.convertToString((byte[])buf.toByteArray(), null).toUpperCase();
    }

    private static class ValidationData {
        public List<byte[]> crls = new ArrayList<byte[]>();
        public List<byte[]> ocsps = new ArrayList<byte[]>();
        public List<byte[]> certs = new ArrayList<byte[]>();

        private ValidationData() {
        }
    }

    public static enum CertificateInclusion {
        YES,
        NO;

    }

    public static enum CertificateOption {
        SIGNING_CERTIFICATE,
        WHOLE_CHAIN;

    }

    public static enum Level {
        OCSP,
        CRL,
        OCSP_CRL,
        OCSP_OPTIONAL_CRL;

    }
}

