/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.CrlClientOnline;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.IIssuingCertificateRetriever;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.LtvVerification;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import com.itextpdf.signatures.SignMetaInfo;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignatureUtil;
import com.itextpdf.signatures.SignerProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PdfPadesSigner {
    private static final String TEMP_FILE_NAME = "tempPdfFile";
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-512";
    private static final Object LOCK_OBJECT = new Object();
    private static long increment = 0L;
    private IOcspClient ocspClient = null;
    private ICrlClient crlClient;
    private IIssuingCertificateRetriever issuingCertificateRetriever = new IssuingCertificateRetriever();
    private int estimatedSize = 0;
    private String timestampSignatureName;
    private String temporaryDirectoryPath = null;
    private IExternalDigest externalDigest = new BouncyCastleDigest();
    private StampingProperties stampingProperties = new StampingProperties().useAppendMode();
    private StampingProperties stampingPropertiesWithMetaInfo = (StampingProperties)new StampingProperties().useAppendMode().setEventCountingMetaInfo((IMetaInfo)new SignMetaInfo());
    private ByteArrayOutputStream tempOutputStream;
    private File tempFile;
    private final Set<File> tempFiles = new HashSet<File>();
    private final PdfReader reader;
    private final OutputStream outputStream;

    public PdfPadesSigner(PdfReader reader, OutputStream outputStream) {
        this.reader = reader;
        this.outputStream = outputStream;
    }

    public void signWithBaselineBProfile(SignerProperties signerProperties, Certificate[] chain, IExternalSignature externalSignature) throws GeneralSecurityException, IOException {
        this.performSignDetached(signerProperties, true, externalSignature, chain, null);
    }

    public void signWithBaselineBProfile(SignerProperties signerProperties, Certificate[] chain, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        PrivateKeySignature externalSignature = new PrivateKeySignature(privateKey, this.getDigestAlgorithm(privateKey), FACTORY.getProviderName());
        this.signWithBaselineBProfile(signerProperties, chain, externalSignature);
    }

    public void signWithBaselineTProfile(SignerProperties signerProperties, Certificate[] chain, IExternalSignature externalSignature, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        this.performSignDetached(signerProperties, true, externalSignature, chain, tsaClient);
    }

    public void signWithBaselineTProfile(SignerProperties signerProperties, Certificate[] chain, PrivateKey privateKey, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        PrivateKeySignature externalSignature = new PrivateKeySignature(privateKey, this.getDigestAlgorithm(privateKey), FACTORY.getProviderName());
        this.signWithBaselineTProfile(signerProperties, chain, externalSignature, tsaClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signWithBaselineLTProfile(SignerProperties signerProperties, Certificate[] chain, IExternalSignature externalSignature, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        this.createRevocationClients(chain[0], true);
        try {
            this.performSignDetached(signerProperties, false, externalSignature, chain, tsaClient);
            try (InputStream inputStream = this.createInputStream();
                 PdfDocument pdfDocument = new PdfDocument(new PdfReader(inputStream), new PdfWriter(this.outputStream), this.stampingPropertiesWithMetaInfo);){
                this.performLtvVerification(pdfDocument, Collections.singletonList(signerProperties.getFieldName()), LtvVerification.RevocationDataNecessity.REQUIRED_FOR_SIGNING_CERTIFICATE);
            }
        }
        finally {
            this.deleteTempFiles();
        }
    }

    public void signWithBaselineLTProfile(SignerProperties signerProperties, Certificate[] chain, PrivateKey privateKey, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        PrivateKeySignature externalSignature = new PrivateKeySignature(privateKey, this.getDigestAlgorithm(privateKey), FACTORY.getProviderName());
        this.signWithBaselineLTProfile(signerProperties, chain, externalSignature, tsaClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signWithBaselineLTAProfile(SignerProperties signerProperties, Certificate[] chain, IExternalSignature externalSignature, ITSAClient tsaClient) throws IOException, GeneralSecurityException {
        this.createRevocationClients(chain[0], true);
        try {
            this.performSignDetached(signerProperties, false, externalSignature, chain, tsaClient);
            try (InputStream inputStream = this.createInputStream();
                 PdfDocument pdfDocument = new PdfDocument(new PdfReader(inputStream), new PdfWriter(this.createOutputStream()), this.stampingPropertiesWithMetaInfo);){
                this.performLtvVerification(pdfDocument, Collections.singletonList(signerProperties.getFieldName()), LtvVerification.RevocationDataNecessity.REQUIRED_FOR_SIGNING_CERTIFICATE);
                this.performTimestamping(pdfDocument, this.outputStream, tsaClient);
            }
        }
        finally {
            this.deleteTempFiles();
        }
    }

    public void signWithBaselineLTAProfile(SignerProperties signerProperties, Certificate[] chain, PrivateKey privateKey, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        PrivateKeySignature externalSignature = new PrivateKeySignature(privateKey, this.getDigestAlgorithm(privateKey), FACTORY.getProviderName());
        this.signWithBaselineLTAProfile(signerProperties, chain, externalSignature, tsaClient);
    }

    public void prolongSignatures(ITSAClient tsaClient) throws IOException, GeneralSecurityException {
        OutputStream documentOutputStream = tsaClient == null ? this.outputStream : this.createOutputStream();
        try (PdfDocument pdfDocument = new PdfDocument(this.reader, new PdfWriter(documentOutputStream), this.stampingProperties);){
            SignatureUtil signatureUtil = new SignatureUtil(pdfDocument);
            List<String> signatureNames = signatureUtil.getSignatureNames();
            if (signatureNames.isEmpty()) {
                throw new PdfException("Document doesn't contain any signatures to prolong.");
            }
            this.createRevocationClients(null, false);
            this.performLtvVerification(pdfDocument, signatureNames, LtvVerification.RevocationDataNecessity.OPTIONAL);
            if (tsaClient != null) {
                this.performTimestamping(pdfDocument, this.outputStream, tsaClient);
            }
        }
    }

    public void prolongSignatures() throws IOException, GeneralSecurityException {
        this.prolongSignatures(null);
    }

    public PdfPadesSigner setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
        return this;
    }

    public PdfPadesSigner setTimestampSignatureName(String timestampSignatureName) {
        this.timestampSignatureName = timestampSignatureName;
        return this;
    }

    public PdfPadesSigner setStampingProperties(StampingProperties stampingProperties) {
        this.stampingProperties = stampingProperties;
        if (stampingProperties.isEventCountingMetaInfoSet()) {
            this.stampingPropertiesWithMetaInfo = stampingProperties;
        }
        return this;
    }

    public PdfPadesSigner setEstimatedSize(int estimatedSize) {
        this.estimatedSize = estimatedSize;
        return this;
    }

    public PdfPadesSigner setOcspClient(IOcspClient ocspClient) {
        this.ocspClient = ocspClient;
        return this;
    }

    public PdfPadesSigner setCrlClient(ICrlClient crlClient) {
        this.crlClient = crlClient;
        return this;
    }

    public PdfPadesSigner setExternalDigest(IExternalDigest externalDigest) {
        this.externalDigest = externalDigest;
        return this;
    }

    public PdfPadesSigner setIssuingCertificateRetriever(IIssuingCertificateRetriever issuingCertificateRetriever) {
        this.issuingCertificateRetriever = issuingCertificateRetriever;
        return this;
    }

    public PdfPadesSigner setTrustedCertificates(List<Certificate> certificateList) {
        this.issuingCertificateRetriever.setTrustedCertificates(certificateList);
        return this;
    }

    void performTimestamping(PdfDocument document, OutputStream outputStream, ITSAClient tsaClient) throws IOException, GeneralSecurityException {
        PdfSigner timestampSigner = new PdfSigner(document, outputStream, this.tempOutputStream, this.tempFile);
        timestampSigner.timestamp(tsaClient, this.timestampSignatureName);
    }

    PdfSigner createPdfSigner(SignerProperties signerProperties, boolean isFinal) throws IOException {
        String tempFilePath = null;
        if (this.temporaryDirectoryPath != null) {
            tempFilePath = this.getNextTempFile().getAbsolutePath();
        }
        return new PdfSigner(this.reader, isFinal ? this.outputStream : this.createOutputStream(), tempFilePath, this.stampingProperties, signerProperties);
    }

    void performLtvVerification(PdfDocument pdfDocument, List<String> signatureNames, LtvVerification.RevocationDataNecessity revocationDataNecessity) throws IOException, GeneralSecurityException {
        LtvVerification ltvVerification = new LtvVerification(pdfDocument).setRevocationDataNecessity(revocationDataNecessity).setIssuingCertificateRetriever(this.issuingCertificateRetriever);
        for (String signatureName : signatureNames) {
            ltvVerification.addVerification(signatureName, this.ocspClient, this.crlClient, LtvVerification.CertificateOption.ALL_CERTIFICATES, LtvVerification.Level.OCSP_OPTIONAL_CRL, LtvVerification.CertificateInclusion.YES);
        }
        ltvVerification.merge();
    }

    void deleteTempFiles() {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
    }

    OutputStream createOutputStream() throws FileNotFoundException {
        if (this.temporaryDirectoryPath != null) {
            return FileUtil.getFileOutputStream((File)this.getNextTempFile());
        }
        this.tempOutputStream = new ByteArrayOutputStream();
        return this.tempOutputStream;
    }

    InputStream createInputStream() throws IOException {
        if (this.temporaryDirectoryPath != null) {
            return FileUtil.getInputStreamForFile((File)this.tempFile);
        }
        return new ByteArrayInputStream(this.tempOutputStream.toByteArray());
    }

    void createRevocationClients(Certificate signingCert, boolean clientsRequired) {
        X509Certificate signingCertificate;
        if (this.crlClient == null && this.ocspClient == null && clientsRequired && CertificateUtil.getOCSPURL(signingCertificate = (X509Certificate)signingCert) == null && CertificateUtil.getCRLURL(signingCertificate) == null) {
            throw new PdfException("Default implementation of OCSP and CRL clients cannot be created, because signing certificate doesn't contain revocation data sources. Please try to explicitly add OCSP or CRL client.");
        }
        if (this.crlClient == null) {
            this.crlClient = new CrlClientOnline();
        }
        if (this.ocspClient == null) {
            this.ocspClient = new OcspClientBouncyCastle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSignDetached(SignerProperties signerProperties, boolean isFinal, IExternalSignature externalSignature, Certificate[] chain, ITSAClient tsaClient) throws GeneralSecurityException, IOException {
        Certificate[] fullChain = this.issuingCertificateRetriever.retrieveMissingCertificates(chain);
        PdfSigner signer = this.createPdfSigner(signerProperties, isFinal);
        try {
            signer.signDetached(this.externalDigest, externalSignature, fullChain, null, null, tsaClient, this.estimatedSize, PdfSigner.CryptoStandard.CADES);
        }
        finally {
            signer.originalOS.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getNextTempFile() {
        if (!FileUtil.directoryExists((String)this.temporaryDirectoryPath)) {
            throw new PdfException(MessageFormatUtil.format((String)"Provided path: {0} is not a directory. Please provide a directory path to store temporary pdf files which are required for signing.", (Object[])new Object[]{this.temporaryDirectoryPath}));
        }
        Object object = LOCK_OBJECT;
        synchronized (object) {
            do {
                this.tempFile = new File(this.temporaryDirectoryPath + "/" + TEMP_FILE_NAME + ++increment + ".pdf");
            } while (this.tempFile.exists());
            this.tempFiles.add(this.tempFile);
        }
        return this.tempFile;
    }

    private String getDigestAlgorithm(PrivateKey privateKey) {
        String signatureAlgorithm;
        switch (signatureAlgorithm = SignUtils.getPrivateKeyAlgorithm(privateKey)) {
            case "Ed25519": {
                return DEFAULT_DIGEST_ALGORITHM;
            }
            case "Ed448": {
                return "SHAKE256";
            }
        }
        return DEFAULT_DIGEST_ALGORITHM;
    }
}

