/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.DocumentRevision;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

class DocumentRevisionsValidator {
    static final String DOC_MDP_CHECK = "DocMDP check.";
    static final String NOT_ALLOWED_CATALOG_CHANGES = "PDF document catalog contains changes other than DSS dictionary addition, which is not allowed.";
    static final String DSS_REMOVED = "DSS dictionary was removed from catalog.";
    static final String EXTENSIONS_REMOVED = "Extensions dictionary was removed from catalog.";
    static final String DEVELOPER_EXTENSION_REMOVED = "Developer extension \"{0}\" dictionary was removed or unexpectedly modified.";
    static final String EXTENSION_LEVEL_DECREASED = "Extension level number in developer extension \"{0}\" dictionary was decreased.";
    static final String OBJECT_REMOVED = "Object \"{0}\", which is not allowed to be removed, was removed from the document through XREF table.";
    static final String UNEXPECTED_ENTRY_IN_XREF = "New PDF document revision contains unexpected entry \"{0}\" in XREF table.";
    private IMetaInfo metaInfo;

    DocumentRevisionsValidator() {
    }

    public void setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    ValidationReport validateRevision(PdfDocument originalDocument, PdfDocument documentWithoutRevision, DocumentRevision revision) throws IOException {
        ValidationReport validationReport = new ValidationReport();
        try (InputStream inputStream = DocumentRevisionsValidator.createInputStreamFromRevision(originalDocument, revision);
             PdfReader newReader = new PdfReader(inputStream);
             PdfDocument documentWithRevision = new PdfDocument(newReader, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
            Set indirectReferences = revision.getModifiedObjects();
            if (!this.compareCatalogs(documentWithoutRevision, documentWithRevision, validationReport)) {
                ValidationReport validationReport2 = validationReport;
                return validationReport2;
            }
            List<ReferencesPair> allowedReferences = this.createAllowedReferences(documentWithRevision, documentWithoutRevision);
            for (PdfIndirectReference indirectReference : indirectReferences) {
                if (indirectReference.isFree()) {
                    boolean referenceWasInPrevDocument;
                    boolean referenceAllowedToBeRemoved = allowedReferences.stream().anyMatch(reference -> reference.getPreviousReference() != null && reference.getPreviousReference().getObjNumber() == indirectReference.getObjNumber() && (reference.getCurrentReference() == null || reference.getCurrentReference().getObjNumber() != indirectReference.getObjNumber()));
                    boolean bl = referenceWasInPrevDocument = documentWithoutRevision.getPdfObject(indirectReference.getObjNumber()) != null;
                    if (DocumentRevisionsValidator.isMaxGenerationObject(indirectReference) || !referenceWasInPrevDocument || referenceAllowedToBeRemoved) continue;
                    validationReport.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format((String)OBJECT_REMOVED, (Object[])new Object[]{indirectReference.getObjNumber()}), ReportItem.ReportItemStatus.INVALID));
                    continue;
                }
                if (this.checkAllowedReferences(allowedReferences, indirectReference, documentWithoutRevision)) continue;
                validationReport.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format((String)UNEXPECTED_ENTRY_IN_XREF, (Object[])new Object[]{indirectReference.getObjNumber()}), ReportItem.ReportItemStatus.INVALID));
            }
        }
        return validationReport;
    }

    private boolean checkAllowedReferences(List<ReferencesPair> allowedReferences, PdfIndirectReference indirectReference, PdfDocument documentWithoutRevision) {
        for (ReferencesPair allowedReference : allowedReferences) {
            if (!DocumentRevisionsValidator.isSameReference(allowedReference.getCurrentReference(), indirectReference)) continue;
            return documentWithoutRevision.getPdfObject(indirectReference.getObjNumber()) == null || allowedReferences.stream().anyMatch(reference -> DocumentRevisionsValidator.isSameReference(reference.getPreviousReference(), indirectReference));
        }
        return false;
    }

    private List<ReferencesPair> createAllowedReferences(PdfDocument documentWithRevision, PdfDocument documentWithoutRevision) {
        ArrayList<ReferencesPair> allowedReferences = new ArrayList<ReferencesPair>();
        if (documentWithRevision.getTrailer().get(PdfName.Info) != null) {
            allowedReferences.add(new ReferencesPair(documentWithRevision.getTrailer().get(PdfName.Info).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> documentWithoutRevision.getTrailer().get(PdfName.Info).getIndirectReference())));
        }
        if (documentWithRevision.getCatalog().getPdfObject() == null) {
            return allowedReferences;
        }
        allowedReferences.add(new ReferencesPair(((PdfDictionary)documentWithRevision.getCatalog().getPdfObject()).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> ((PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject()).getIndirectReference())));
        if (((PdfDictionary)documentWithRevision.getCatalog().getPdfObject()).get(PdfName.Metadata) != null) {
            allowedReferences.add(new ReferencesPair(((PdfDictionary)documentWithRevision.getCatalog().getPdfObject()).get(PdfName.Metadata).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> ((PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject()).get(PdfName.Metadata).getIndirectReference())));
        }
        PdfDictionary currentDssDictionary = ((PdfDictionary)documentWithRevision.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        PdfDictionary previousDssDictionary = ((PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        if (currentDssDictionary == null) {
            return allowedReferences;
        }
        allowedReferences.add(new ReferencesPair(currentDssDictionary.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getIndirectReference())));
        allowedReferences.addAll(this.createAllowedDssEntries(documentWithRevision, documentWithoutRevision));
        return allowedReferences;
    }

    private List<ReferencesPair> createAllowedDssEntries(PdfDocument documentWithRevision, PdfDocument documentWithoutRevision) {
        PdfDictionary vris;
        PdfArray crls;
        PdfArray ocsps;
        ArrayList<ReferencesPair> allowedReferences = new ArrayList<ReferencesPair>();
        PdfDictionary currentDssDictionary = ((PdfDictionary)documentWithRevision.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        PdfDictionary previousDssDictionary = ((PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        PdfArray certs = currentDssDictionary.getAsArray(PdfName.Certs);
        if (certs != null) {
            allowedReferences.add(new ReferencesPair(certs.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.get(PdfName.Certs).getIndirectReference())));
            for (int i = 0; i < certs.size(); ++i) {
                int finalI = i;
                allowedReferences.add(new ReferencesPair(certs.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsArray(PdfName.Certs).get(finalI).getIndirectReference())));
            }
        }
        if ((ocsps = currentDssDictionary.getAsArray(PdfName.OCSPs)) != null) {
            allowedReferences.add(new ReferencesPair(ocsps.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.get(PdfName.OCSPs).getIndirectReference())));
            for (int i = 0; i < ocsps.size(); ++i) {
                int finalI = i;
                allowedReferences.add(new ReferencesPair(ocsps.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsArray(PdfName.OCSPs).get(finalI).getIndirectReference())));
            }
        }
        if ((crls = currentDssDictionary.getAsArray(PdfName.CRLs)) != null) {
            allowedReferences.add(new ReferencesPair(crls.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.get(PdfName.CRLs).getIndirectReference())));
            for (int i = 0; i < crls.size(); ++i) {
                int finalI = i;
                allowedReferences.add(new ReferencesPair(crls.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsArray(PdfName.CRLs).get(finalI).getIndirectReference())));
            }
        }
        if ((vris = currentDssDictionary.getAsDictionary(PdfName.VRI)) != null) {
            allowedReferences.add(new ReferencesPair(vris.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.get(PdfName.VRI).getIndirectReference())));
            for (Map.Entry vri : vris.entrySet()) {
                PdfArray vriCrls;
                PdfArray vriOcsps;
                allowedReferences.add(new ReferencesPair(((PdfObject)vri.getValue()).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).get((PdfName)vri.getKey()).getIndirectReference())));
                if (!(vri.getValue() instanceof PdfDictionary)) continue;
                PdfDictionary vriDictionary = (PdfDictionary)vri.getValue();
                PdfArray vriCerts = vriDictionary.getAsArray(PdfName.Cert);
                if (vriCerts != null) {
                    allowedReferences.add(new ReferencesPair(vriCerts.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).get(PdfName.Cert).getIndirectReference())));
                    for (int i = 0; i < vriCerts.size(); ++i) {
                        int finalI = i;
                        allowedReferences.add(new ReferencesPair(vriCerts.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).getAsArray(PdfName.Cert).get(finalI).getIndirectReference())));
                    }
                }
                if ((vriOcsps = vriDictionary.getAsArray(PdfName.OCSP)) != null) {
                    allowedReferences.add(new ReferencesPair(vriOcsps.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).get(PdfName.OCSP).getIndirectReference())));
                    for (int i = 0; i < vriOcsps.size(); ++i) {
                        int finalI = i;
                        allowedReferences.add(new ReferencesPair(vriOcsps.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).getAsArray(PdfName.OCSP).get(finalI).getIndirectReference())));
                    }
                }
                if ((vriCrls = vriDictionary.getAsArray(PdfName.CRL)) != null) {
                    allowedReferences.add(new ReferencesPair(vriCrls.getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).get(PdfName.CRL).getIndirectReference())));
                    for (int i = 0; i < vriCrls.size(); ++i) {
                        int finalI = i;
                        allowedReferences.add(new ReferencesPair(vriCrls.get(i).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).getAsArray(PdfName.CRL).get(finalI).getIndirectReference())));
                    }
                }
                if (vriDictionary.get(new PdfName("TS")) == null) continue;
                allowedReferences.add(new ReferencesPair(vriDictionary.get(new PdfName("TS")).getIndirectReference(), DocumentRevisionsValidator.getIndirectReferenceOrNull(() -> previousDssDictionary.getAsDictionary(PdfName.VRI).getAsDictionary((PdfName)vri.getKey()).get(new PdfName("TS")).getIndirectReference())));
            }
        }
        return allowedReferences;
    }

    private boolean compareCatalogs(PdfDocument documentWithoutRevision, PdfDocument documentWithRevision, ValidationReport report) {
        PdfDictionary previousCatalog = (PdfDictionary)documentWithoutRevision.getCatalog().getPdfObject();
        PdfDictionary currentCatalog = (PdfDictionary)documentWithRevision.getCatalog().getPdfObject();
        PdfDictionary previousCatalogCopy = new PdfDictionary(previousCatalog);
        previousCatalogCopy.remove(PdfName.DSS);
        previousCatalogCopy.remove(PdfName.Extensions);
        previousCatalogCopy.remove(PdfName.Metadata);
        PdfDictionary currentCatalogCopy = new PdfDictionary(currentCatalog);
        currentCatalogCopy.remove(PdfName.DSS);
        currentCatalogCopy.remove(PdfName.Extensions);
        currentCatalogCopy.remove(PdfName.Metadata);
        if (!DocumentRevisionsValidator.comparePdfObjects((PdfObject)previousCatalogCopy, (PdfObject)currentCatalogCopy)) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, NOT_ALLOWED_CATALOG_CHANGES, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return this.compareExtensions(previousCatalog.get(PdfName.Extensions), currentCatalog.get(PdfName.Extensions), report) && this.compareDss(previousCatalog.get(PdfName.DSS), currentCatalog.get(PdfName.DSS), report);
    }

    private boolean compareExtensions(PdfObject previousExtensions, PdfObject currentExtensions, ValidationReport report) {
        if (previousExtensions == null || DocumentRevisionsValidator.comparePdfObjects(previousExtensions, currentExtensions)) {
            return true;
        }
        if (currentExtensions == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, EXTENSIONS_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        if (!(previousExtensions instanceof PdfDictionary) || !(currentExtensions instanceof PdfDictionary)) {
            return false;
        }
        PdfDictionary previousExtensionsDictionary = (PdfDictionary)previousExtensions;
        PdfDictionary currentExtensionsDictionary = (PdfDictionary)currentExtensions;
        for (Map.Entry previousExtension : previousExtensionsDictionary.entrySet()) {
            PdfDictionary currentExtension = currentExtensionsDictionary.getAsDictionary((PdfName)previousExtension.getKey());
            if (currentExtension == null) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format((String)DEVELOPER_EXTENSION_REMOVED, (Object[])new Object[]{previousExtension.getKey()}), ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            PdfDictionary currentExtensionCopy = new PdfDictionary(currentExtension);
            currentExtensionCopy.remove(PdfName.ExtensionLevel);
            PdfDictionary previousExtensionCopy = new PdfDictionary((PdfDictionary)previousExtension.getValue());
            previousExtensionCopy.remove(PdfName.ExtensionLevel);
            if (!DocumentRevisionsValidator.comparePdfObjects((PdfObject)previousExtensionCopy, (PdfObject)currentExtensionCopy)) {
                report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format((String)DEVELOPER_EXTENSION_REMOVED, (Object[])new Object[]{previousExtension.getKey()}), ReportItem.ReportItemStatus.INVALID));
                return false;
            }
            PdfNumber previousExtensionLevel = ((PdfDictionary)previousExtension.getValue()).getAsNumber(PdfName.ExtensionLevel);
            PdfNumber currentExtensionLevel = currentExtension.getAsNumber(PdfName.ExtensionLevel);
            if (previousExtensionLevel == null || currentExtensionLevel != null && previousExtensionLevel.intValue() <= currentExtensionLevel.intValue()) continue;
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, MessageFormatUtil.format((String)EXTENSION_LEVEL_DECREASED, (Object[])new Object[]{previousExtension.getKey()}), ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return true;
    }

    private boolean compareDss(PdfObject previousDss, PdfObject currentDss, ValidationReport report) {
        if (previousDss == null) {
            return true;
        }
        if (currentDss == null) {
            report.addReportItem(new ReportItem(DOC_MDP_CHECK, DSS_REMOVED, ReportItem.ReportItemStatus.INVALID));
            return false;
        }
        return true;
    }

    static InputStream createInputStreamFromRevision(PdfDocument originalDocument, DocumentRevision revision) {
        RandomAccessFileOrArray raf = originalDocument.getReader().getSafeFile();
        WindowRandomAccessSource source = new WindowRandomAccessSource(raf.createSourceView(), 0L, revision.getEofOffset());
        return new RASInputStream((IRandomAccessSource)source);
    }

    private static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2) {
        return DocumentRevisionsValidator.comparePdfObjects(pdfObject1, pdfObject2, new HashSet<PdfObject>());
    }

    private static boolean comparePdfObjects(PdfObject pdfObject1, PdfObject pdfObject2, Set<PdfObject> visitedObjects) {
        if (visitedObjects.contains(pdfObject1)) {
            return true;
        }
        visitedObjects.add(pdfObject1);
        if (Objects.equals(pdfObject1, pdfObject2)) {
            return true;
        }
        if (pdfObject1 == null || pdfObject2 == null) {
            return false;
        }
        if (pdfObject1.getClass() != pdfObject2.getClass()) {
            return false;
        }
        if (pdfObject1.getIndirectReference() == null ^ pdfObject2.getIndirectReference() == null) {
            return false;
        }
        switch (pdfObject1.getType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                return pdfObject1.equals(pdfObject2);
            }
            case 5: {
                return DocumentRevisionsValidator.comparePdfObjects(((PdfIndirectReference)pdfObject1).getRefersTo(), ((PdfIndirectReference)pdfObject2).getRefersTo(), visitedObjects);
            }
            case 1: {
                return DocumentRevisionsValidator.comparePdfArrays((PdfArray)pdfObject1, (PdfArray)pdfObject2, visitedObjects);
            }
            case 3: {
                return DocumentRevisionsValidator.comparePdfDictionaries((PdfDictionary)pdfObject1, (PdfDictionary)pdfObject2, visitedObjects);
            }
            case 9: {
                return DocumentRevisionsValidator.comparePdfStreams((PdfStream)pdfObject1, (PdfStream)pdfObject2, visitedObjects);
            }
        }
        return false;
    }

    private static boolean comparePdfArrays(PdfArray array1, PdfArray array2, Set<PdfObject> visitedObjects) {
        if (array1.size() != array2.size()) {
            return false;
        }
        for (int i = 0; i < array1.size(); ++i) {
            if (DocumentRevisionsValidator.comparePdfObjects(array1.get(i), array2.get(i), visitedObjects)) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfDictionaries(PdfDictionary dictionary1, PdfDictionary dictionary2, Set<PdfObject> visitedObjects) {
        Set entrySet1 = dictionary1.entrySet();
        Set entrySet2 = dictionary2.entrySet();
        if (entrySet1.size() != entrySet2.size()) {
            return false;
        }
        for (Map.Entry entry1 : entrySet1) {
            if (entrySet2.stream().anyMatch(entry2 -> ((PdfName)entry2.getKey()).equals(entry1.getKey()) && DocumentRevisionsValidator.comparePdfObjects((PdfObject)entry2.getValue(), (PdfObject)entry1.getValue(), visitedObjects))) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePdfStreams(PdfStream stream1, PdfStream stream2, Set<PdfObject> visitedObjects) {
        return Arrays.equals(stream1.getBytes(), stream2.getBytes()) && DocumentRevisionsValidator.comparePdfDictionaries((PdfDictionary)stream1, (PdfDictionary)stream2, visitedObjects);
    }

    private static boolean isSameReference(PdfIndirectReference indirectReference1, PdfIndirectReference indirectReference2) {
        if (indirectReference1 == indirectReference2) {
            return true;
        }
        if (indirectReference1 == null || indirectReference2 == null) {
            return false;
        }
        return indirectReference1.getObjNumber() == indirectReference2.getObjNumber() && indirectReference1.getGenNumber() == indirectReference2.getGenNumber();
    }

    private static boolean isMaxGenerationObject(PdfIndirectReference indirectReference) {
        return indirectReference.getObjNumber() == 0 && indirectReference.getGenNumber() == 65535;
    }

    private static PdfIndirectReference getIndirectReferenceOrNull(Supplier<PdfIndirectReference> referenceGetter) {
        try {
            return referenceGetter.get();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class ReferencesPair {
        private final PdfIndirectReference currentReference;
        private final PdfIndirectReference previousReference;

        ReferencesPair(PdfIndirectReference currentReference, PdfIndirectReference previousReference) {
            this.currentReference = currentReference;
            this.previousReference = previousReference;
        }

        public PdfIndirectReference getCurrentReference() {
            return this.currentReference;
        }

        public PdfIndirectReference getPreviousReference() {
            return this.previousReference;
        }
    }
}

