/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.cmp.IPKIFailureInfo;
import com.itextpdf.commons.bouncycastle.tsp.AbstractTSPException;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampRequest;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampRequestGenerator;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampResponse;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampToken;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampTokenInfo;
import com.itextpdf.commons.utils.Base64;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.ITSAInfoBouncyCastle;
import com.itextpdf.signatures.SignUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSAClientBouncyCastle
implements ITSAClient {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    public static final int DEFAULTTOKENSIZE = 10240;
    private static final Logger LOGGER = LoggerFactory.getLogger(TSAClientBouncyCastle.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected ITSAInfoBouncyCastle tsaInfo;
    protected int tokenSizeEstimate = 10240;
    protected String digestAlgorithm = "SHA-256";
    private String tsaReqPolicy;
    private int customTokenSizeEstimate = -1;

    public TSAClientBouncyCastle(String url) {
        this(url, null, null);
    }

    public TSAClientBouncyCastle(String url, String username, String password) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.customTokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setTSAInfo(ITSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.customTokenSizeEstimate == -1 ? this.tokenSizeEstimate : this.customTokenSizeEstimate;
    }

    public String getTSAReqPolicy() {
        return this.tsaReqPolicy;
    }

    public void setTSAReqPolicy(String tsaReqPolicy) {
        this.tsaReqPolicy = tsaReqPolicy;
    }

    @Override
    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return SignUtils.getMessageDigest(this.digestAlgorithm);
    }

    @Override
    public byte[] getTimeStampToken(byte[] imprint) throws IOException, AbstractTSPException {
        int value;
        byte[] respBytes = null;
        ITimeStampRequestGenerator tsqGenerator = BOUNCY_CASTLE_FACTORY.createTimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        if (this.tsaReqPolicy != null && this.tsaReqPolicy.length() > 0) {
            tsqGenerator.setReqPolicy(this.tsaReqPolicy);
        }
        BigInteger nonce = BigInteger.valueOf(SystemUtil.getTimeBasedSeed());
        ITimeStampRequest request = tsqGenerator.generate(BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(DigestAlgorithms.getAllowedDigest(this.digestAlgorithm)), imprint, nonce);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        ITimeStampResponse response = BOUNCY_CASTLE_FACTORY.createTimeStampResponse(respBytes);
        response.validate(request);
        IPKIFailureInfo failure = response.getFailInfo();
        int n = value = failure.isNull() ? 0 : failure.intValue();
        if (value != 0) {
            throw new PdfException("Invalid TSA {0} response code {1}.").setMessageParams(new Object[]{this.tsaURL, value + ": " + response.getStatusString()});
        }
        ITimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new PdfException("TSA {0} failed to return time stamp token: {1}.").setMessageParams(new Object[]{this.tsaURL, response.getStatusString()});
        }
        ITimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        SignUtils.TsaResponse response = SignUtils.getTsaResponseForUserRequest(this.tsaURL, requestBytes, this.tsaUsername, this.tsaPassword);
        InputStream inp = response.tsaResponseStream;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        if (response.encoding != null && response.encoding.toLowerCase().equals("base64".toLowerCase())) {
            respBytes = Base64.decode((String)new String(respBytes, "US-ASCII"));
        }
        return respBytes;
    }
}

