/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.cms;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IBasicOCSPResponse;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.cms.AlgorithmIdentifier;
import com.itextpdf.signatures.cms.EncapsulatedContentInfo;
import com.itextpdf.signatures.cms.SignerInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class CMSContainer {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    final Collection<IASN1Sequence> otherRevocationInfo = new ArrayList<IASN1Sequence>();
    private final Collection<CRL> crls = new ArrayList<CRL>();
    private final Collection<IBasicOCSPResponse> ocsps = new ArrayList<IBasicOCSPResponse>();
    private EncapsulatedContentInfo encapContentInfo = new EncapsulatedContentInfo();
    private Collection<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private SignerInfo signerInfo = new SignerInfo();

    public CMSContainer() {
    }

    public CMSContainer(byte[] encodedCMSdata) throws IOException, CertificateException, CRLException {
        try (IASN1InputStream is = BC_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(encodedCMSdata));){
            IASN1Set signerInfosS;
            IASN1Sequence contentInfo = BC_FACTORY.createASN1Sequence((IASN1Encodable)is.readObject());
            IASN1Sequence signedData = BC_FACTORY.createASN1Sequence((IASN1Encodable)BC_FACTORY.createASN1TaggedObject(contentInfo.getObjectAt(1)).getObject());
            IASN1Set digestAlgorithms = BC_FACTORY.createASN1Set(signedData.getObjectAt(1));
            if (digestAlgorithms.size() > 1) {
                throw new PdfException("Only one signer per CMS container is allowed");
            }
            IASN1Sequence lencapContentInfo = BC_FACTORY.createASN1Sequence(signedData.getObjectAt(2));
            this.encapContentInfo = new EncapsulatedContentInfo(lencapContentInfo);
            this.processCertificates(signedData);
            int next = 4;
            IASN1TaggedObject taggedObj = BC_FACTORY.createASN1TaggedObject(signedData.getObjectAt(next));
            if (taggedObj != null) {
                ++next;
                CertificateUtil.retrieveRevocationInfoFromSignedData(taggedObj, this.crls, this.ocsps, this.otherRevocationInfo);
            }
            if ((signerInfosS = BC_FACTORY.createASN1Set(signedData.getObjectAt(next))).size() != 1) {
                throw new PdfException("Only one signer per CMS container is allowed");
            }
            this.signerInfo = new SignerInfo(signerInfosS.getObjectAt(0), this.certificates);
        }
        catch (NullPointerException npe) {
            throw new PdfException("Provided data is not a CMS container", (Throwable)npe);
        }
    }

    public void setSignerInfo(SignerInfo signerInfo) {
        this.signerInfo = signerInfo;
    }

    public SignerInfo getSignerInfo() {
        return this.signerInfo;
    }

    public long getSizeEstimation() throws CertificateEncodingException, IOException, CRLException {
        byte[] result = this.serialize(true);
        return result.length;
    }

    public int getCmsVersion() {
        return 1;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        if (this.signerInfo == null) {
            return null;
        }
        return this.signerInfo.getDigestAlgorithm();
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public void setEncapContentInfo(EncapsulatedContentInfo encapContentInfo) {
        this.encapContentInfo = encapContentInfo;
    }

    public void addCertificate(X509Certificate cert) {
        this.certificates.add(cert);
    }

    public void addCertificates(X509Certificate[] certs) {
        this.certificates = Arrays.asList(certs);
    }

    public Collection<X509Certificate> getCertificates() {
        return Collections.unmodifiableCollection(this.certificates);
    }

    public Collection<CRL> getCrls() {
        return Collections.unmodifiableCollection(this.crls);
    }

    public void addCrl(CRL crl) {
        this.crls.add(crl);
    }

    public Collection<IBasicOCSPResponse> getOcsps() {
        return Collections.unmodifiableCollection(this.ocsps);
    }

    public void addOcsp(IBasicOCSPResponse ocspResponse) {
        this.ocsps.add(ocspResponse);
    }

    public void setSerializedSignedAttributes(byte[] signedAttributesData) {
        this.signerInfo.setSerializedSignedAttributes(signedAttributesData);
    }

    public byte[] getSerializedSignedAttributes() throws IOException {
        if (this.signerInfo == null) {
            throw new IllegalStateException("Signer info is not yet initialized");
        }
        return this.signerInfo.serializeSignedAttributes();
    }

    public byte[] serialize() throws CertificateEncodingException, IOException, CRLException {
        return this.serialize(false);
    }

    private byte[] serialize(boolean forEstimation) throws CertificateEncodingException, IOException, CRLException {
        IASN1EncodableVector contentInfoV = BC_FACTORY.createASN1EncodableVector();
        contentInfoV.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.7.2"));
        IASN1EncodableVector singedDataV = BC_FACTORY.createASN1EncodableVector();
        singedDataV.add((IASN1Primitive)BC_FACTORY.createASN1Integer(this.getCmsVersion()));
        IASN1EncodableVector digestAlgorithmsV = BC_FACTORY.createASN1EncodableVector();
        digestAlgorithmsV.add((IASN1Primitive)this.getDigestAlgorithm().getAsASN1Sequence());
        singedDataV.add((IASN1Primitive)BC_FACTORY.createDERSet(digestAlgorithmsV));
        IASN1EncodableVector encapContentInfoV = BC_FACTORY.createASN1EncodableVector();
        encapContentInfoV.add((IASN1Primitive)BC_FACTORY.createASN1ObjectIdentifier(this.encapContentInfo.getContentType()));
        if (this.encapContentInfo.getContent() != null) {
            encapContentInfoV.add((IASN1Primitive)this.encapContentInfo.getContent());
        }
        singedDataV.add((IASN1Primitive)BC_FACTORY.createDERSequence(encapContentInfoV));
        IASN1EncodableVector certificateSetV = BC_FACTORY.createASN1EncodableVector();
        for (X509Certificate cert : this.certificates) {
            certificateSetV.add(BC_FACTORY.createASN1Primitive(cert.getEncoded()));
        }
        singedDataV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(false, 0, (IASN1Primitive)BC_FACTORY.createDERSet(certificateSetV)));
        IDERSet revInfoChoices = CertificateUtil.createRevocationInfoChoices(this.crls, this.ocsps, this.otherRevocationInfo);
        if (revInfoChoices != null) {
            singedDataV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(false, 1, (IASN1Primitive)revInfoChoices));
        }
        IASN1EncodableVector signerInfosV = BC_FACTORY.createASN1EncodableVector();
        signerInfosV.add((IASN1Primitive)this.signerInfo.getAsDerSequence(forEstimation));
        singedDataV.add((IASN1Primitive)BC_FACTORY.createDERSet(signerInfosV));
        contentInfoV.add((IASN1Primitive)BC_FACTORY.createDERTaggedObject(0, (IASN1Primitive)BC_FACTORY.createDERSequence(singedDataV)));
        return BC_FACTORY.createDERSequence(contentInfoV).getEncoded();
    }

    private void processCertificates(IASN1Sequence signedData) throws CertificateException, IOException {
        IASN1TaggedObject taggedCertificatesSet = BC_FACTORY.createASN1TaggedObject(signedData.getObjectAt(3));
        if (taggedCertificatesSet == null) {
            throw new PdfException("The certificate set must at least contains the signer certificate");
        }
        IASN1Set certificatesSet = BC_FACTORY.createASN1Set(taggedCertificatesSet, false);
        if (certificatesSet.isNull() || certificatesSet.size() == 0) {
            throw new PdfException("The certificate set must at least contains the signer certificate");
        }
        for (IASN1Encodable certObj : certificatesSet.toArray()) {
            try (ByteArrayInputStream cis = new ByteArrayInputStream(certObj.toASN1Primitive().getEncoded(BC_FACTORY.createASN1Encoding().getDer()));){
                this.certificates.add((X509Certificate)CertificateUtil.generateCertificate(cis));
            }
        }
    }
}

