/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.CrlClientOnline;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.validation.v1.CRLValidator;
import com.itextpdf.signatures.validation.v1.OCSPValidator;
import com.itextpdf.signatures.validation.v1.SafeCalling;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.ValidationCrlClient;
import com.itextpdf.signatures.validation.v1.ValidationOcspClient;
import com.itextpdf.signatures.validation.v1.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.TimeBasedContext;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.report.CertificateReportItem;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RevocationDataValidator {
    static final String REVOCATION_DATA_CHECK = "Revocation data check.";
    static final String NO_REVOCATION_DATA = "Certificate revocation status cannot be checked: no revocation data available or the status cannot be determined.";
    static final String SELF_SIGNED_CERTIFICATE = "Certificate is self-signed. Revocation data check will be skipped.";
    static final String TRUSTED_OCSP_RESPONDER = "Authorized OCSP Responder certificate has id-pkix-ocsp-nocheck extension so it is trusted by the definition and no revocation checking is performed.";
    static final String VALIDITY_ASSURED = "Certificate is trusted due to validity assured - short term extension.";
    static final String CANNOT_PARSE_OCSP = "OCSP response from \"{0}\" OCSP response cannot be parsed.";
    static final String CANNOT_PARSE_CRL = "CRL response from \"{0}\" CRL response cannot be parsed.";
    static final String ISSUER_RETRIEVAL_FAILED = "Retrieval of the certificate issuer failed.";
    static final String OCSP_CLIENT_FAILURE = "Unexpected exception occurred in OCSP client \"{0}\".";
    static final String CRL_CLIENT_FAILURE = "Unexpected exception occurred in CRL client \"{0}\".";
    static final String OCSP_VALIDATOR_FAILURE = "Unexpected exception occurred in OCSP validator.";
    static final String CRL_VALIDATOR_FAILURE = "Unexpected exception occurred in CRL validator.";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final List<IOcspClient> ocspClients = new ArrayList<IOcspClient>();
    private final List<ICrlClient> crlClients = new ArrayList<ICrlClient>();
    private final SignatureValidationProperties properties;
    private final IssuingCertificateRetriever certificateRetriever;
    private final OCSPValidator ocspValidator;
    private final CRLValidator crlValidator;

    protected RevocationDataValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.ocspValidator = builder.getOCSPValidator();
        this.crlValidator = builder.getCRLValidator();
        this.crlClients.addAll(this.properties.getCrlClients());
        this.ocspClients.addAll(this.properties.getOcspClients());
    }

    public RevocationDataValidator addCrlClient(ICrlClient crlClient) {
        this.crlClients.add(crlClient);
        return this;
    }

    public RevocationDataValidator addOcspClient(IOcspClient ocspClient) {
        this.ocspClients.add(ocspClient);
        return this;
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, Date validationDate) {
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.REVOCATION_DATA_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, SELF_SIGNED_CERTIFICATE, ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (CertificateUtil.getExtensionValueByOid(certificate, "0.4.0.194121.2.1") != null) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, VALIDITY_ASSURED, ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (CertificateSource.OCSP_ISSUER == localContext.getCertificateSource() && CertificateUtil.getExtensionValueByOid(certificate, BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspNoCheck().getId()) != null) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, TRUSTED_OCSP_RESPONDER, ReportItem.ReportItemStatus.INFO));
            return;
        }
        List<OcspResponseValidationInfo> ocspResponses = this.retrieveAllOCSPResponses(report, localContext, certificate);
        ocspResponses = ocspResponses.stream().sorted((o1, o2) -> o2.singleResp.getThisUpdate().compareTo(o1.singleResp.getThisUpdate())).collect(Collectors.toList());
        List<CrlValidationInfo> crlResponses = this.retrieveAllCRLResponses(report, localContext, certificate);
        ValidationReport revDataValidationReport = new ValidationReport();
        this.validateRevocationData(revDataValidationReport, localContext, certificate, validationDate, ocspResponses, crlResponses);
        if (ValidationReport.ValidationResult.INDETERMINATE == revDataValidationReport.getValidationResult()) {
            ArrayList<CrlValidationInfo> onlineCrlResponses = new ArrayList<CrlValidationInfo>();
            ArrayList<OcspResponseValidationInfo> onlineOcspResponses = new ArrayList<OcspResponseValidationInfo>();
            this.tryToFetchRevInfoOnline(report, context, certificate, onlineCrlResponses, onlineOcspResponses);
            if (!onlineCrlResponses.isEmpty() || !onlineOcspResponses.isEmpty()) {
                for (ReportItem reportItem : revDataValidationReport.getLogs()) {
                    if (NO_REVOCATION_DATA.equals(reportItem.getMessage())) continue;
                    report.addReportItem(reportItem);
                }
                this.validateRevocationData(report, localContext, certificate, validationDate, onlineOcspResponses, onlineCrlResponses);
                return;
            }
        }
        report.merge(revDataValidationReport);
    }

    private static void fillOcspResponses(List<OcspResponseValidationInfo> ocspResponses, IBasicOCSPResp basicOCSPResp, Date generationDate, TimeBasedContext timeBasedContext) {
        if (basicOCSPResp != null) {
            ISingleResp[] singleResponses;
            for (ISingleResp singleResponse : singleResponses = basicOCSPResp.getResponses()) {
                ocspResponses.add(new OcspResponseValidationInfo(singleResponse, basicOCSPResp, generationDate, timeBasedContext));
            }
        }
    }

    private static List<CrlValidationInfo> retrieveAllCRLResponsesUsingClient(ValidationReport report, X509Certificate certificate, ICrlClient crlClient) {
        ArrayList<CrlValidationInfo> crlResponses = new ArrayList<CrlValidationInfo>();
        if (crlClient instanceof ValidationCrlClient) {
            ValidationCrlClient validationCrlClient = (ValidationCrlClient)crlClient;
            crlResponses.addAll(validationCrlClient.getCrls().values());
        } else {
            Collection crlBytesCollection = SafeCalling.onExceptionLog(() -> crlClient.getEncoded(certificate, null), Collections.emptyList(), report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)CRL_CLIENT_FAILURE, (Object[])new Object[]{crlClient}), (Exception)e, ReportItem.ReportItemStatus.INFO));
            for (byte[] crlBytes : crlBytesCollection) {
                SafeCalling.onExceptionLog(() -> crlResponses.add(new CrlValidationInfo((X509CRL)CertificateUtil.parseCrlFromBytes(crlBytes), DateTimeUtil.getCurrentTimeDate(), TimeBasedContext.PRESENT)), report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)CANNOT_PARSE_CRL, (Object[])new Object[]{crlClient}), (Exception)e, ReportItem.ReportItemStatus.INFO));
            }
        }
        return crlResponses;
    }

    private void validateRevocationData(ValidationReport report, ValidationContext context, X509Certificate certificate, Date validationDate, List<OcspResponseValidationInfo> ocspResponses, List<CrlValidationInfo> crlResponses) {
        int i = 0;
        int j = 0;
        while (i < ocspResponses.size() || j < crlResponses.size()) {
            Object validationInfo;
            ValidationReport revDataValidationReport = new ValidationReport();
            if (i < ocspResponses.size() && (j >= crlResponses.size() || ocspResponses.get((int)i).singleResp.getThisUpdate().after(crlResponses.get((int)j).crl.getThisUpdate()))) {
                validationInfo = ocspResponses.get(i);
                SafeCalling.onRuntimeExceptionLog(() -> this.lambda$validateRevocationData$5(revDataValidationReport, context, (OcspResponseValidationInfo)validationInfo, certificate, validationDate), report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, OCSP_VALIDATOR_FAILURE, (Exception)e, ReportItem.ReportItemStatus.INFO));
                ++i;
            } else {
                validationInfo = crlResponses.get(j);
                SafeCalling.onRuntimeExceptionLog(() -> this.lambda$validateRevocationData$7(revDataValidationReport, context, (CrlValidationInfo)validationInfo, certificate, validationDate), report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, CRL_VALIDATOR_FAILURE, (Exception)e, ReportItem.ReportItemStatus.INFO));
                ++j;
            }
            if (ValidationReport.ValidationResult.INDETERMINATE == revDataValidationReport.getValidationResult()) {
                for (ReportItem reportItem : revDataValidationReport.getLogs()) {
                    if ("OCSP: Serial numbers don't match.".equals(reportItem.getMessage()) || "The CRL issuer does not share the root of the inspected certificate.".equals(reportItem.getMessage())) continue;
                    report.addReportItem(reportItem.setStatus(ReportItem.ReportItemStatus.INFO));
                }
                continue;
            }
            report.merge(revDataValidationReport);
            return;
        }
        report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, NO_REVOCATION_DATA, ReportItem.ReportItemStatus.INDETERMINATE));
    }

    private List<OcspResponseValidationInfo> retrieveAllOCSPResponses(ValidationReport report, ValidationContext context, X509Certificate certificate) {
        X509Certificate issuerCert;
        ArrayList<OcspResponseValidationInfo> ocspResponses = new ArrayList<OcspResponseValidationInfo>();
        try {
            issuerCert = (X509Certificate)this.certificateRetriever.retrieveIssuerCertificate(certificate);
        }
        catch (RuntimeException e2) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, ISSUER_RETRIEVAL_FAILED, e2, ReportItem.ReportItemStatus.INDETERMINATE));
            return ocspResponses;
        }
        for (IOcspClient ocspClient : this.ocspClients) {
            if (ocspClient instanceof ValidationOcspClient) {
                ValidationOcspClient validationOcspClient = (ValidationOcspClient)ocspClient;
                for (Map.Entry<IBasicOCSPResp, OcspResponseValidationInfo> response : validationOcspClient.getResponses().entrySet()) {
                    RevocationDataValidator.fillOcspResponses(ocspResponses, response.getKey(), response.getValue().trustedGenerationDate, response.getValue().timeBasedContext);
                }
                continue;
            }
            byte[] basicOcspRespBytes = null;
            basicOcspRespBytes = SafeCalling.onRuntimeExceptionLog(() -> ocspClient.getEncoded(certificate, issuerCert, null), null, report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)OCSP_CLIENT_FAILURE, (Object[])new Object[]{ocspClient}), (Exception)e, ReportItem.ReportItemStatus.INFO));
            if (basicOcspRespBytes == null) continue;
            try {
                IBasicOCSPResp basicOCSPResp = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(BOUNCY_CASTLE_FACTORY.createASN1Primitive(basicOcspRespBytes)));
                RevocationDataValidator.fillOcspResponses(ocspResponses, basicOCSPResp, DateTimeUtil.getCurrentTimeDate(), TimeBasedContext.PRESENT);
            }
            catch (IOException | RuntimeException e3) {
                report.addReportItem(new ReportItem(REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)CANNOT_PARSE_OCSP, (Object[])new Object[]{ocspClient}), e3, ReportItem.ReportItemStatus.INFO));
            }
        }
        SignatureValidationProperties.OnlineFetching onlineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.OCSP_VALIDATOR));
        if (SignatureValidationProperties.OnlineFetching.ALWAYS_FETCH == onlineFetching) {
            SafeCalling.onRuntimeExceptionLog(() -> {
                IBasicOCSPResp basicOCSPResp = new OcspClientBouncyCastle().getBasicOCSPResp(certificate, issuerCert, null);
                RevocationDataValidator.fillOcspResponses(ocspResponses, basicOCSPResp, DateTimeUtil.getCurrentTimeDate(), TimeBasedContext.PRESENT);
            }, report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)OCSP_CLIENT_FAILURE, (Object[])new Object[]{"OcspClientBouncyCastle"}), (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        }
        return ocspResponses;
    }

    private List<CrlValidationInfo> retrieveAllCRLResponses(ValidationReport report, ValidationContext context, X509Certificate certificate) {
        ArrayList<CrlValidationInfo> crlResponses = new ArrayList<CrlValidationInfo>();
        for (ICrlClient crlClient : this.crlClients) {
            crlResponses.addAll(RevocationDataValidator.retrieveAllCRLResponsesUsingClient(report, certificate, crlClient));
        }
        SignatureValidationProperties.OnlineFetching onlineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.CRL_VALIDATOR));
        if (SignatureValidationProperties.OnlineFetching.ALWAYS_FETCH == onlineFetching) {
            crlResponses.addAll(RevocationDataValidator.retrieveAllCRLResponsesUsingClient(report, certificate, new CrlClientOnline()));
        }
        return crlResponses.stream().sorted((o1, o2) -> o2.crl.getThisUpdate().compareTo(o1.crl.getThisUpdate())).collect(Collectors.toList());
    }

    private void tryToFetchRevInfoOnline(ValidationReport report, ValidationContext context, X509Certificate certificate, List<CrlValidationInfo> onlineCrlResponses, List<OcspResponseValidationInfo> onlineOcspResponses) {
        SignatureValidationProperties.OnlineFetching ocspOnlineFetching;
        SignatureValidationProperties.OnlineFetching crlOnlineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.CRL_VALIDATOR));
        if (SignatureValidationProperties.OnlineFetching.FETCH_IF_NO_OTHER_DATA_AVAILABLE == crlOnlineFetching) {
            onlineCrlResponses.addAll(RevocationDataValidator.retrieveAllCRLResponsesUsingClient(report, certificate, new CrlClientOnline()).stream().sorted((o1, o2) -> o2.crl.getThisUpdate().compareTo(o1.crl.getThisUpdate())).collect(Collectors.toList()));
        }
        if (SignatureValidationProperties.OnlineFetching.FETCH_IF_NO_OTHER_DATA_AVAILABLE == (ocspOnlineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.OCSP_VALIDATOR)))) {
            SafeCalling.onRuntimeExceptionLog(() -> {
                IBasicOCSPResp basicOCSPResp = new OcspClientBouncyCastle().getBasicOCSPResp(certificate, (X509Certificate)this.certificateRetriever.retrieveIssuerCertificate(certificate), null);
                ArrayList<OcspResponseValidationInfo> ocspResponses = new ArrayList<OcspResponseValidationInfo>();
                RevocationDataValidator.fillOcspResponses(ocspResponses, basicOCSPResp, DateTimeUtil.getCurrentTimeDate(), TimeBasedContext.PRESENT);
                onlineOcspResponses.addAll(ocspResponses.stream().sorted((o1, o2) -> o2.singleResp.getThisUpdate().compareTo(o1.singleResp.getThisUpdate())).collect(Collectors.toList()));
            }, report, e -> new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, MessageFormatUtil.format((String)OCSP_CLIENT_FAILURE, (Object[])new Object[]{"OcspClientBouncyCastle"}), (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
        }
    }

    private /* synthetic */ void lambda$validateRevocationData$7(ValidationReport revDataValidationReport, ValidationContext context, CrlValidationInfo validationInfo, X509Certificate certificate, Date validationDate) {
        this.crlValidator.validate(revDataValidationReport, context.setTimeBasedContext(validationInfo.timeBasedContext), certificate, validationInfo.crl, validationDate, validationInfo.trustedGenerationDate);
    }

    private /* synthetic */ void lambda$validateRevocationData$5(ValidationReport revDataValidationReport, ValidationContext context, OcspResponseValidationInfo validationInfo, X509Certificate certificate, Date validationDate) {
        this.ocspValidator.validate(revDataValidationReport, context.setTimeBasedContext(validationInfo.timeBasedContext), certificate, validationInfo.singleResp, validationInfo.basicOCSPResp, validationDate, validationInfo.trustedGenerationDate);
    }

    public static class CrlValidationInfo {
        final X509CRL crl;
        final Date trustedGenerationDate;
        final TimeBasedContext timeBasedContext;

        public CrlValidationInfo(X509CRL crl, Date trustedGenerationDate, TimeBasedContext timeBasedContext) {
            this.crl = crl;
            this.trustedGenerationDate = trustedGenerationDate;
            this.timeBasedContext = timeBasedContext;
        }
    }

    public static class OcspResponseValidationInfo {
        final ISingleResp singleResp;
        final IBasicOCSPResp basicOCSPResp;
        final Date trustedGenerationDate;
        final TimeBasedContext timeBasedContext;

        public OcspResponseValidationInfo(ISingleResp singleResp, IBasicOCSPResp basicOCSPResp, Date trustedGenerationDate, TimeBasedContext timeBasedContext) {
            this.singleResp = singleResp;
            this.basicOCSPResp = basicOCSPResp;
            this.trustedGenerationDate = trustedGenerationDate;
            this.timeBasedContext = timeBasedContext;
        }
    }
}

