/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.converter;

import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.JsoupXmlParser;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.DefaultSvgProcessor;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SvgConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgConverter.class);

    private SvgConverter() {
    }

    private static void checkNull(Object o) {
        if (o == null) {
            throw new SvgProcessingException("Parameters for this method cannot be null.");
        }
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo) {
        SvgConverter.drawOnDocument(content, document, pageNo, 0.0f, 0.0f);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, float x, float y) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo), x, y);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, ISvgConverterProperties props) {
        SvgConverter.drawOnDocument(content, document, pageNo, 0.0f, 0.0f, props);
    }

    public static void drawOnDocument(String content, PdfDocument document, int pageNo, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(content, document.getPage(pageNo), x, y, props);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo) throws IOException {
        SvgConverter.drawOnDocument(stream, document, pageNo, 0.0f, 0.0f);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, float x, float y) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo), x, y);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnDocument(stream, document, pageNo, 0.0f, 0.0f, props);
    }

    public static void drawOnDocument(InputStream stream, PdfDocument document, int pageNo, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(document);
        SvgConverter.drawOnPage(stream, document.getPage(pageNo), x, y, props);
    }

    public static void drawOnPage(String content, PdfPage page) {
        SvgConverter.drawOnPage(content, page, 0.0f, 0.0f);
    }

    public static void drawOnPage(String content, PdfPage page, float x, float y) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page), x, y);
    }

    public static void drawOnPage(String content, PdfPage page, ISvgConverterProperties props) {
        SvgConverter.drawOnPage(content, page, 0.0f, 0.0f, props);
    }

    public static void drawOnPage(String content, PdfPage page, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(content, new PdfCanvas(page), x, y, props);
    }

    public static void drawOnPage(InputStream stream, PdfPage page) throws IOException {
        SvgConverter.drawOnPage(stream, page, 0.0f, 0.0f);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, float x, float y) throws IOException {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page), x, y);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnPage(stream, page, 0.0f, 0.0f, props);
    }

    public static void drawOnPage(InputStream stream, PdfPage page, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(page);
        SvgConverter.drawOnCanvas(stream, new PdfCanvas(page), x, y, props);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas) {
        SvgConverter.drawOnCanvas(content, canvas, 0.0f, 0.0f);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, float x, float y) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument()), canvas, x, y);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, ISvgConverterProperties props) {
        SvgConverter.drawOnCanvas(content, canvas, 0.0f, 0.0f, props);
    }

    public static void drawOnCanvas(String content, PdfCanvas canvas, float x, float y, ISvgConverterProperties props) {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(content, canvas.getDocument(), props), canvas, x, y);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas) throws IOException {
        SvgConverter.drawOnCanvas(stream, canvas, 0.0f, 0.0f);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, float x, float y) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument()), canvas, x, y);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, ISvgConverterProperties props) throws IOException {
        SvgConverter.drawOnCanvas(stream, canvas, 0.0f, 0.0f, props);
    }

    public static void drawOnCanvas(InputStream stream, PdfCanvas canvas, float x, float y, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(canvas);
        SvgConverter.draw(SvgConverter.convertToXObject(stream, canvas.getDocument(), props), canvas, x, y);
    }

    public static void createPdf(File svgFile, File pdfFile) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, null, null);
    }

    public static void createPdf(File svgFile, File pdfFile, ISvgConverterProperties props) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, props, null);
    }

    public static void createPdf(File svgFile, File pdfFile, WriterProperties writerProps) throws IOException {
        SvgConverter.createPdf(svgFile, pdfFile, null, writerProps);
    }

    public static void createPdf(File svgFile, File pdfFile, ISvgConverterProperties props, WriterProperties writerProps) throws IOException {
        if (props == null) {
            props = new SvgConverterProperties().setBaseUri(FileUtil.getParentDirectory((File)svgFile));
        } else if (props.getBaseUri() == null || props.getBaseUri().isEmpty()) {
            String baseUri = FileUtil.getParentDirectory((File)svgFile);
            props = SvgConverter.convertToSvgConverterProps(props, baseUri);
        }
        try (FileInputStream fileInputStream = new FileInputStream(svgFile.getAbsolutePath());
             FileOutputStream fileOutputStream = new FileOutputStream(pdfFile.getAbsolutePath());){
            SvgConverter.createPdf(fileInputStream, fileOutputStream, props, writerProps);
        }
    }

    private static SvgConverterProperties convertToSvgConverterProps(ISvgConverterProperties props, String baseUri) {
        return new SvgConverterProperties().setBaseUri(baseUri).setMediaDeviceDescription(props.getMediaDeviceDescription()).setFontProvider(props.getFontProvider()).setCharset(props.getCharset()).setRendererFactory(props.getRendererFactory());
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, null, null);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, WriterProperties writerprops) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, null, writerprops);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, ISvgConverterProperties props) throws IOException {
        SvgConverter.createPdf(svgStream, pdfDest, props, null);
    }

    public static void createPdf(InputStream svgStream, OutputStream pdfDest, ISvgConverterProperties props, WriterProperties writerProps) throws IOException {
        if (writerProps == null) {
            writerProps = new WriterProperties();
        }
        PdfDocument pdfDocument = new PdfDocument(new PdfWriter(pdfDest, writerProps));
        ISvgProcessorResult processorResult = SvgConverter.process(SvgConverter.parse(svgStream, props), props);
        ISvgNodeRenderer topSvgRenderer = processorResult.getRootRenderer();
        String baseUri = SvgConverter.tryToExtractBaseUri(props);
        SvgDrawContext drawContext = new SvgDrawContext(new ResourceResolver(baseUri), processorResult.getFontProvider());
        drawContext.addNamedObjects(processorResult.getNamedObjects());
        drawContext.setTempFonts(processorResult.getTempFonts());
        SvgConverter.checkNull(topSvgRenderer);
        SvgConverter.checkNull(pdfDocument);
        float[] wh = SvgConverter.extractWidthAndHeight(topSvgRenderer);
        float width = wh[0];
        float height = wh[1];
        pdfDocument.setDefaultPageSize(new PageSize(width, height));
        PdfPage page = pdfDocument.addNewPage();
        PdfCanvas pageCanvas = new PdfCanvas(page);
        PdfFormXObject xObject = SvgConverter.convertToXObject(topSvgRenderer, pdfDocument, drawContext);
        SvgConverter.draw(xObject, pageCanvas);
        pdfDocument.close();
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document) {
        return SvgConverter.convertToXObject(content, document, null);
    }

    public static PdfFormXObject convertToXObject(String content, PdfDocument document, ISvgConverterProperties props) {
        SvgConverter.checkNull(content);
        SvgConverter.checkNull(document);
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(content), props), document, props);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(stream);
        SvgConverter.checkNull(document);
        return SvgConverter.convertToXObject(SvgConverter.process(SvgConverter.parse(stream, props), props), document, props);
    }

    private static PdfFormXObject convertToXObject(ISvgProcessorResult processorResult, PdfDocument document, ISvgConverterProperties props) {
        String baseUri = "";
        if (props != null) {
            baseUri = props.getBaseUri();
        }
        SvgDrawContext drawContext = new SvgDrawContext(new ResourceResolver(baseUri), processorResult.getFontProvider());
        drawContext.setTempFonts(processorResult.getTempFonts());
        drawContext.addNamedObjects(processorResult.getNamedObjects());
        return SvgConverter.convertToXObject(processorResult.getRootRenderer(), document, drawContext);
    }

    public static PdfFormXObject convertToXObject(InputStream stream, PdfDocument document) throws IOException {
        return SvgConverter.convertToXObject(stream, document, null);
    }

    public static Image convertToImage(InputStream stream, PdfDocument document) throws IOException {
        return new Image(SvgConverter.convertToXObject(stream, document));
    }

    public static Image convertToImage(InputStream stream, PdfDocument document, ISvgConverterProperties props) throws IOException {
        return new Image(SvgConverter.convertToXObject(stream, document, props));
    }

    private static void draw(PdfFormXObject pdfForm, PdfCanvas canvas) {
        canvas.addXObject((PdfXObject)pdfForm, 0.0f, 0.0f);
    }

    private static void draw(PdfFormXObject pdfForm, PdfCanvas canvas, float x, float y) {
        canvas.addXObject((PdfXObject)pdfForm, x, y);
    }

    public static PdfFormXObject convertToXObject(ISvgNodeRenderer topSvgRenderer, PdfDocument document) {
        return SvgConverter.convertToXObject(topSvgRenderer, document, new SvgDrawContext(null, null));
    }

    private static PdfFormXObject convertToXObject(ISvgNodeRenderer topSvgRenderer, PdfDocument document, SvgDrawContext context) {
        SvgConverter.checkNull(topSvgRenderer);
        SvgConverter.checkNull(document);
        SvgConverter.checkNull(context);
        float[] wh = SvgConverter.extractWidthAndHeight(topSvgRenderer);
        float width = wh[0];
        float height = wh[1];
        PdfFormXObject pdfForm = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        PdfCanvas canvas = new PdfCanvas(pdfForm, document);
        context.pushCanvas(canvas);
        PdfRootSvgNodeRenderer root = new PdfRootSvgNodeRenderer(topSvgRenderer);
        root.draw(context);
        return pdfForm;
    }

    public static ISvgProcessorResult parseAndProcess(InputStream svgStream) throws IOException {
        return SvgConverter.parseAndProcess(svgStream, null);
    }

    public static ISvgProcessorResult parseAndProcess(InputStream svgStream, ISvgConverterProperties props) throws IOException {
        JsoupXmlParser parser = new JsoupXmlParser();
        String charset = SvgConverter.tryToExtractCharset(props);
        IDocumentNode nodeTree = parser.parse(svgStream, charset);
        return new DefaultSvgProcessor().process((INode)nodeTree, props);
    }

    public static ISvgProcessorResult process(INode root) {
        SvgConverter.checkNull(root);
        return new DefaultSvgProcessor().process(root);
    }

    public static ISvgProcessorResult process(INode root, ISvgConverterProperties props) {
        SvgConverter.checkNull(root);
        return new DefaultSvgProcessor().process(root, props);
    }

    public static INode parse(String content) {
        SvgConverter.checkNull(content);
        return new JsoupXmlParser().parse(content);
    }

    public static INode parse(InputStream stream) throws IOException {
        SvgConverter.checkNull(stream);
        return SvgConverter.parse(stream, null);
    }

    public static INode parse(InputStream stream, ISvgConverterProperties props) throws IOException {
        SvgConverter.checkNull(stream);
        JsoupXmlParser xmlParser = new JsoupXmlParser();
        return xmlParser.parse(stream, SvgConverter.tryToExtractCharset(props));
    }

    public static float[] extractWidthAndHeight(ISvgNodeRenderer topSvgRenderer) {
        float height;
        float width;
        String wString;
        float[] res = new float[2];
        boolean viewBoxPresent = false;
        String vbString = topSvgRenderer.getAttribute("viewbox");
        float[] values = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (vbString != null) {
            List<String> valueStrings = SvgCssUtils.splitValueList(vbString);
            values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssUtils.parseAbsoluteLength((String)valueStrings.get(i));
            }
            viewBoxPresent = true;
        }
        if ((wString = topSvgRenderer.getAttribute("width")) == null) {
            if (viewBoxPresent) {
                width = values[2];
            } else {
                LOGGER.warn("Top Svg tag has no defined width attribute and viewbox width is not present, so browser default of 300px is used");
                width = CssUtils.parseAbsoluteLength((String)"300px");
            }
        } else {
            width = CssUtils.parseAbsoluteLength((String)wString);
        }
        String hString = topSvgRenderer.getAttribute("height");
        if (hString == null) {
            if (viewBoxPresent) {
                height = values[3];
            } else {
                LOGGER.warn("Top Svg tag has no defined height attribute and viewbox height is not present, so browser default of 150px is used");
                height = CssUtils.parseAbsoluteLength((String)"150px");
            }
        } else {
            height = CssUtils.parseAbsoluteLength((String)hString);
        }
        res[0] = width;
        res[1] = height;
        return res;
    }

    private static String tryToExtractCharset(ISvgConverterProperties props) {
        return props != null ? props.getCharset() : null;
    }

    private static String tryToExtractBaseUri(ISvgConverterProperties props) {
        if (props == null || props.getBaseUri() == null) {
            return null;
        }
        String baseUrl = props.getBaseUri().trim();
        return baseUrl.isEmpty() ? null : baseUrl;
    }
}

