/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.List;

public class PolylineSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    protected List<Point> points = new ArrayList<Point>();

    protected List<Point> getPoints() {
        return this.points;
    }

    protected void setPoints(String pointsAttribute) {
        if (pointsAttribute == null) {
            return;
        }
        List<String> points = SvgCssUtils.splitValueList(pointsAttribute);
        if (points.size() % 2 != 0) {
            throw new SvgProcessingException("Points attribute {0} on polyline tag does not contain a valid set of points").setMessageParams(new Object[]{pointsAttribute});
        }
        for (int i = 0; i < points.size(); i += 2) {
            float x = CssUtils.parseAbsoluteLength((String)points.get(i));
            float y = CssUtils.parseAbsoluteLength((String)points.get(i + 1));
            this.points.add(new Point((double)x, (double)y));
        }
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        String pointsAttribute = this.attributesAndStyles.containsKey("points") ? (String)this.attributesAndStyles.get("points") : null;
        this.setPoints(pointsAttribute);
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% polyline\n");
        if (this.points.size() > 1) {
            Point currentPoint = this.points.get(0);
            canvas.moveTo(currentPoint.getX(), currentPoint.getY());
            for (int x = 1; x < this.points.size(); ++x) {
                currentPoint = this.points.get(x);
                canvas.lineTo(currentPoint.getX(), currentPoint.getY());
            }
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PolylineSvgNodeRenderer copy = new PolylineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

