/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IBranchSvgNodeRenderer {
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, (PdfObject)PdfName.XObject);
            stream.put(PdfName.Subtype, (PdfObject)PdfName.Form);
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject((PdfStream)stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            stream.put(PdfName.BBox, (PdfObject)new PdfArray(context.getCurrentViewPort()));
            context.pushCanvas(newCanvas);
            this.applyViewportClip(context);
            this.applyViewportTranslationCorrection(context);
            for (ISvgNodeRenderer child : this.getChildren()) {
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            context.getCurrentCanvas().addXObject((PdfXObject)xObject, 0.0f, 0.0f);
        }
    }

    void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("viewbox")) {
            boolean forceUniformScaling;
            String viewBoxValues = (String)this.attributesAndStyles.get("viewbox");
            List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
            float[] values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssUtils.parseAbsoluteLength((String)valueStrings.get(i));
            }
            Rectangle currentViewPort = context.getCurrentViewPort();
            String[] alignAndMeet = this.retrieveAlignAndMeet();
            String align = alignAndMeet[0];
            String meetOrSlice = alignAndMeet[1];
            float scaleWidth = currentViewPort.getWidth() / values[2];
            float scaleHeight = currentViewPort.getHeight() / values[3];
            boolean bl = forceUniformScaling = !"none".equals(align);
            if (forceUniformScaling) {
                scaleWidth = "meet".equals(meetOrSlice) ? Math.min(scaleWidth, scaleHeight) : Math.max(scaleWidth, scaleHeight);
                scaleHeight = scaleWidth;
            }
            AffineTransform scale = AffineTransform.getScaleInstance((double)scaleWidth, (double)scaleHeight);
            float[] scaledViewBoxValues = AbstractBranchSvgNodeRenderer.scaleViewBoxValues(values, scaleWidth, scaleHeight);
            AffineTransform transform = this.processAspectRatioPosition(context, scaledViewBoxValues, align, scaleWidth, scaleHeight);
            if (!scale.isIdentity()) {
                context.getCurrentCanvas().concatMatrix(scale);
                context.getCurrentViewPort().setWidth(currentViewPort.getWidth() / scaleWidth).setX(currentViewPort.getX() / scaleWidth).setHeight(currentViewPort.getHeight() / scaleHeight).setY(currentViewPort.getY() / scaleHeight);
            }
            if (!transform.isIdentity()) {
                context.getCurrentCanvas().concatMatrix(transform);
                context.getCurrentViewPort().setX(currentViewPort.getX() + -1.0f * (float)transform.getTranslateX()).setY(currentViewPort.getY() + -1.0f * (float)transform.getTranslateY());
            }
        }
    }

    String[] retrieveAlignAndMeet() {
        String meetOrSlice = "meet";
        String align = "xmidymid";
        if (this.attributesAndStyles.containsKey("preserveaspectratio")) {
            String preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveaspectratio");
            List<String> aspectRatioValuesSplitValues = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            align = aspectRatioValuesSplitValues.get(0).toLowerCase();
            if (aspectRatioValuesSplitValues.size() > 1) {
                meetOrSlice = aspectRatioValuesSplitValues.get(1).toLowerCase();
            }
        }
        return new String[]{align, meetOrSlice};
    }

    private void applyViewportClip(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        currentCanvas.rectangle(context.getCurrentViewPort());
        currentCanvas.clip();
        currentCanvas.endPath();
    }

    private void applyViewportTranslationCorrection(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        AffineTransform tf = this.calculateViewPortTranslation(context);
        if (!tf.isIdentity() && "none".equals(this.getAttribute("preserveaspectratio"))) {
            currentCanvas.concatMatrix(tf);
        }
    }

    AffineTransform processAspectRatioPosition(SvgDrawContext context, float[] viewBoxValues, String align, float scaleWidth, float scaleHeight) {
        AffineTransform transform = new AffineTransform();
        Rectangle currentViewPort = context.getCurrentViewPort();
        float midXBox = viewBoxValues[0] + viewBoxValues[2] / 2.0f;
        float midYBox = viewBoxValues[1] + viewBoxValues[3] / 2.0f;
        float midXPort = currentViewPort.getX() + currentViewPort.getWidth() / 2.0f;
        float midYPort = currentViewPort.getY() + currentViewPort.getHeight() / 2.0f;
        float x = 0.0f;
        float y = 0.0f;
        if (this.attributesAndStyles.containsKey("x")) {
            x = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
        }
        if (this.attributesAndStyles.containsKey("y")) {
            y = CssUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
        }
        x -= currentViewPort.getX();
        y -= currentViewPort.getY();
        switch (align.toLowerCase()) {
            case "none": {
                break;
            }
            case "xminymin": {
                x -= viewBoxValues[0];
                y -= viewBoxValues[1];
                break;
            }
            case "xminymid": {
                x -= viewBoxValues[0];
                y += midYPort - midYBox;
                break;
            }
            case "xminymax": {
                x -= viewBoxValues[0];
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            case "xmidymin": {
                x += midXPort - midXBox;
                y -= viewBoxValues[1];
                break;
            }
            case "xmidymax": {
                x += midXPort - midXBox;
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            case "xmaxymin": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y -= viewBoxValues[1];
                break;
            }
            case "xmaxymid": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y += midYPort - midYBox;
                break;
            }
            case "xmaxymax": {
                x += currentViewPort.getWidth() - viewBoxValues[2];
                y += currentViewPort.getHeight() - viewBoxValues[3];
                break;
            }
            default: {
                x += midXPort - midXBox;
                y += midYPort - midYBox;
            }
        }
        transform.translate((double)(x /= scaleWidth), (double)(y /= scaleHeight));
        return transform;
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void deepCopyChildren(AbstractBranchSvgNodeRenderer deepCopy) {
        for (ISvgNodeRenderer child : this.children) {
            ISvgNodeRenderer newChild = child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    @Override
    public abstract ISvgNodeRenderer createDeepCopy();

    @Override
    void setPartOfClipPath(boolean isPart) {
        super.setPartOfClipPath(isPart);
        for (ISvgNodeRenderer child : this.children) {
            if (!(child instanceof AbstractSvgNodeRenderer)) continue;
            ((AbstractSvgNodeRenderer)child).setPartOfClipPath(isPart);
        }
    }

    private static float[] scaleViewBoxValues(float[] values, float scaleWidth, float scaleHeight) {
        float[] scaledViewBoxValues = new float[values.length];
        scaledViewBoxValues[0] = values[0] * scaleWidth;
        scaledViewBoxValues[1] = values[1] * scaleHeight;
        scaledViewBoxValues[2] = values[2] * scaleWidth;
        scaledViewBoxValues[3] = values[3] * scaleHeight;
        return scaledViewBoxValues;
    }
}

