/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;
import java.util.List;

public class EllipticalCurveTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 7;
    private Point startPoint;
    private static final double EPS = 1.0E-5;

    public EllipticalCurveTo() {
        this(false);
    }

    public EllipticalCurveTo(boolean relative) {
        super(relative);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point previous) {
        this.startPoint = previous;
        if (inputCoordinates.length < 7) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(rx ry rot largearc sweep x y)+ parameters are expected for elliptical arcs. Got: {0}", (Object[])new Object[]{Arrays.toString(inputCoordinates)}));
        }
        this.coordinates = new String[7];
        System.arraycopy(inputCoordinates, 0, this.coordinates, 0, 7);
        double[] initialPoint = new double[]{previous.getX(), previous.getY()};
        if (this.isRelative()) {
            String[] relativeEndPoint = new String[]{inputCoordinates[5], inputCoordinates[6]};
            String[] absoluteEndPoint = this.copier.makeCoordinatesAbsolute(relativeEndPoint, initialPoint);
            this.coordinates[5] = absoluteEndPoint[0];
            this.coordinates[6] = absoluteEndPoint[1];
        }
    }

    @Override
    public void draw(PdfCanvas canvas) {
        Point start = new Point(this.startPoint.getX() * 0.75, this.startPoint.getY() * 0.75);
        double rx = Math.abs(CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[0]));
        double ry = Math.abs(CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[1]));
        double rotation = Double.parseDouble(this.coordinates[2]) % 360.0;
        rotation = Math.toRadians(rotation);
        boolean largeArc = !CssUtils.compareFloats((float)CssDimensionParsingUtils.parseFloat((String)this.coordinates[3]).floatValue(), (float)0.0f);
        boolean sweep = !CssUtils.compareFloats((float)CssDimensionParsingUtils.parseFloat((String)this.coordinates[4]).floatValue(), (float)0.0f);
        Point end = new Point((double)CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[5]), (double)CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[6]));
        if (CssUtils.compareFloats((double)start.getX(), (double)end.getX()) && CssUtils.compareFloats((double)start.getY(), (double)end.getY())) {
            return;
        }
        if (CssUtils.compareFloats((double)rx, (double)0.0) || CssUtils.compareFloats((double)ry, (double)0.0)) {
            canvas.lineTo(end.getX(), end.getY());
        } else {
            EllipseArc arc;
            if (CssUtils.compareFloats((double)rotation, (double)0.0)) {
                arc = EllipseArc.getEllipse(start, end, rx, ry, sweep, largeArc);
            } else {
                AffineTransform normalizer = AffineTransform.getRotateInstance((double)(-rotation));
                normalizer.translate(-start.getX(), -start.getY());
                Point newArcEnd = normalizer.transform(end, null);
                newArcEnd.move(start.getX(), start.getY());
                arc = EllipseArc.getEllipse(start, newArcEnd, rx, ry, sweep, largeArc);
            }
            Point[][] points = this.makePoints(PdfCanvas.bezierArc((double)arc.ll.getX(), (double)arc.ll.getY(), (double)arc.ur.getX(), (double)arc.ur.getY(), (double)arc.startAng, (double)arc.extent));
            if (sweep) {
                points = EllipticalCurveTo.rotate(points, rotation, points[0][0]);
                for (int i = 0; i < points.length; ++i) {
                    EllipticalCurveTo.drawCurve(canvas, points[i][1], points[i][2], points[i][3]);
                }
            } else {
                points = EllipticalCurveTo.rotate(points, rotation, points[points.length - 1][3]);
                for (int i = points.length - 1; i >= 0; --i) {
                    EllipticalCurveTo.drawCurve(canvas, points[i][2], points[i][1], points[i][0]);
                }
            }
        }
    }

    static Point[][] rotate(Point[][] list, double rotation, Point rotator) {
        if (!CssUtils.compareFloats((double)rotation, (double)0.0)) {
            Point[][] result = new Point[list.length][];
            AffineTransform transRotTrans = AffineTransform.getRotateInstance((double)rotation, (double)rotator.getX(), (double)rotator.getY());
            for (int i = 0; i < list.length; ++i) {
                Point[] input = list[i];
                Point[] row = new Point[input.length];
                for (int j = 0; j < input.length; ++j) {
                    row[j] = transRotTrans.transform(input[j], null);
                }
                result[i] = row;
            }
            return result;
        }
        return list;
    }

    String[] getCoordinates() {
        return this.coordinates;
    }

    private static void drawCurve(PdfCanvas canvas, Point cp1, Point cp2, Point end) {
        canvas.curveTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), end.getX(), end.getY());
    }

    private Point[][] makePoints(List<double[]> input) {
        Point[][] result = new Point[input.size()][];
        for (int i = 0; i < input.size(); ++i) {
            result[i] = new Point[input.get(i).length / 2];
            for (int j = 0; j < input.get(i).length; j += 2) {
                result[i][j / 2] = new Point(input.get(i)[j], input.get(i)[j + 1]);
            }
        }
        return result;
    }

    @Override
    public Rectangle getPathShapeRectangle(Point lastPoint) {
        double[] points = this.getEllipticalArcMinMaxPoints(lastPoint.getX(), lastPoint.getY(), this.getCoordinate(0), this.getCoordinate(1), this.getCoordinate(2), this.getCoordinate(3) != 0.0, this.getCoordinate(4) != 0.0, this.getCoordinate(5), this.getCoordinate(6));
        return new Rectangle((float)CssUtils.convertPxToPts((double)points[0]), (float)CssUtils.convertPxToPts((double)points[1]), (float)CssUtils.convertPxToPts((double)(points[2] - points[0])), (float)CssUtils.convertPxToPts((double)(points[3] - points[1])));
    }

    private double getCoordinate(int index) {
        return CssDimensionParsingUtils.parseDouble((String)this.coordinates[index]);
    }

    private double[] getEllipticalArcMinMaxPoints(double x1, double y1, double rx, double ry, double phi, boolean largeArc, boolean sweep, double x2, double y2) {
        boolean otherArc;
        phi = Math.toRadians(phi);
        rx = Math.abs(rx);
        ry = Math.abs(ry);
        if (rx == 0.0 || ry == 0.0) {
            return new double[]{Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2)};
        }
        double[] centerCoordinatesAndRxRy = this.getEllipseCenterCoordinates(x1, y1, rx, ry, phi, largeArc, sweep, x2, y2);
        if (centerCoordinatesAndRxRy == null) {
            return new double[]{Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2)};
        }
        double cx = centerCoordinatesAndRxRy[0];
        double cy = centerCoordinatesAndRxRy[1];
        rx = centerCoordinatesAndRxRy[2];
        ry = centerCoordinatesAndRxRy[3];
        double[][] extremeCoordinatesAndThetas = this.getExtremeCoordinatesAndAngles(rx, ry, phi, cx, cy);
        double[] extremeCoordinates = extremeCoordinatesAndThetas[0];
        double[] angles = extremeCoordinatesAndThetas[1];
        double xMin = extremeCoordinates[0];
        double yMin = extremeCoordinates[1];
        double xMax = extremeCoordinates[2];
        double yMax = extremeCoordinates[3];
        double xMinAngle = angles[0];
        double yMinAngle = angles[1];
        double xMaxAngle = angles[2];
        double yMaxAngle = angles[3];
        double angle1 = this.getAngleBetweenVectors(x1 - cx, y1 - cy);
        double angle2 = this.getAngleBetweenVectors(x2 - cx, y2 - cy);
        if (!sweep) {
            double temp = angle1;
            angle1 = angle2;
            angle2 = temp;
        }
        boolean bl = otherArc = angle1 > angle2;
        if (otherArc) {
            double temp = angle1;
            angle1 = angle2;
            angle2 = temp;
        }
        if (!this.isPointOnTheArc(xMinAngle, angle1, angle2, otherArc)) {
            xMin = Math.min(x1, x2);
        }
        if (!this.isPointOnTheArc(xMaxAngle, angle1, angle2, otherArc)) {
            xMax = Math.max(x1, x2);
        }
        if (!this.isPointOnTheArc(yMinAngle, angle1, angle2, otherArc)) {
            yMin = Math.min(y1, y2);
        }
        if (!this.isPointOnTheArc(yMaxAngle, angle1, angle2, otherArc)) {
            yMax = Math.max(y1, y2);
        }
        return new double[]{xMin, yMin, xMax, yMax};
    }

    private double[] getEllipseCenterCoordinates(double x1, double y1, double rx, double ry, double phi, boolean largeArc, boolean sweep, double x2, double y2) {
        double x1Prime = Math.cos(phi) * (x1 - x2) / 2.0 + Math.sin(phi) * (y1 - y2) / 2.0;
        double y1Prime = -Math.sin(phi) * (x1 - x2) / 2.0 + Math.cos(phi) * (y1 - y2) / 2.0;
        double radicant = rx * rx * ry * ry - rx * rx * y1Prime * y1Prime - ry * ry * x1Prime * x1Prime;
        radicant /= rx * rx * y1Prime * y1Prime + ry * ry * x1Prime * x1Prime;
        double cxPrime = 0.0;
        double cyPrime = 0.0;
        if (radicant < 0.0) {
            double ratio = rx / ry;
            radicant = y1Prime * y1Prime + x1Prime * x1Prime / (ratio * ratio);
            if (radicant < 0.0) {
                return null;
            }
            ry = Math.sqrt(radicant);
            rx = ratio * ry;
        } else {
            double factor = (largeArc == sweep ? -1.0 : 1.0) * Math.sqrt(radicant);
            cxPrime = factor * rx * y1Prime / ry;
            cyPrime = -factor * ry * x1Prime / rx;
        }
        double cx = cxPrime * Math.cos(phi) - cyPrime * Math.sin(phi) + (x1 + x2) / 2.0;
        double cy = cxPrime * Math.sin(phi) + cyPrime * Math.cos(phi) + (y1 + y2) / 2.0;
        return new double[]{cx, cy, rx, ry};
    }

    private double[][] getExtremeCoordinatesAndAngles(double rx, double ry, double phi, double cx, double cy) {
        double yMaxAngle;
        double yMax;
        double yMinAngle;
        double yMin;
        double xMaxAngle;
        double xMax;
        double xMinAngle;
        double xMin;
        if (this.anglesAreEquals(phi, 0.0) || this.anglesAreEquals(phi, Math.PI)) {
            xMin = cx - rx;
            xMinAngle = this.getAngleBetweenVectors(-rx, 0.0);
            xMax = cx + rx;
            xMaxAngle = this.getAngleBetweenVectors(rx, 0.0);
            yMin = cy - ry;
            yMinAngle = this.getAngleBetweenVectors(0.0, -ry);
            yMax = cy + ry;
            yMaxAngle = this.getAngleBetweenVectors(0.0, ry);
        } else if (this.anglesAreEquals(phi, 1.5707963267948966) || this.anglesAreEquals(phi, 4.71238898038469)) {
            xMin = cx - ry;
            xMinAngle = this.getAngleBetweenVectors(-ry, 0.0);
            xMax = cx + ry;
            xMaxAngle = this.getAngleBetweenVectors(ry, 0.0);
            yMin = cy - rx;
            yMinAngle = this.getAngleBetweenVectors(0.0, -rx);
            yMax = cy + rx;
            yMaxAngle = this.getAngleBetweenVectors(0.0, rx);
        } else {
            double txMin = -Math.atan(ry * Math.tan(phi) / rx);
            double txMax = Math.PI - Math.atan(ry * Math.tan(phi) / rx);
            xMin = cx + rx * Math.cos(txMin) * Math.cos(phi) - ry * Math.sin(txMin) * Math.sin(phi);
            if (xMin > (xMax = cx + rx * Math.cos(txMax) * Math.cos(phi) - ry * Math.sin(txMax) * Math.sin(phi))) {
                double temp = xMin;
                xMin = xMax;
                xMax = temp;
                temp = txMin;
                txMin = txMax;
                txMax = temp;
            }
            double tempY = cy + rx * Math.cos(txMin) * Math.sin(phi) + ry * Math.sin(txMin) * Math.cos(phi);
            xMinAngle = this.getAngleBetweenVectors(xMin - cx, tempY - cy);
            tempY = cy + rx * Math.cos(txMax) * Math.sin(phi) + ry * Math.sin(txMax) * Math.cos(phi);
            xMaxAngle = this.getAngleBetweenVectors(xMax - cx, tempY - cy);
            double tyMin = Math.atan(ry / (Math.tan(phi) * rx));
            double tyMax = Math.atan(ry / (Math.tan(phi) * rx)) + Math.PI;
            yMin = cy + rx * Math.cos(tyMin) * Math.sin(phi) + ry * Math.sin(tyMin) * Math.cos(phi);
            if (yMin > (yMax = cy + rx * Math.cos(tyMax) * Math.sin(phi) + ry * Math.sin(tyMax) * Math.cos(phi))) {
                double temp = yMin;
                yMin = yMax;
                yMax = temp;
                temp = tyMin;
                tyMin = tyMax;
                tyMax = temp;
            }
            double tmpX = cx + rx * Math.cos(tyMin) * Math.cos(phi) - ry * Math.sin(tyMin) * Math.sin(phi);
            yMinAngle = this.getAngleBetweenVectors(tmpX - cx, yMin - cy);
            tmpX = cx + rx * Math.cos(tyMax) * Math.cos(phi) - ry * Math.sin(tyMax) * Math.sin(phi);
            yMaxAngle = this.getAngleBetweenVectors(tmpX - cx, yMax - cy);
        }
        double[] coordinates = new double[]{xMin, yMin, xMax, yMax};
        double[] angles = new double[]{xMinAngle, yMinAngle, xMaxAngle, yMaxAngle};
        return new double[][]{coordinates, angles};
    }

    private boolean isPointOnTheArc(double pointAngle, double angle1, double angle2, boolean otherArc) {
        boolean isThetaBetweenAngles = angle1 <= pointAngle && angle2 >= pointAngle;
        return otherArc != isThetaBetweenAngles;
    }

    private double getAngleBetweenVectors(double bx, double by) {
        return (Math.PI * 2 + (by > 0.0 ? 1.0 : -1.0) * Math.acos(bx / Math.sqrt(bx * bx + by * by))) % (Math.PI * 2);
    }

    private boolean anglesAreEquals(double angle1, double angle2) {
        return Math.abs(angle1 - angle2) < 1.0E-5;
    }

    static class EllipseArc {
        final Point ll;
        final Point ur;
        final double startAng;
        final double extent;

        EllipseArc(Point center, double a, double b, double startAng, double extent) {
            this.ll = new Point(center.getX() - a, center.getY() - b);
            this.ur = new Point(center.getX() + a, center.getY() + b);
            this.startAng = startAng;
            this.extent = extent;
        }

        static EllipseArc getEllipse(Point start, Point end, double a, double b, boolean sweep, boolean largeArc) {
            double between2;
            double r2;
            double r1 = (start.getX() - end.getX()) / (-2.0 * a);
            double factor = Math.sqrt(r1 * r1 + (r2 = (start.getY() - end.getY()) / (2.0 * b)) * r2);
            if (factor > 1.0) {
                return EllipseArc.getEllipse(start, end, a * factor, b * factor, sweep, largeArc);
            }
            double between1 = Math.atan(r1 / r2);
            EllipseArc result = EllipseArc.calculatePossibleMiddle(start, end, a, b, between1 + (between2 = Math.asin(factor)), sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, Math.PI + between1 - between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, Math.PI + between1 + between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            result = EllipseArc.calculatePossibleMiddle(start, end, a, b, between1 - between2, sweep, largeArc);
            if (result != null) {
                return result;
            }
            throw new SvgProcessingException("Could not determine the middle point of the ellipse traced by this elliptical arc");
        }

        static EllipseArc calculatePossibleMiddle(Point start, Point end, double a, double b, double startToCenterAngle, boolean sweep, boolean largeArc) {
            double x0 = start.getX() - a * Math.cos(startToCenterAngle);
            double y0 = start.getY() - b * Math.sin(startToCenterAngle);
            Point center = new Point(x0, y0);
            double check = Math.pow((end.getX() - center.getX()) / a, 2.0) + Math.pow((end.getY() - center.getY()) / b, 2.0);
            if (CssUtils.compareFloats((double)check, (double)1.0)) {
                double theta1 = EllipseArc.calculateAngle(start, center, a, b);
                double theta2 = EllipseArc.calculateAngle(end, center, a, b);
                double startAngl = 0.0;
                double extent = 0.0;
                long deltaTheta = Math.abs(Math.round(theta2 - theta1));
                if (largeArc) {
                    if (sweep) {
                        if (theta2 > theta1 && deltaTheta >= 180L) {
                            startAngl = theta1;
                            extent = theta2 - theta1;
                        }
                        if (theta1 > theta2 && deltaTheta <= 180L) {
                            startAngl = theta1;
                            extent = 360.0 - theta1 + theta2;
                        }
                    } else {
                        if (theta2 > theta1 && deltaTheta <= 180L) {
                            startAngl = theta2;
                            extent = 360.0 - theta2 + theta1;
                        }
                        if (theta1 > theta2 && deltaTheta >= 180L) {
                            startAngl = theta2;
                            extent = theta1 - theta2;
                        }
                    }
                } else if (sweep) {
                    if (theta2 > theta1 && deltaTheta <= 180L) {
                        startAngl = theta1;
                        extent = theta2 - theta1;
                    }
                    if (theta1 > theta2 && deltaTheta >= 180L) {
                        startAngl = theta1;
                        extent = 360.0 - theta1 + theta2;
                    }
                } else {
                    if (theta2 > theta1 && deltaTheta >= 180L) {
                        startAngl = theta2;
                        extent = 360.0 - theta2 + theta1;
                    }
                    if (theta1 > theta2 && deltaTheta <= 180L) {
                        startAngl = theta2;
                        extent = theta1 - theta2;
                    }
                }
                if (startAngl >= 0.0 && extent > 0.0) {
                    return new EllipseArc(center, a, b, startAngl, extent);
                }
            }
            return null;
        }

        static double calculateAngle(Point pt, Point center, double a, double b) {
            double result = Math.pow((pt.getX() - center.getX()) / a, 2.0) + Math.pow((pt.getY() - center.getY()) / b, 2.0);
            double cos = (pt.getX() - center.getX()) / a;
            double sin = (pt.getY() - center.getY()) / b;
            if ((cos = Math.max(Math.min(cos, 1.0), -1.0)) >= 0.0 && sin >= 0.0 || cos < 0.0 && sin >= 0.0) {
                result = EllipseArc.toDegrees(Math.acos(cos));
            }
            if (cos >= 0.0 && sin < 0.0 || cos < 0.0 && sin < 0.0) {
                result = 360.0 - EllipseArc.toDegrees(Math.acos(cos));
            }
            return result;
        }

        static double toDegrees(double radians) {
            return radians * 180.0 / Math.PI;
        }
    }
}

