/*
 * Decompiled with CFR 0.152.
 */
package butterknife.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class InvalidR2UsageDetector
extends Detector
implements Detector.UastScanner {
    private static final String LINT_ERROR_BODY = "R2 should only be used inside annotations";
    private static final String LINT_ERROR_TITLE = "Invalid usage of R2";
    private static final String ISSUE_ID = "InvalidR2Usage";
    private static final Set<String> SUPPORTED_TYPES = ImmutableSet.of((Object)"array", (Object)"attr", (Object)"bool", (Object)"color", (Object)"dimen", (Object)"drawable", (Object[])new String[]{"id", "integer", "string"});
    static final Issue ISSUE = Issue.create((String)"InvalidR2Usage", (String)"Invalid usage of R2", (String)"R2 should only be used inside annotations", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(InvalidR2UsageDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String R2 = "R2";

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UClass.class);
    }

    public UElementHandler createUastHandler(final JavaContext context) {
        return new UElementHandler(){

            public void visitClass(UClass node) {
                node.accept((UastVisitor)new R2UsageVisitor(context));
            }
        };
    }

    private static class R2UsageVisitor
    extends AbstractUastVisitor {
        private final JavaContext context;

        R2UsageVisitor(JavaContext context) {
            this.context = context;
        }

        public boolean visitAnnotation(UAnnotation annotation) {
            return true;
        }

        public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
            R2UsageVisitor.detectR2(this.context, (UElement)node);
            return super.visitQualifiedReferenceExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            R2UsageVisitor.detectR2(this.context, (UElement)node);
            return super.visitSimpleNameReferenceExpression(node);
        }

        private static void detectR2(JavaContext context, UElement node) {
            String qualifiedName;
            UFile sourceFile = context.getUastFile();
            List classes = sourceFile.getClasses();
            if (!classes.isEmpty() && ((UClass)classes.get(0)).getName() != null && ((qualifiedName = ((UClass)classes.get(0)).getName()).contains("_ViewBinder") || qualifiedName.contains("_ViewBinding") || qualifiedName.equals(InvalidR2UsageDetector.R2))) {
                return;
            }
            boolean isR2 = R2UsageVisitor.isR2Expression(node);
            if (isR2 && !context.isSuppressedWithComment(node, ISSUE)) {
                context.report(ISSUE, node, context.getLocation(node), InvalidR2UsageDetector.LINT_ERROR_BODY);
            }
        }

        private static boolean isR2Expression(UElement node) {
            UElement parentNode = node.getUastParent();
            if (parentNode == null) {
                return false;
            }
            String text = node.asSourceString();
            UElement parent = LintUtils.skipParentheses((UElement)parentNode);
            return (text.equals(InvalidR2UsageDetector.R2) || text.contains(".R2")) && parent instanceof UExpression && R2UsageVisitor.endsWithAny(parent.asSourceString(), SUPPORTED_TYPES);
        }

        private static boolean endsWithAny(String text, Set<String> possibleValues) {
            String[] tokens = text.split("\\.");
            return tokens.length > 1 && possibleValues.contains(tokens[tokens.length - 1]);
        }
    }
}

