/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public final class ImmutabilityChecker {
    private final transient Set<Class<?>> immutable = new HashSet();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ImmutabilityChecker ajc$perSingletonInstance;

    @After(value="initialization((@com.jcabi.aspects.Immutable *).new(..))")
    public void after(JoinPoint point) {
        Class<?> type = point.getTarget().getClass();
        try {
            this.check(type);
        }
        catch (Violation ex) {
            throw new IllegalStateException(String.format("%s is not immutable, can't use it (jcabi-aspects 0.18/55a5c13)", type), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(Class<?> type) throws Violation {
        Set<Class<?>> set = this.immutable;
        synchronized (set) {
            if (!this.ignore(type)) {
                if (type.isInterface() && !type.isAnnotationPresent(Immutable.class)) {
                    throw new Violation(String.format("Interface '%s' is not annotated with @Immutable", type.getName()));
                }
                try {
                    this.fields(type);
                }
                catch (Violation ex) {
                    throw new Violation(String.format("Class '%s' is mutable", type.getName()), ex);
                }
                this.immutable.add(type);
                Logger.debug((Object)this, (String)"#check(%s): immutability checked", (Object[])new Object[]{type});
            }
        }
    }

    private void checkArray(Field field) throws Violation {
        if (field.isAnnotationPresent(Immutable.Array.class)) {
            try {
                this.check(field.getType().getComponentType());
            }
            catch (Violation ex) {
                throw new Violation(String.format("Field array component type '%s' is mutable", field.getType().getComponentType().getName()), ex);
            }
        } else {
            throw new Violation(String.format("Field '%s' is an array and is not annotated with @Immutable.Array", field.getName()));
        }
    }

    private boolean ignore(Class<?> type) {
        return type.equals(Object.class) || type.equals(String.class) || type.isPrimitive() || type.getName().startsWith("org.aspectj.runtime.reflect.") || this.immutable.contains(type);
    }

    private void fields(Class<?> type) throws Violation {
        Field[] fields = type.getDeclaredFields();
        int pos = 0;
        while (pos < fields.length) {
            Field field = fields[pos];
            if (!Modifier.isStatic(field.getModifiers())) {
                if (!Modifier.isFinal(field.getModifiers())) {
                    throw new Violation(String.format("field '%s' is not final", field));
                }
                if (!Modifier.isPrivate(field.getModifiers())) {
                    throw new Violation(String.format("field '%s' is not private", field));
                }
                try {
                    if (field.getType() != type) {
                        this.check(field.getType());
                    }
                    if (field.getType().isArray()) {
                        this.checkArray(field);
                    }
                }
                catch (Violation ex) {
                    throw new Violation(String.format("field '%s' is mutable", field), ex);
                }
            }
            ++pos;
        }
    }

    public static ImmutabilityChecker aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.ImmutabilityChecker", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ImmutabilityChecker.ajc$perSingletonInstance = new ImmutabilityChecker();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Violation
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Violation(String msg) {
            super(msg);
        }

        public Violation(String msg, Violation cause) {
            super(msg, cause);
        }
    }
}

