/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.lifecycle.internal.CurrentPhaseForThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadLockedArtifact
implements Artifact {
    private final Artifact real;
    private final CountDownLatch artifactLocked = new CountDownLatch(1);
    private static final InheritableThreadLocal<ThreadLockedArtifact> threadArtifact = new InheritableThreadLocal();

    ThreadLockedArtifact(Artifact real) {
        this.real = real;
    }

    public boolean hasReal() {
        return this.real != null && (!(this.real instanceof ThreadLockedArtifact) || ((ThreadLockedArtifact)this.real).hasReal());
    }

    @Override
    public String getGroupId() {
        return this.real.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.real.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.real.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.real.setVersion(version);
    }

    @Override
    public String getScope() {
        return this.real.getScope();
    }

    @Override
    public String getType() {
        return this.real.getType();
    }

    @Override
    public String getClassifier() {
        return this.real.getClassifier();
    }

    @Override
    public boolean hasClassifier() {
        return this.real.hasClassifier();
    }

    public void attachToThread() {
        threadArtifact.set(this);
    }

    @Override
    public File getFile() {
        ThreadLockedArtifact lockedArtifact = (ThreadLockedArtifact)threadArtifact.get();
        if (lockedArtifact != null && this != lockedArtifact && this.mustLock()) {
            try {
                this.artifactLocked.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.real.getFile();
    }

    private boolean mustLock() {
        boolean dontNeedLock = CurrentPhaseForThread.isPhase("compile") || CurrentPhaseForThread.isPhase("test");
        return !dontNeedLock;
    }

    @Override
    public void setFile(File destination) {
        if (destination != null && destination.exists() && destination.isFile()) {
            this.artifactLocked.countDown();
        }
        this.real.setFile(destination);
    }

    @Override
    public String getBaseVersion() {
        return this.real.getBaseVersion();
    }

    @Override
    public void setBaseVersion(String baseVersion) {
        this.real.setBaseVersion(baseVersion);
    }

    @Override
    public String getId() {
        return this.real.getId();
    }

    @Override
    public String getDependencyConflictId() {
        return this.real.getDependencyConflictId();
    }

    @Override
    public void addMetadata(ArtifactMetadata metadata) {
        this.real.addMetadata(metadata);
    }

    @Override
    public Collection<ArtifactMetadata> getMetadataList() {
        return this.real.getMetadataList();
    }

    @Override
    public void setRepository(ArtifactRepository remoteRepository) {
        this.real.setRepository(remoteRepository);
    }

    @Override
    public ArtifactRepository getRepository() {
        return this.real.getRepository();
    }

    @Override
    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.real.updateVersion(version, localRepository);
    }

    @Override
    public String getDownloadUrl() {
        return this.real.getDownloadUrl();
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.real.setDownloadUrl(downloadUrl);
    }

    @Override
    public ArtifactFilter getDependencyFilter() {
        return this.real.getDependencyFilter();
    }

    @Override
    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.real.setDependencyFilter(artifactFilter);
    }

    @Override
    public ArtifactHandler getArtifactHandler() {
        return this.real.getArtifactHandler();
    }

    @Override
    public List<String> getDependencyTrail() {
        return this.real.getDependencyTrail();
    }

    @Override
    public void setDependencyTrail(List<String> dependencyTrail) {
        this.real.setDependencyTrail(dependencyTrail);
    }

    @Override
    public void setScope(String scope) {
        this.real.setScope(scope);
    }

    @Override
    public VersionRange getVersionRange() {
        return this.real.getVersionRange();
    }

    @Override
    public void setVersionRange(VersionRange newRange) {
        this.real.setVersionRange(newRange);
    }

    @Override
    public void selectVersion(String version) {
        this.real.selectVersion(version);
    }

    @Override
    public void setGroupId(String groupId) {
        this.real.setGroupId(groupId);
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.real.setArtifactId(artifactId);
    }

    @Override
    public boolean isSnapshot() {
        return this.real.isSnapshot();
    }

    @Override
    public void setResolved(boolean resolved) {
        this.real.setResolved(resolved);
    }

    @Override
    public boolean isResolved() {
        return this.real.isResolved();
    }

    @Override
    public void setResolvedVersion(String version) {
        this.real.setResolvedVersion(version);
    }

    @Override
    public void setArtifactHandler(ArtifactHandler handler) {
        this.real.setArtifactHandler(handler);
    }

    @Override
    public boolean isRelease() {
        return this.real.isRelease();
    }

    @Override
    public void setRelease(boolean release) {
        this.real.setRelease(release);
    }

    @Override
    public List<ArtifactVersion> getAvailableVersions() {
        return this.real.getAvailableVersions();
    }

    @Override
    public void setAvailableVersions(List<ArtifactVersion> versions) {
        this.real.setAvailableVersions(versions);
    }

    @Override
    public boolean isOptional() {
        return this.real.isOptional();
    }

    @Override
    public void setOptional(boolean optional) {
        this.real.setOptional(optional);
    }

    @Override
    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.real.getSelectedVersion();
    }

    @Override
    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.real.isSelectedVersionKnown();
    }

    @Override
    public int compareTo(Artifact o) {
        return this.real.compareTo(o);
    }
}

