/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private RegistryStrategyOSGI strategy;
    private Object token;
    private HashMap dynamicAddStateStamps = new HashMap();
    private long[] currentStateStamp = new long[1];

    public EclipseBundleListener(ExtensionRegistry registry, Object key, RegistryStrategyOSGI strategy) {
        this.registry = registry;
        this.token = key;
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Bundle bundle2 = event.getBundle();
        switch (event.getType()) {
            case 32: {
                long[] lArray = this.currentStateStamp;
                synchronized (this.currentStateStamp) {
                    long newStateStamp = this.registry.computeState();
                    if (this.currentStateStamp[0] != newStateStamp) {
                        this.currentStateStamp[0] = newStateStamp;
                        this.dynamicAddStateStamps.clear();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    this.addBundle(bundle2, true);
                    break;
                }
            }
            case 64: {
                this.removeBundle(bundle2);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i], false);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle2) {
        return (bundle2.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle2) {
        URL pluginManifest;
        long timestamp = 0L;
        if (this.strategy.checkContributionsTimestamp() && (pluginManifest = EclipseBundleListener.getExtensionURL(bundle2, false)) != null) {
            timestamp = this.strategy.getExtendedTimestamp(bundle2, pluginManifest);
        }
        this.registry.remove(Long.toString(bundle2.getBundleId()), timestamp);
    }

    public static URL getExtensionURL(Bundle bundle2, boolean report) {
        if (bundle2.getBundleId() == 0L) {
            return null;
        }
        if (bundle2.getSymbolicName() == null) {
            return null;
        }
        boolean isFragment = OSGIUtils.getDefault().isFragment(bundle2);
        String manifestName = isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        URL extensionURL = bundle2.getEntry(manifestName);
        if (extensionURL == null) {
            return null;
        }
        if (!EclipseBundleListener.isSingleton(bundle2)) {
            if (report && !EclipseBundleListener.isGeneratedManifest(bundle2)) {
                String message = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundle2.getSymbolicName());
                RuntimeLog.log(new Status(2, "org.eclipse.equinox.registry", 0, message, null));
            }
            return null;
        }
        if (!isFragment) {
            return extensionURL;
        }
        Bundle[] hosts = OSGIUtils.getDefault().getHosts(bundle2);
        if (hosts == null) {
            return null;
        }
        if (EclipseBundleListener.isSingleton(hosts[0])) {
            return extensionURL;
        }
        if (report) {
            String message = NLS.bind((String)RegistryMessages.parse_nonSingletonFragment, (Object)bundle2.getSymbolicName(), (Object)hosts[0].getSymbolicName());
            RuntimeLog.log(new Status(2, "org.eclipse.equinox.registry", 0, message, null));
        }
        return null;
    }

    private static boolean isGeneratedManifest(Bundle bundle2) {
        return bundle2.getHeaders("").get("Generated-from") != null;
    }

    private void addBundle(Bundle bundle2, boolean checkNLSFragments) {
        BufferedInputStream is;
        IContributor contributor;
        if (checkNLSFragments) {
            this.checkForNLSFragment(bundle2);
        }
        if (this.registry.hasContributor(contributor = ContributorFactoryOSGi.createContributor(bundle2))) {
            return;
        }
        URL pluginManifest = EclipseBundleListener.getExtensionURL(bundle2, true);
        if (pluginManifest == null) {
            return;
        }
        try {
            is = new BufferedInputStream(pluginManifest.openStream());
        }
        catch (IOException iOException) {
            is = null;
        }
        if (is == null) {
            return;
        }
        ResourceBundle translationBundle = null;
        try {
            translationBundle = ResourceTranslator.getResourceBundle(bundle2);
        }
        catch (MissingResourceException missingResourceException) {}
        long timestamp = 0L;
        if (this.strategy.checkContributionsTimestamp()) {
            timestamp = this.strategy.getExtendedTimestamp(bundle2, pluginManifest);
        }
        this.registry.addContribution(is, contributor, true, pluginManifest.getPath(), translationBundle, this.token, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNLSFragment(Bundle bundle2) {
        if (!OSGIUtils.getDefault().isFragment(bundle2)) {
            long[] lArray = this.currentStateStamp;
            synchronized (this.currentStateStamp) {
                this.dynamicAddStateStamps.put(Long.toString(bundle2.getBundleId()), new Long(this.currentStateStamp[0]));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        Bundle[] hosts = OSGIUtils.getDefault().getHosts(bundle2);
        if (hosts == null) {
            return;
        }
        int i = 0;
        while (i < hosts.length) {
            this.checkForNLSFiles(hosts[i], bundle2);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForNLSFiles(Bundle host, Bundle fragment) {
        String hostID = Long.toString(host.getBundleId());
        long[] lArray = this.currentStateStamp;
        synchronized (this.currentStateStamp) {
            int i;
            Long hostStateStamp = (Long)this.dynamicAddStateStamps.get(hostID);
            if (hostStateStamp != null && this.currentStateStamp[0] == hostStateStamp) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Bundle[] fragments = OSGIUtils.getDefault().getFragments(host);
            boolean refresh = false;
            if (this.hasNLSFilesFor(host, fragment)) {
                refresh = true;
            } else {
                i = 0;
                while (i < fragments.length && !refresh) {
                    if (!fragment.equals(fragments[i]) && this.hasNLSFilesFor(fragments[i], fragment)) {
                        refresh = true;
                    }
                    ++i;
                }
            }
            if (!refresh) return;
            this.removeBundle(host);
            this.addBundle(host, false);
            i = 0;
            while (i < fragments.length) {
                if (!fragment.equals(fragments[i])) {
                    this.removeBundle(fragments[i]);
                    this.addBundle(fragments[i], false);
                }
                ++i;
            }
            long[] lArray2 = this.currentStateStamp;
            synchronized (this.currentStateStamp) {
                this.dynamicAddStateStamps.put(hostID, new Long(this.currentStateStamp[0]));
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return;
            }
        }
    }

    private boolean hasNLSFilesFor(Bundle target, Bundle fragment) {
        String filePattern;
        URL baseNLS;
        if (!this.registry.hasContributor(Long.toString(target.getBundleId()))) {
            return false;
        }
        Dictionary<String, String> targetHeaders = target.getHeaders("");
        String localization = targetHeaders.get("Bundle-Localization");
        if (localization == null) {
            localization = "OSGI-INF/l10n/bundle";
        }
        if ((baseNLS = target.getEntry(String.valueOf(localization) + ".properties")) == null) {
            return false;
        }
        int lastSlash = localization.lastIndexOf(47);
        if (lastSlash == localization.length() - 1) {
            return false;
        }
        String baseDir = lastSlash < 0 ? "" : localization.substring(0, lastSlash);
        Enumeration<URL> nlsFiles = fragment.findEntries(baseDir, filePattern = String.valueOf(lastSlash < 0 ? localization : localization.substring(lastSlash + 1)) + "_*.properties", false);
        return nlsFiles != null;
    }

    private static boolean isSingleton(Bundle bundle2) {
        Dictionary<String, String> allHeaders = bundle2.getHeaders("");
        String symbolicNameHeader = allHeaders.get("Bundle-SymbolicName");
        try {
            ManifestElement[] symbolicNameElements;
            if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader)).length > 0) {
                String singleton = symbolicNameElements[0].getDirective("singleton");
                if (singleton == null) {
                    singleton = symbolicNameElements[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(singleton)) {
                    String manifestVersion = allHeaders.get("Bundle-ManifestVersion");
                    return manifestVersion == null && OSGIUtils.getDefault().getBundle(symbolicNameElements[0].getValue()) == bundle2;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

