/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.impl.internal.TrackingFileManager;
import org.sonatype.aether.repository.LocalArtifactRegistration;
import org.sonatype.aether.repository.LocalArtifactRequest;
import org.sonatype.aether.repository.LocalArtifactResult;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private static final String LOCAL_REPO_ID = "";
    private TrackingFileManager trackingFileManager = new TrackingFileManager();

    public EnhancedLocalRepositoryManager(File basedir) {
        super(basedir, "enhanced");
    }

    @Override
    public EnhancedLocalRepositoryManager setLogger(Logger logger2) {
        super.setLogger(logger2);
        this.trackingFileManager.setLogger(logger2);
        return this;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            Properties props = this.readRepos(file);
            if (props.get(this.getKey(file, LOCAL_REPO_ID)) != null) {
                result.setAvailable(true);
            } else {
                String context = request.getContext();
                for (RemoteRepository repository : request.getRepositories()) {
                    if (props.get(this.getKey(file, this.getRepositoryKey(repository, context))) == null) continue;
                    result.setAvailable(true);
                    result.setRepository(repository);
                    break;
                }
                if (!result.isAvailable() && !this.isTracked(props, file)) {
                    result.setAvailable(true);
                }
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        if (request.getRepository() == null) {
            this.addArtifact(request.getArtifact(), Collections.singleton(LOCAL_REPO_ID));
        } else {
            this.addArtifact(request.getArtifact(), this.getRepositoryKeys(request.getRepository(), request.getContexts()));
        }
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys = new HashSet<String>();
        if (contexts != null) {
            for (String context : contexts) {
                keys.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact to register not specified");
        }
        String path = this.getPathForLocalArtifact(artifact);
        File file = new File(this.getRepository().getBasedir(), path);
        this.addRepo(file, repositories);
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(File artifactFile, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactFile, repository), LOCAL_REPO_ID);
        }
        File trackingFile = this.getTrackingFile(artifactFile);
        this.trackingFileManager.update(trackingFile, updates);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), "_maven.repositories");
    }

    private String getKey(File file, String repository) {
        return file.getName() + '>' + repository;
    }

    private boolean isTracked(Properties props, File file) {
        if (props != null) {
            String keyPrefix = file.getName() + '>';
            for (Object key : props.keySet()) {
                if (!key.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

