/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.maven.plugin;

import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.jcabi.maven.plugin.VersionalizeMojo$AjcClosure1;
import com.jcabi.maven.plugin.VersionalizeMojo$AjcClosure3;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.impl.StaticLoggerBinder;

@Loggable(value=1)
@Mojo(name="versionalize", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public final class VersionalizeMojo
extends AbstractMojo {
    @Component
    private transient MavenProject project;
    @Parameter(property="buildNumber", required=false, readonly=false)
    private transient String buildNumber;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Loggable(value=1, limit=1, unit=TimeUnit.MINUTES)
    public void execute() throws MojoFailureException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodLogger.aspectOf().wrapClass(new VersionalizeMojo$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        VersionalizeMojo.execute_aroundBody2(this, joinPoint);
    }

    private String text(@NotNull File dir) {
        File file = dir;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)file);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        StringBuilder text = new StringBuilder(0).append(String.format("Build Number: %s%n", this.buildNumber)).append(String.format("Project Version: %s%n", this.project.getVersion())).append(String.format("Build Date: %s%n%n", DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date())));
        for (String name : VersionalizeMojo.files(dir, "*")) {
            File file2 = new File(dir, name);
            if (!file2.isFile()) continue;
            text.append(name).append(": ").append(file2.length()).append('\n');
        }
        return text.toString();
    }

    private void versionalize(@NotNull File src, @NotNull File dest) throws IOException {
        File file = src;
        File file2 = dest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)file, (Object)file2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Collection dirs = FileUtils.listFilesAndDirs((File)src, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        String name = String.format("%s-%s-%s.txt", VersionalizeMojo.cleanup(this.project.getGroupId()), VersionalizeMojo.cleanup(this.project.getArtifactId()), VersionalizeMojo.cleanup(this.project.getPackaging()));
        for (File dir : dirs) {
            if (VersionalizeMojo.files(dir, "*.java").isEmpty()) continue;
            File ddir = new File(dest, StringUtils.substring((String)dir.getCanonicalPath(), (int)(src.getCanonicalPath().length() + 1)));
            File version = new File(ddir, name);
            if (version.getParentFile().mkdirs()) {
                Logger.info((Object)((Object)this), (String)"created dir %s", (Object[])new Object[]{version.getParentFile()});
            }
            FileUtils.write((File)version, (CharSequence)this.text(ddir));
            Logger.info((Object)((Object)this), (String)"File %s added", (Object[])new Object[]{version});
        }
    }

    private static String cleanup(String text) {
        return text.replaceAll("[^_a-z0-9\\-]", "-");
    }

    private static Collection<String> files(File dir, String mask) {
        WildcardFileFilter filter = new WildcardFileFilter(mask);
        File[] files = dir.listFiles((FileFilter)filter);
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }

    public String toString() {
        return "VersionalizeMojo(project=" + this.project + ", buildNumber=" + this.buildNumber + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionalizeMojo)) {
            return false;
        }
        VersionalizeMojo other = (VersionalizeMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionalizeMojo;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static {
        VersionalizeMojo.ajc$preClinit();
    }

    static /* synthetic */ void execute_aroundBody0(VersionalizeMojo ajc$this, JoinPoint joinPoint) {
        StaticLoggerBinder.getSingleton().setMavenLog(ajc$this.getLog());
        File src = new File(ajc$this.project.getBuild().getSourceDirectory());
        if (!src.exists()) {
            Logger.info((Object)((Object)ajc$this), (String)"source directory '%s' is absent", (Object[])new Object[]{src});
            return;
        }
        File dest = new File(ajc$this.project.getBuild().getOutputDirectory());
        if (dest.mkdirs()) {
            Logger.info((Object)((Object)ajc$this), (String)"created directory %s", (Object[])new Object[]{dest});
        }
        Logger.info((Object)((Object)ajc$this), (String)"Versionalizing %s directory", (Object[])new Object[]{dest});
        try {
            ajc$this.versionalize(src, dest);
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to versionalize", (Throwable)ex);
        }
    }

    static /* synthetic */ void execute_aroundBody2(VersionalizeMojo versionalizeMojo, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{versionalizeMojo, joinPoint};
        MethodLogger.aspectOf().wrapMethod(new VersionalizeMojo$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VersionalizeMojo.java", VersionalizeMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.jcabi.maven.plugin.VersionalizeMojo", "", "", "org.apache.maven.plugin.MojoFailureException", "void"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "text", "com.jcabi.maven.plugin.VersionalizeMojo", "java.io.File", "dir", "", "java.lang.String"), 123);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "versionalize", "com.jcabi.maven.plugin.VersionalizeMojo", "java.io.File:java.io.File", "src:dest", "java.io.IOException", "void"), 157);
    }
}

