/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.android.R;
import com.journeyapps.barcodescanner.CameraPreview;
import java.util.ArrayList;
import java.util.List;

public class ViewfinderView
extends View {
    protected static final String TAG = ViewfinderView.class.getSimpleName();
    protected static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    protected static final long ANIMATION_DELAY = 80L;
    protected static final int CURRENT_POINT_OPACITY = 160;
    protected static final int MAX_RESULT_POINTS = 20;
    protected static final int POINT_SIZE = 6;
    protected final Paint paint = new Paint(1);
    protected Bitmap resultBitmap;
    protected final int maskColor;
    protected final int resultColor;
    protected final int laserColor;
    protected final int resultPointColor;
    protected int scannerAlpha;
    protected List<ResultPoint> possibleResultPoints;
    protected List<ResultPoint> lastPossibleResultPoints;
    protected CameraPreview cameraPreview;
    protected Rect framingRect;
    protected Rect previewFramingRect;

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.zxing_finder);
        this.maskColor = attributes.getColor(R.styleable.zxing_finder_zxing_viewfinder_mask, resources.getColor(R.color.zxing_viewfinder_mask));
        this.resultColor = attributes.getColor(R.styleable.zxing_finder_zxing_result_view, resources.getColor(R.color.zxing_result_view));
        this.laserColor = attributes.getColor(R.styleable.zxing_finder_zxing_viewfinder_laser, resources.getColor(R.color.zxing_viewfinder_laser));
        this.resultPointColor = attributes.getColor(R.styleable.zxing_finder_zxing_possible_result_points, resources.getColor(R.color.zxing_possible_result_points));
        attributes.recycle();
        this.scannerAlpha = 0;
        this.possibleResultPoints = new ArrayList<ResultPoint>(5);
        this.lastPossibleResultPoints = null;
    }

    public void setCameraPreview(CameraPreview view) {
        this.cameraPreview = view;
        view.addStateListener(new CameraPreview.StateListener(){

            @Override
            public void previewSized() {
                ViewfinderView.this.refreshSizes();
                ViewfinderView.this.invalidate();
            }

            @Override
            public void previewStarted() {
            }

            @Override
            public void previewStopped() {
            }

            @Override
            public void cameraError(Exception error) {
            }

            @Override
            public void cameraClosed() {
            }
        });
    }

    protected void refreshSizes() {
        if (this.cameraPreview == null) {
            return;
        }
        Rect framingRect = this.cameraPreview.getFramingRect();
        Rect previewFramingRect = this.cameraPreview.getPreviewFramingRect();
        if (framingRect != null && previewFramingRect != null) {
            this.framingRect = framingRect;
            this.previewFramingRect = previewFramingRect;
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        this.refreshSizes();
        if (this.framingRect == null || this.previewFramingRect == null) {
            return;
        }
        Rect frame = this.framingRect;
        Rect previewFrame = this.previewFramingRect;
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(160);
            canvas.drawBitmap(this.resultBitmap, null, frame, this.paint);
        } else {
            this.paint.setColor(this.laserColor);
            this.paint.setAlpha(SCANNER_ALPHA[this.scannerAlpha]);
            this.scannerAlpha = (this.scannerAlpha + 1) % SCANNER_ALPHA.length;
            int middle = frame.height() / 2 + frame.top;
            canvas.drawRect((float)(frame.left + 2), (float)(middle - 1), (float)(frame.right - 1), (float)(middle + 2), this.paint);
            float scaleX = (float)frame.width() / (float)previewFrame.width();
            float scaleY = (float)frame.height() / (float)previewFrame.height();
            List<ResultPoint> currentPossible = this.possibleResultPoints;
            List<ResultPoint> currentLast = this.lastPossibleResultPoints;
            int frameLeft = frame.left;
            int frameTop = frame.top;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new ArrayList<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(160);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), 6.0f, this.paint);
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(80);
                this.paint.setColor(this.resultPointColor);
                float radius = 3.0f;
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), radius, this.paint);
                }
            }
            this.postInvalidateDelayed(80L, frame.left - 6, frame.top - 6, frame.right + 6, frame.bottom + 6);
        }
    }

    public void drawViewfinder() {
        Bitmap resultBitmap = this.resultBitmap;
        this.resultBitmap = null;
        if (resultBitmap != null) {
            resultBitmap.recycle();
        }
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap result) {
        this.resultBitmap = result;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        List<ResultPoint> points = this.possibleResultPoints;
        points.add(point);
        int size = points.size();
        if (size > 20) {
            points.subList(0, size - 10).clear();
        }
    }
}

