/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import com.journeyapps.barcodescanner.camera.CameraSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class CameraConfigurationUtils {
    private static final String TAG = "CameraConfiguration";
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final float MAX_EXPOSURE_COMPENSATION = 1.5f;
    private static final float MIN_EXPOSURE_COMPENSATION = 0.0f;
    private static final int MIN_FPS = 10;
    private static final int MAX_FPS = 20;
    private static final int AREA_PER_1000 = 400;

    private CameraConfigurationUtils() {
    }

    public static void setFocus(Camera.Parameters parameters, CameraSettings.FocusMode focusModeSetting, boolean safeMode) {
        List supportedFocusModes = parameters.getSupportedFocusModes();
        String focusMode = null;
        if (safeMode || focusModeSetting == CameraSettings.FocusMode.AUTO) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "auto");
        } else if (focusModeSetting == CameraSettings.FocusMode.CONTINUOUS) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "continuous-picture", "continuous-video", "auto");
        } else if (focusModeSetting == CameraSettings.FocusMode.INFINITY) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "infinity");
        } else if (focusModeSetting == CameraSettings.FocusMode.MACRO) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "macro");
        }
        if (!safeMode && focusMode == null) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "macro", "edof");
        }
        if (focusMode != null) {
            if (focusMode.equals(parameters.getFocusMode())) {
                Log.i((String)TAG, (String)("Focus mode already set to " + focusMode));
            } else {
                parameters.setFocusMode(focusMode);
            }
        }
    }

    public static void setTorch(Camera.Parameters parameters, boolean on) {
        List supportedFlashModes = parameters.getSupportedFlashModes();
        String flashMode = on ? CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "torch", "on") : CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "off");
        if (flashMode != null) {
            if (flashMode.equals(parameters.getFlashMode())) {
                Log.i((String)TAG, (String)("Flash mode already set to " + flashMode));
            } else {
                Log.i((String)TAG, (String)("Setting flash mode to " + flashMode));
                parameters.setFlashMode(flashMode);
            }
        }
    }

    public static void setBestExposure(Camera.Parameters parameters, boolean lightOn) {
        int minExposure = parameters.getMinExposureCompensation();
        int maxExposure = parameters.getMaxExposureCompensation();
        float step = parameters.getExposureCompensationStep();
        if ((minExposure != 0 || maxExposure != 0) && step > 0.0f) {
            float targetCompensation = lightOn ? 0.0f : 1.5f;
            int compensationSteps = Math.round(targetCompensation / step);
            float actualCompensation = step * (float)compensationSteps;
            compensationSteps = Math.max(Math.min(compensationSteps, maxExposure), minExposure);
            if (parameters.getExposureCompensation() == compensationSteps) {
                Log.i((String)TAG, (String)("Exposure compensation already set to " + compensationSteps + " / " + actualCompensation));
            } else {
                Log.i((String)TAG, (String)("Setting exposure compensation to " + compensationSteps + " / " + actualCompensation));
                parameters.setExposureCompensation(compensationSteps);
            }
        } else {
            Log.i((String)TAG, (String)"Camera does not support exposure compensation");
        }
    }

    public static void setBestPreviewFPS(Camera.Parameters parameters) {
        CameraConfigurationUtils.setBestPreviewFPS(parameters, 10, 20);
    }

    public static void setBestPreviewFPS(Camera.Parameters parameters, int minFPS, int maxFPS) {
        List supportedPreviewFpsRanges = parameters.getSupportedPreviewFpsRange();
        Log.i((String)TAG, (String)("Supported FPS ranges: " + CameraConfigurationUtils.toString(supportedPreviewFpsRanges)));
        if (supportedPreviewFpsRanges != null && !supportedPreviewFpsRanges.isEmpty()) {
            int[] suitableFPSRange = null;
            for (int[] fpsRange : supportedPreviewFpsRanges) {
                int thisMin = fpsRange[0];
                int thisMax = fpsRange[1];
                if (thisMin < minFPS * 1000 || thisMax > maxFPS * 1000) continue;
                suitableFPSRange = fpsRange;
                break;
            }
            if (suitableFPSRange == null) {
                Log.i((String)TAG, (String)"No suitable FPS range?");
            } else {
                int[] currentFpsRange = new int[2];
                parameters.getPreviewFpsRange(currentFpsRange);
                if (Arrays.equals(currentFpsRange, suitableFPSRange)) {
                    Log.i((String)TAG, (String)("FPS range already set to " + Arrays.toString(suitableFPSRange)));
                } else {
                    Log.i((String)TAG, (String)("Setting FPS range to " + Arrays.toString(suitableFPSRange)));
                    parameters.setPreviewFpsRange(suitableFPSRange[0], suitableFPSRange[1]);
                }
            }
        }
    }

    @TargetApi(value=15)
    public static void setFocusArea(Camera.Parameters parameters) {
        if (parameters.getMaxNumFocusAreas() > 0) {
            Log.i((String)TAG, (String)("Old focus areas: " + CameraConfigurationUtils.toString(parameters.getFocusAreas())));
            List<Camera.Area> middleArea = CameraConfigurationUtils.buildMiddleArea(400);
            Log.i((String)TAG, (String)("Setting focus area to : " + CameraConfigurationUtils.toString(middleArea)));
            parameters.setFocusAreas(middleArea);
        } else {
            Log.i((String)TAG, (String)"Device does not support focus areas");
        }
    }

    @TargetApi(value=15)
    public static void setMetering(Camera.Parameters parameters) {
        if (parameters.getMaxNumMeteringAreas() > 0) {
            Log.i((String)TAG, (String)("Old metering areas: " + parameters.getMeteringAreas()));
            List<Camera.Area> middleArea = CameraConfigurationUtils.buildMiddleArea(400);
            Log.i((String)TAG, (String)("Setting metering area to : " + CameraConfigurationUtils.toString(middleArea)));
            parameters.setMeteringAreas(middleArea);
        } else {
            Log.i((String)TAG, (String)"Device does not support metering areas");
        }
    }

    @TargetApi(value=15)
    private static List<Camera.Area> buildMiddleArea(int areaPer1000) {
        return Collections.singletonList(new Camera.Area(new Rect(-areaPer1000, -areaPer1000, areaPer1000, areaPer1000), 1));
    }

    @TargetApi(value=15)
    public static void setVideoStabilization(Camera.Parameters parameters) {
        if (parameters.isVideoStabilizationSupported()) {
            if (parameters.getVideoStabilization()) {
                Log.i((String)TAG, (String)"Video stabilization already enabled");
            } else {
                Log.i((String)TAG, (String)"Enabling video stabilization...");
                parameters.setVideoStabilization(true);
            }
        } else {
            Log.i((String)TAG, (String)"This device does not support video stabilization");
        }
    }

    public static void setBarcodeSceneMode(Camera.Parameters parameters) {
        if ("barcode".equals(parameters.getSceneMode())) {
            Log.i((String)TAG, (String)"Barcode scene mode already set");
            return;
        }
        String sceneMode = CameraConfigurationUtils.findSettableValue("scene mode", parameters.getSupportedSceneModes(), "barcode");
        if (sceneMode != null) {
            parameters.setSceneMode(sceneMode);
        }
    }

    public static void setZoom(Camera.Parameters parameters, double targetZoomRatio) {
        if (parameters.isZoomSupported()) {
            Integer zoom = CameraConfigurationUtils.indexOfClosestZoom(parameters, targetZoomRatio);
            if (zoom == null) {
                return;
            }
            if (parameters.getZoom() == zoom.intValue()) {
                Log.i((String)TAG, (String)("Zoom is already set to " + zoom));
            } else {
                Log.i((String)TAG, (String)("Setting zoom to " + zoom));
                parameters.setZoom(zoom.intValue());
            }
        } else {
            Log.i((String)TAG, (String)"Zoom is not supported");
        }
    }

    private static Integer indexOfClosestZoom(Camera.Parameters parameters, double targetZoomRatio) {
        List ratios = parameters.getZoomRatios();
        Log.i((String)TAG, (String)("Zoom ratios: " + ratios));
        int maxZoom = parameters.getMaxZoom();
        if (ratios == null || ratios.isEmpty() || ratios.size() != maxZoom + 1) {
            Log.w((String)TAG, (String)"Invalid zoom ratios!");
            return null;
        }
        double target100 = 100.0 * targetZoomRatio;
        double smallestDiff = Double.POSITIVE_INFINITY;
        int closestIndex = 0;
        for (int i = 0; i < ratios.size(); ++i) {
            double diff = Math.abs((double)((Integer)ratios.get(i)).intValue() - target100);
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            closestIndex = i;
        }
        Log.i((String)TAG, (String)("Chose zoom ratio of " + (double)((Integer)ratios.get(closestIndex)).intValue() / 100.0));
        return closestIndex;
    }

    public static void setInvertColor(Camera.Parameters parameters) {
        if ("negative".equals(parameters.getColorEffect())) {
            Log.i((String)TAG, (String)"Negative effect already set");
            return;
        }
        String colorMode = CameraConfigurationUtils.findSettableValue("color effect", parameters.getSupportedColorEffects(), "negative");
        if (colorMode != null) {
            parameters.setColorEffect(colorMode);
        }
    }

    private static String findSettableValue(String name, Collection<String> supportedValues, String ... desiredValues) {
        Log.i((String)TAG, (String)("Requesting " + name + " value from among: " + Arrays.toString(desiredValues)));
        Log.i((String)TAG, (String)("Supported " + name + " values: " + supportedValues));
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                Log.i((String)TAG, (String)("Can set " + name + " to: " + desiredValue));
                return desiredValue;
            }
        }
        Log.i((String)TAG, (String)"No supported values match");
        return null;
    }

    private static String toString(Collection<int[]> arrays) {
        if (arrays == null || arrays.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        Iterator<int[]> it = arrays.iterator();
        while (it.hasNext()) {
            buffer.append(Arrays.toString(it.next()));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    @TargetApi(value=15)
    private static String toString(Iterable<Camera.Area> areas) {
        if (areas == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Camera.Area area : areas) {
            result.append(area.rect).append(':').append(area.weight).append(' ');
        }
        return result.toString();
    }

    public static String collectStats(Camera.Parameters parameters) {
        return CameraConfigurationUtils.collectStats(parameters.flatten());
    }

    public static String collectStats(CharSequence flattenedParams) {
        StringBuilder result = new StringBuilder(1000);
        result.append("BOARD=").append(Build.BOARD).append('\n');
        result.append("BRAND=").append(Build.BRAND).append('\n');
        result.append("CPU_ABI=").append(Build.CPU_ABI).append('\n');
        result.append("DEVICE=").append(Build.DEVICE).append('\n');
        result.append("DISPLAY=").append(Build.DISPLAY).append('\n');
        result.append("FINGERPRINT=").append(Build.FINGERPRINT).append('\n');
        result.append("HOST=").append(Build.HOST).append('\n');
        result.append("ID=").append(Build.ID).append('\n');
        result.append("MANUFACTURER=").append(Build.MANUFACTURER).append('\n');
        result.append("MODEL=").append(Build.MODEL).append('\n');
        result.append("PRODUCT=").append(Build.PRODUCT).append('\n');
        result.append("TAGS=").append(Build.TAGS).append('\n');
        result.append("TIME=").append(Build.TIME).append('\n');
        result.append("TYPE=").append(Build.TYPE).append('\n');
        result.append("USER=").append(Build.USER).append('\n');
        result.append("VERSION.CODENAME=").append(Build.VERSION.CODENAME).append('\n');
        result.append("VERSION.INCREMENTAL=").append(Build.VERSION.INCREMENTAL).append('\n');
        result.append("VERSION.RELEASE=").append(Build.VERSION.RELEASE).append('\n');
        result.append("VERSION.SDK_INT=").append(Build.VERSION.SDK_INT).append('\n');
        if (flattenedParams != null) {
            Object[] params = SEMICOLON.split(flattenedParams);
            Arrays.sort(params);
            for (Object param : params) {
                result.append((String)param).append('\n');
            }
        }
        return result.toString();
    }
}

