/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.journeyapps.barcodescanner.CaptureActivity;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanOptions {
    public static final String UPC_A = "UPC_A";
    public static final String UPC_E = "UPC_E";
    public static final String EAN_8 = "EAN_8";
    public static final String EAN_13 = "EAN_13";
    public static final String RSS_14 = "RSS_14";
    public static final String CODE_39 = "CODE_39";
    public static final String CODE_93 = "CODE_93";
    public static final String CODE_128 = "CODE_128";
    public static final String ITF = "ITF";
    public static final String RSS_EXPANDED = "RSS_EXPANDED";
    public static final String QR_CODE = "QR_CODE";
    public static final String DATA_MATRIX = "DATA_MATRIX";
    public static final String PDF_417 = "PDF_417";
    public static final Collection<String> PRODUCT_CODE_TYPES = ScanOptions.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "RSS_14");
    public static final Collection<String> ONE_D_CODE_TYPES = ScanOptions.list("UPC_A", "UPC_E", "EAN_8", "EAN_13", "RSS_14", "CODE_39", "CODE_93", "CODE_128", "ITF", "RSS_14", "RSS_EXPANDED");
    public static final Collection<String> ALL_CODE_TYPES = null;
    private final Map<String, Object> moreExtras = new HashMap<String, Object>(3);
    private Collection<String> desiredBarcodeFormats;
    private Class<?> captureActivity;

    protected Class<?> getDefaultCaptureActivity() {
        return CaptureActivity.class;
    }

    public Class<?> getCaptureActivity() {
        if (this.captureActivity == null) {
            this.captureActivity = this.getDefaultCaptureActivity();
        }
        return this.captureActivity;
    }

    public ScanOptions setCaptureActivity(Class<?> captureActivity) {
        this.captureActivity = captureActivity;
        return this;
    }

    public Map<String, ?> getMoreExtras() {
        return this.moreExtras;
    }

    public final ScanOptions addExtra(String key, Object value) {
        this.moreExtras.put(key, value);
        return this;
    }

    public final ScanOptions setPrompt(String prompt) {
        if (prompt != null) {
            this.addExtra("PROMPT_MESSAGE", prompt);
        }
        return this;
    }

    public ScanOptions setOrientationLocked(boolean locked) {
        this.addExtra("SCAN_ORIENTATION_LOCKED", locked);
        return this;
    }

    public ScanOptions setCameraId(int cameraId) {
        if (cameraId >= 0) {
            this.addExtra("SCAN_CAMERA_ID", cameraId);
        }
        return this;
    }

    public ScanOptions setTorchEnabled(boolean enabled) {
        this.addExtra("TORCH_ENABLED", enabled);
        return this;
    }

    public ScanOptions setBeepEnabled(boolean enabled) {
        this.addExtra("BEEP_ENABLED", enabled);
        return this;
    }

    public ScanOptions setBarcodeImageEnabled(boolean enabled) {
        this.addExtra("BARCODE_IMAGE_ENABLED", enabled);
        return this;
    }

    public ScanOptions setDesiredBarcodeFormats(Collection<String> desiredBarcodeFormats) {
        this.desiredBarcodeFormats = desiredBarcodeFormats;
        return this;
    }

    public ScanOptions setDesiredBarcodeFormats(String ... desiredBarcodeFormats) {
        this.desiredBarcodeFormats = Arrays.asList(desiredBarcodeFormats);
        return this;
    }

    public ScanOptions setTimeout(long timeout) {
        this.addExtra("TIMEOUT", timeout);
        return this;
    }

    public Intent createScanIntent(Context context) {
        Intent intentScan = new Intent(context, this.getCaptureActivity());
        intentScan.setAction("com.google.zxing.client.android.SCAN");
        if (this.desiredBarcodeFormats != null) {
            StringBuilder joinedByComma = new StringBuilder();
            for (String format : this.desiredBarcodeFormats) {
                if (joinedByComma.length() > 0) {
                    joinedByComma.append(',');
                }
                joinedByComma.append(format);
            }
            intentScan.putExtra("SCAN_FORMATS", joinedByComma.toString());
        }
        intentScan.addFlags(0x4000000);
        intentScan.addFlags(524288);
        this.attachMoreExtras(intentScan);
        return intentScan;
    }

    private static List<String> list(String ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    private void attachMoreExtras(Intent intent) {
        for (Map.Entry<String, Object> entry : this.moreExtras.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                intent.putExtra(key, (Serializable)((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                intent.putExtra(key, (Serializable)((Long)value));
                continue;
            }
            if (value instanceof Boolean) {
                intent.putExtra(key, (Serializable)((Boolean)value));
                continue;
            }
            if (value instanceof Double) {
                intent.putExtra(key, (Serializable)((Double)value));
                continue;
            }
            if (value instanceof Float) {
                intent.putExtra(key, (Serializable)((Float)value));
                continue;
            }
            if (value instanceof Bundle) {
                intent.putExtra(key, (Bundle)value);
                continue;
            }
            if (value instanceof int[]) {
                intent.putExtra(key, (int[])value);
                continue;
            }
            if (value instanceof long[]) {
                intent.putExtra(key, (long[])value);
                continue;
            }
            if (value instanceof boolean[]) {
                intent.putExtra(key, (boolean[])value);
                continue;
            }
            if (value instanceof double[]) {
                intent.putExtra(key, (double[])value);
                continue;
            }
            if (value instanceof float[]) {
                intent.putExtra(key, (float[])value);
                continue;
            }
            if (value instanceof String[]) {
                intent.putExtra(key, (String[])value);
                continue;
            }
            intent.putExtra(key, value.toString());
        }
    }
}

