/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary;

import com.karuslabs.elementary.Results;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Finder
implements Iterable<Diagnostic<? extends JavaFileObject>> {
    private final List<Diagnostic<? extends JavaFileObject>> diagnostics;
    private final Results results;

    public Finder(Results results) {
        this.diagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>(results.diagnostics);
        this.results = results;
    }

    @Override
    public Iterator<Diagnostic<? extends JavaFileObject>> iterator() {
        return this.diagnostics.iterator();
    }

    public Finder kind(Diagnostic.Kind ... kinds) {
        return this.kind(Set.of(kinds));
    }

    public Finder kind(Collection<Diagnostic.Kind> kinds) {
        this.diagnostics.removeIf(diagnostic -> !kinds.contains((Object)diagnostic.getKind()));
        return this;
    }

    public Finder errors() {
        this.diagnostics.retainAll(this.results.errors);
        return this;
    }

    public Finder warnings() {
        this.diagnostics.retainAll(this.results.warnings);
        return this;
    }

    public Finder notes() {
        this.diagnostics.retainAll(this.results.notes);
        return this;
    }

    public Finder in(JavaFileObject file) {
        String path = file.toUri().getPath();
        this.diagnostics.removeIf(diagnostic -> !((JavaFileObject)diagnostic.getSource()).toUri().getPath().equals(path));
        return this;
    }

    public Finder on(long line) {
        this.diagnostics.removeIf(diagnostic -> diagnostic.getLineNumber() != line);
        return this;
    }

    public Finder at(long column) {
        this.diagnostics.removeIf(diagnostic -> diagnostic.getColumnNumber() != column);
        return this;
    }

    public Finder where(Predicate<Diagnostic<? extends JavaFileObject>> condition) {
        this.diagnostics.removeIf(Predicate.not(condition));
        return this;
    }

    public Finder matches(String message) {
        this.diagnostics.removeIf(diagnostic -> !diagnostic.getMessage(Locale.getDefault()).equals(message));
        return this;
    }

    public Finder matches(Pattern pattern) {
        this.diagnostics.removeIf(diagnostic -> !pattern.matcher(diagnostic.getMessage(Locale.getDefault())).matches());
        return this;
    }

    public Finder contains(String substring) {
        this.diagnostics.removeIf(diagnostic -> !diagnostic.getMessage(Locale.getDefault()).contains(substring));
        return this;
    }

    public List<String> diagnostics() {
        return this.diagnostics.stream().map(Object::toString).collect(Collectors.toList());
    }

    public List<String> messages() {
        return this.diagnostics.stream().map(diagnostic -> diagnostic.getMessage(Locale.getDefault())).collect(Collectors.toList());
    }

    public List<Long> lines() {
        return this.diagnostics.stream().map(Diagnostic::getLineNumber).collect(Collectors.toList());
    }

    public List<Long> columns() {
        return this.diagnostics.stream().map(Diagnostic::getColumnNumber).collect(Collectors.toList());
    }

    public List<Long> positions() {
        return this.diagnostics.stream().map(Diagnostic::getPosition).collect(Collectors.toList());
    }

    public List<String> codes() {
        return this.diagnostics.stream().map(Diagnostic::getCode).collect(Collectors.toList());
    }

    public @Nullable Diagnostic<? extends JavaFileObject> one() {
        return this.diagnostics.size() == 1 ? this.diagnostics.get(0) : null;
    }

    public List<Diagnostic<? extends JavaFileObject>> list() {
        return this.diagnostics;
    }

    public Map<Diagnostic.Kind, List<Diagnostic<? extends JavaFileObject>>> map() {
        HashMap<Diagnostic.Kind, List<Diagnostic<? extends JavaFileObject>>> map = new HashMap<Diagnostic.Kind, List<Diagnostic<? extends JavaFileObject>>>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnostics) {
            List<Diagnostic<? extends JavaFileObject>> list = map.get((Object)diagnostic.getKind());
            if (list == null) {
                list = new ArrayList<Diagnostic<? extends JavaFileObject>>();
                map.put(diagnostic.getKind(), list);
            }
            list.add(diagnostic);
        }
        return map;
    }

    public int count() {
        return this.diagnostics.size();
    }
}

