/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.collide.Collidable;
import com.kennycason.kumo.collide.checkers.CollisionChecker;
import com.kennycason.kumo.image.CollisionRaster;
import com.kennycason.kumo.image.ImageRotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class Word
implements Collidable {
    private final CollisionChecker collisionChecker;
    private final String word;
    private final Color color;
    private final Point position = new Point(0, 0);
    private BufferedImage bufferedImage;
    private CollisionRaster collisionRaster;
    private final double theta;

    public Word(String word, Color color, FontMetrics fontMetrics, CollisionChecker collisionChecker, double theta) {
        this.word = word;
        this.color = color;
        this.collisionChecker = collisionChecker;
        this.theta = theta;
        this.bufferedImage = this.render(word, color, fontMetrics, theta);
        this.collisionRaster = new CollisionRaster(this.bufferedImage);
    }

    private BufferedImage render(String text, Color fontColor, FontMetrics fontMetrics, double theta) {
        int width = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight();
        BufferedImage rendered = new BufferedImage(width, height, 2);
        Graphics2D gOfRendered = (Graphics2D)rendered.getGraphics();
        gOfRendered.setRenderingHints(Word.getRenderingHints());
        gOfRendered.setColor(fontColor);
        gOfRendered.setFont(fontMetrics.getFont());
        gOfRendered.drawString(text, 0, height - fontMetrics.getMaxDescent() - fontMetrics.getLeading());
        return ImageRotation.rotate(rendered, theta);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.collisionRaster = new CollisionRaster(bufferedImage);
    }

    public String getWord() {
        return this.word;
    }

    public double getTheta() {
        return this.theta;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public Dimension getDimension() {
        return this.collisionRaster.getDimension();
    }

    @Override
    public CollisionRaster getCollisionRaster() {
        return this.collisionRaster;
    }

    @Override
    public boolean collide(Collidable collidable) {
        return this.collisionChecker.collide(this, collidable);
    }

    public void draw(CollisionRaster collisionRaster) {
        collisionRaster.mask(collisionRaster, this.position);
    }

    public static RenderingHints getRenderingHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        return new RenderingHints(hints);
    }

    public String toString() {
        return "Word{word='" + this.word + '\'' + ", color=" + this.color + ", x=" + this.position.x + ", y=" + this.position.y + ", width=" + this.bufferedImage.getWidth() + ", height=" + this.bufferedImage.getHeight() + '}';
    }
}

