/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.collide.checkers;

import com.kennycason.kumo.collide.Collidable;
import com.kennycason.kumo.collide.checkers.CollisionChecker;
import com.kennycason.kumo.collide.checkers.RectangleCollisionChecker;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Point;

public class RectanglePixelCollisionChecker
implements CollisionChecker {
    private static final RectangleCollisionChecker RECTANGLE_COLLISION_CHECKER = new RectangleCollisionChecker();

    @Override
    public boolean collide(Collidable collidable, Collidable collidable2) {
        if (!RECTANGLE_COLLISION_CHECKER.collide(collidable, collidable2)) {
            return false;
        }
        Point position = collidable.getPosition();
        Point position2 = collidable2.getPosition();
        CollisionRaster collisionRaster = collidable.getCollisionRaster();
        CollisionRaster collisionRaster2 = collidable2.getCollisionRaster();
        int startX = Math.max(position.x, position2.x);
        int endX = Math.min(position.x + collidable.getDimension().width, position2.x + collidable2.getDimension().width);
        int startY = Math.max(position.y, position2.y);
        int endY = Math.min(position.y + collidable.getDimension().height, position2.y + collidable2.getDimension().height);
        int endX1 = endX - position.x;
        int endX2 = endX - position2.x;
        int stop1 = position.x + -1;
        int stop2 = position2.x + -1;
        int stepSize = (endY - startY) / 3 + 1;
        for (int i = stepSize - 1; i >= 0; --i) {
            block1: for (int y = startY + i; y < endY; y += stepSize) {
                block5: {
                    int yOfPosition2;
                    int absolute2;
                    int yOfPosition = y - position.y;
                    int absolute1 = position.x + collisionRaster.nextNotTransparentPixel(startX - position.x, endX1, yOfPosition);
                    if (absolute1 == stop1 || (absolute2 = position2.x + collisionRaster2.nextNotTransparentPixel(startX - position2.x, endX2, yOfPosition2 = y - position2.y)) == stop2) continue;
                    while (true) {
                        if (absolute1 > absolute2) {
                            absolute2 = position2.x + collisionRaster2.nextNotTransparentPixel(absolute1 - position2.x, endX2, yOfPosition2);
                            if (absolute2 != stop2) continue;
                            continue block1;
                        }
                        if (absolute1 >= absolute2) break block5;
                        absolute1 = position.x + collisionRaster.nextNotTransparentPixel(absolute2 - position.x, endX1, yOfPosition);
                        if (absolute1 == stop1) break;
                    }
                    continue;
                }
                return true;
            }
        }
        return false;
    }
}

