/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import kong.unirest.core.BaseRequest;
import kong.unirest.core.Body;
import kong.unirest.core.BodyPart;
import kong.unirest.core.HttpRequestBody;
import kong.unirest.core.InputStreamBody;
import kong.unirest.core.JsonNode;
import kong.unirest.core.ProgressMonitor;
import kong.unirest.core.RequestBodyEntity;
import kong.unirest.core.UniByteArrayBody;
import kong.unirest.core.UnibodyString;
import kong.unirest.core.json.JSONElement;

class HttpRequestUniBody
extends BaseRequest<RequestBodyEntity>
implements RequestBodyEntity {
    private BodyPart body;
    private Charset charSet;
    private ProgressMonitor monitor;

    HttpRequestUniBody(HttpRequestBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
    }

    HttpRequestUniBody(HttpRequestUniBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
        this.body = httpRequest.body;
        this.monitor = httpRequest.monitor;
    }

    @Override
    public RequestBodyEntity body(JsonNode jsonBody) {
        return this.body(jsonBody.toString());
    }

    @Override
    public RequestBodyEntity body(InputStream inputStreamBody) {
        this.body = new InputStreamBody(inputStreamBody);
        return this;
    }

    @Override
    public RequestBodyEntity body(JSONElement jsonBody) {
        return this.body(jsonBody.toString());
    }

    @Override
    public RequestBodyEntity body(Object objectBody) {
        if (objectBody instanceof String) {
            return this.body((String)objectBody);
        }
        if (objectBody instanceof JsonNode) {
            return this.body((JsonNode)objectBody);
        }
        if (objectBody instanceof JSONElement) {
            return this.body(objectBody.toString());
        }
        return this.body(this.getObjectMapper().writeValue(objectBody));
    }

    @Override
    public RequestBodyEntity body(String bodyAsString) {
        this.body = new UnibodyString(bodyAsString);
        return this;
    }

    @Override
    public RequestBodyEntity body(byte[] bodyBytes) {
        this.body = new UniByteArrayBody(bodyBytes);
        return this;
    }

    @Override
    public RequestBodyEntity charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public RequestBodyEntity contentType(String type) {
        this.headers.add("Content-Type", type);
        return this;
    }

    @Override
    public RequestBodyEntity uploadMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.of(this);
    }

    @Override
    public Charset getCharset() {
        return this.charSet;
    }

    @Override
    public boolean isMultiPart() {
        return false;
    }

    @Override
    public boolean isEntityBody() {
        return true;
    }

    @Override
    public BodyPart uniPart() {
        return this.body;
    }

    @Override
    public ProgressMonitor getMonitor() {
        return this.monitor;
    }
}

