/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remote-server", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class RunJMeterServerMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false", property="background")
    private boolean runInBackground;
    @Parameter(defaultValue="1099", property="serverPort")
    private Integer serverPort;
    @Parameter(defaultValue="localhost", property="rmiHostname")
    private String exportedRmiHostname;
    @Parameter(defaultValue="false", property="rmiSSLDisable")
    private Boolean disableSSL;
    public static final String CLI_CONFIG_EXECUTION_ID = "default-cli";

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T A R T I N G    J M E T E R    S E R V E R ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)String.format(" Host: %s", this.exportedRmiHostname));
        this.getLog().info((CharSequence)String.format(" Port: %s", this.serverPort));
        this.testConfig = this.mojoExecution.getExecutionId().equals(CLI_CONFIG_EXECUTION_ID) ? new TestConfigurationWrapper(new File(this.testConfigFile), CLI_CONFIG_EXECUTION_ID) : new TestConfigurationWrapper(new File(this.testConfigFile), this.selectedConfiguration);
        this.startJMeterServer(this.initializeJMeterArgumentsArray());
    }

    private JMeterArgumentsArray initializeJMeterArgumentsArray() throws MojoExecutionException {
        return new JMeterArgumentsArray(false, this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath()).setProxyConfig(this.proxyConfig).addACustomPropertiesFiles(this.customPropertiesFiles).setLogRootOverride(this.overrideRootLogLevel).setLogsDirectory(this.logsDirectory.getAbsolutePath()).setServerMode(this.exportedRmiHostname, this.serverPort);
    }

    private void startJMeterServer(JMeterArgumentsArray testArgs) throws MojoExecutionException {
        block17: {
            this.jMeterProcessJVMSettings.setHeadlessDefaultIfRequired().addArgument(String.format("-Djava.rmi.server.hostname=%s", this.exportedRmiHostname)).addArgument(String.format("-Dserver.rmi.ssl.disable=%s", this.disableSSL)).addArgument(String.format("-Dserver_port=%s", this.serverPort));
            JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, this.testConfig.getCurrentTestConfiguration().getRuntimeJarName()).setWorkingDirectory(new File(this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath(), "bin")).addArguments(testArgs.buildArgumentsArray());
            try {
                Process process = jmeterProcessBuilder.build().start();
                if (this.runInBackground) {
                    this.getLog().info((CharSequence)" ");
                    this.getLog().info((CharSequence)" Starting JMeter server process in the background...");
                    break block17;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    this.getLog().info((CharSequence)"Shutdown detected, destroying JMeter server process...");
                    this.getLog().info((CharSequence)" ");
                    process.destroy();
                }));
                try (InputStreamReader isr = new InputStreamReader(process.getInputStream());
                     BufferedReader br = new BufferedReader(isr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (this.suppressJMeterOutput) {
                            this.getLog().debug((CharSequence)line);
                            continue;
                        }
                        this.getLog().info((CharSequence)line);
                    }
                    int jMeterExitCode = process.waitFor();
                    if (jMeterExitCode != 0) {
                        throw new MojoExecutionException("Starting JMeter server in background failed with exit code: " + jMeterExitCode);
                    }
                }
            }
            catch (InterruptedException ex) {
                this.getLog().info((CharSequence)" ");
                this.getLog().info((CharSequence)"System Exit detected!  Stopping JMeter server process...");
                this.getLog().info((CharSequence)" ");
                Thread.currentThread().interrupt();
            }
            catch (IOException ioException) {
                this.getLog().error((CharSequence)String.format("Error starting JMeter with args %s, in working directory: %s", testArgs.buildArgumentsArray(), this.testConfig.getCurrentTestConfiguration().getJmeterDirectoryPath()), (Throwable)ioException);
            }
        }
    }
}

