/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.results.IResultScanner;

public class TestFailureDecider {
    private final IResultScanner resultScanner;
    private final boolean ignoreResultFailures;
    private final double errorPercentageThreshold;
    private double errorPercentage;
    private boolean checkRan;

    public TestFailureDecider(boolean ignoreResultFailures, double errorPercentageThreshold, IResultScanner resultScanner) {
        this.ignoreResultFailures = ignoreResultFailures;
        this.errorPercentageThreshold = errorPercentageThreshold;
        this.resultScanner = resultScanner;
    }

    public boolean failBuild() {
        if (!this.checkRan) {
            throw new IllegalStateException("You need to call runChecks");
        }
        return !this.ignoreResultFailures && this.errorPercentage > this.errorPercentageThreshold;
    }

    public void runChecks() {
        this.errorPercentage = (double)Math.round((double)this.resultScanner.getFailureCount() * 10000.0 / (double)this.resultScanner.getTotalCount()) / 100.0;
        this.checkRan = true;
    }

    public boolean isIgnoreResultFailures() {
        return this.ignoreResultFailures;
    }

    public double getErrorPercentageThreshold() {
        return this.errorPercentageThreshold;
    }

    public double getErrorPercentage() {
        return this.errorPercentage;
    }
}

