/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.portlet;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * @author Eduardo García
 * @author Marco Leo
 */
@ProviderType
public interface FriendlyURLResolver {

	public String getActualURL(
			long companyId, long groupId, boolean privateLayout,
			String mainPath, String friendlyURL, Map<String, String[]> params,
			Map<String, Object> requestContext)
		throws PortalException;

	public default String getDefaultURLSeparator() {
		return StringPool.BLANK;
	}

	public default String getKey() {
		return StringPool.BLANK;
	}

	public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(
			long companyId, long groupId, boolean privateLayout,
			String friendlyURL, Map<String, String[]> params,
			Map<String, Object> requestContext)
		throws PortalException;

	public default LayoutFriendlyURLSeparatorComposite
			getLayoutFriendlyURLSeparatorComposite(
				long companyId, long groupId, boolean privateLayout,
				String friendlyURL, Map<String, String[]> params,
				Map<String, Object> requestContext)
		throws PortalException {

		LayoutFriendlyURLComposite layoutFriendlyURLComposite =
			getLayoutFriendlyURLComposite(
				companyId, groupId, privateLayout, friendlyURL, params,
				requestContext);

		if (layoutFriendlyURLComposite == null) {
			return null;
		}

		return new LayoutFriendlyURLSeparatorComposite(
			layoutFriendlyURLComposite, getURLSeparator());
	}

	public String getURLSeparator();

	public default boolean isURLSeparatorConfigurable() {
		return false;
	}

}