/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.audit;

import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class AuditMessage
implements Serializable {
    private static final String _ADDITIONAL_INFO = "additionalInfo";
    private static final String _CLASS_NAME = "className";
    private static final String _CLASS_PK = "classPK";
    private static final String _CLIENT_HOST = "clientHost";
    private static final String _CLIENT_IP = "clientIP";
    private static final String _COMPANY_ID = "companyId";
    private static final String _DATE_FORMAT = "yyyyMMddkkmmssSSS";
    private static final String _EVENT_TYPE = "eventType";
    private static final String _GROUP_ID = "groupId";
    private static final String _MESSAGE = "message";
    private static final String _SERVER_NAME = "serverName";
    private static final String _SERVER_PORT = "serverPort";
    private static final String _SESSION_ID = "sessionID";
    private static final String _TIMESTAMP = "timestamp";
    private static final String _USER_EMAIL_ADDRESS = "userEmailAddress";
    private static final String _USER_ID = "userId";
    private static final String _USER_LOGIN = "userLogin";
    private static final String _USER_NAME = "userName";
    private static final Log _log = LogFactoryUtil.getLog(AuditMessage.class);
    private JSONObject _additionalInfoJSONObject;
    private String _className;
    private String _classPK;
    private String _clientHost;
    private String _clientIP;
    private long _companyId = -1L;
    private String _eventType;
    private long _groupId = -1L;
    private String _message;
    private String _serverName;
    private int _serverPort;
    private String _sessionID;
    private Date _timestamp;
    private String _userEmailAddress;
    private long _userId = -1L;
    private String _userLogin;
    private String _userName;

    public AuditMessage(String message) throws JSONException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject(message);
        this._additionalInfoJSONObject = jsonObject.getJSONObject(_ADDITIONAL_INFO);
        this._className = jsonObject.getString(_CLASS_NAME);
        this._classPK = jsonObject.getString(_CLASS_PK);
        if (jsonObject.has(_CLIENT_HOST)) {
            this._clientHost = jsonObject.getString(_CLIENT_HOST);
        }
        if (jsonObject.has(_CLIENT_IP)) {
            this._clientIP = jsonObject.getString(_CLIENT_IP);
        }
        this._companyId = jsonObject.getLong(_COMPANY_ID);
        this._eventType = jsonObject.getString(_EVENT_TYPE);
        this._groupId = jsonObject.getLong(_GROUP_ID);
        this._message = jsonObject.getString(_MESSAGE);
        if (jsonObject.has(_SERVER_NAME)) {
            this._serverName = jsonObject.getString(_SERVER_NAME);
        }
        if (jsonObject.has(_SERVER_PORT)) {
            this._serverPort = jsonObject.getInt(_SERVER_PORT);
        }
        if (jsonObject.has(_SESSION_ID)) {
            this._sessionID = jsonObject.getString(_SESSION_ID);
        }
        this._timestamp = GetterUtil.getDate(jsonObject.getString(_TIMESTAMP), this._getDateFormat());
        this._userEmailAddress = jsonObject.getString(_USER_EMAIL_ADDRESS);
        this._userId = jsonObject.getLong(_USER_ID);
        this._userLogin = jsonObject.getString(_USER_LOGIN);
        this._userName = jsonObject.getString(_USER_NAME);
    }

    public AuditMessage(String eventType, long companyId, long groupId, long userId, String userName, String className, String classPK, String message, Date timestamp, JSONObject additionalInfoJSONObject) {
        this._eventType = eventType;
        this._companyId = companyId;
        this._groupId = groupId;
        this._userId = userId;
        this._userName = userName;
        this._className = className;
        this._classPK = classPK;
        this._message = message;
        this._timestamp = timestamp != null ? timestamp : new Date();
        this._additionalInfoJSONObject = additionalInfoJSONObject != null ? additionalInfoJSONObject : JSONFactoryUtil.createJSONObject();
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        this._clientHost = auditRequestThreadLocal.getClientHost();
        this._clientIP = auditRequestThreadLocal.getClientIP();
        this._serverName = auditRequestThreadLocal.getServerName();
        this._serverPort = auditRequestThreadLocal.getServerPort();
        this._sessionID = auditRequestThreadLocal.getSessionID();
        this._userEmailAddress = auditRequestThreadLocal.getRealUserEmailAddress();
        long realUserId = auditRequestThreadLocal.getRealUserId();
        long doAsUserId = 0L;
        if (PrincipalThreadLocal.getName() != null) {
            doAsUserId = GetterUtil.getLong(PrincipalThreadLocal.getName());
        }
        if (realUserId > 0L && doAsUserId != realUserId && !this._additionalInfoJSONObject.has("doAsUserId")) {
            this._additionalInfoJSONObject.put("doAsUserEmailAddress", PortalUtil.getUserEmailAddress(doAsUserId)).put("doAsUserId", String.valueOf(doAsUserId)).put("doAsUserName", PortalUtil.getUserName(doAsUserId, ""));
        }
        if (userId == realUserId) {
            this._userLogin = auditRequestThreadLocal.getRealUserLogin();
        } else if (realUserId > 0L && !PortalRunMode.isTestMode()) {
            _log.error("Impersonated actions must be audited on the real user's ID");
        }
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName) {
        this(eventType, companyId, 0L, userId, userName, null, null, null, null, null);
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK) {
        this(eventType, companyId, 0L, userId, userName, className, classPK, null, null, null);
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message) {
        this(eventType, companyId, 0L, userId, userName, className, classPK, message, null, null);
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message, Date timestamp, JSONObject additionalInfoJSONObject) {
        this(eventType, companyId, 0L, userId, userName, className, classPK, message, timestamp, additionalInfoJSONObject);
    }

    public AuditMessage(String eventType, long companyId, long userId, String userName, String className, String classPK, String message, JSONObject additionalInfoJSONObject) {
        this(eventType, companyId, 0L, userId, userName, className, classPK, message, null, additionalInfoJSONObject);
    }

    public JSONObject getAdditionalInfo() {
        return this._additionalInfoJSONObject;
    }

    public String getClassName() {
        return this._className;
    }

    public String getClassPK() {
        return this._classPK;
    }

    public String getClientHost() {
        return this._clientHost;
    }

    public String getClientIP() {
        return this._clientIP;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getEventType() {
        return this._eventType;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getMessage() {
        return this._message;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getSessionID() {
        return this._sessionID;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public String getUserEmailAddress() {
        return this._userEmailAddress;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserLogin() {
        return this._userLogin;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setAdditionalInfo(JSONObject additionalInfoJSONObject) {
        this._additionalInfoJSONObject = additionalInfoJSONObject;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = String.valueOf(classPK);
    }

    public void setClassPK(String classPK) {
        this._classPK = classPK;
    }

    public void setClientHost(String clientHost) {
        this._clientHost = clientHost;
    }

    public void setClientIP(String clientIP) {
        this._clientIP = clientIP;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setEventType(String eventType) {
        this._eventType = eventType;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public void setSessionID(String sessionID) {
        this._sessionID = sessionID;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    public void setUserEmailAddress(String userEmailAddress) {
        this._userEmailAddress = userEmailAddress;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUserLogin(String userLogin) {
        this._userLogin = userLogin;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public JSONObject toJSONObject() {
        return JSONUtil.put(_ADDITIONAL_INFO, this._additionalInfoJSONObject).put(_CLASS_NAME, this._className).put(_CLASS_PK, this._classPK).put(_CLIENT_HOST, this._clientHost).put(_CLIENT_IP, this._clientIP).put(_COMPANY_ID, this._companyId).put(_EVENT_TYPE, this._eventType).put(_MESSAGE, this._message).put(_SERVER_NAME, this._serverName).put(_SERVER_PORT, this._serverPort).put(_SESSION_ID, this._sessionID).put(_TIMESTAMP, this._getDateFormat().format(new Date())).put(_USER_EMAIL_ADDRESS, this._userEmailAddress).put(_USER_ID, this._userId).put(_USER_LOGIN, this._userLogin).put(_USER_NAME, this._userName);
    }

    private DateFormat _getDateFormat() {
        return DateFormatFactoryUtil.getSimpleDateFormat(_DATE_FORMAT);
    }
}

