/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.module.service.Snapshot;

public class ClusterLinkUtil {
    private static final String _ADDRESS = "CLUSTER_ADDRESS";
    private static final Snapshot<ClusterLink> _clusterLinkSnapshot = new Snapshot<ClusterLink>(ClusterLinkUtil.class, ClusterLink.class);

    public static Address getAddress(Message message) {
        return (Address)message.get(_ADDRESS);
    }

    public static void sendMulticastMessage(Message message, Priority priority) {
        ClusterLink clusterLink = _clusterLinkSnapshot.get();
        clusterLink.sendMulticastMessage(message, priority);
    }

    public static void sendMulticastMessage(Object payload, Priority priority) {
        Message message = new Message();
        message.setPayload(payload);
        ClusterLinkUtil.sendMulticastMessage(message, priority);
    }

    public static void sendUnicastMessage(Address address, Message message, Priority priority) {
        ClusterLink clusterLink = _clusterLinkSnapshot.get();
        clusterLink.sendUnicastMessage(address, message, priority);
    }

    public static Message setAddress(Message message, Address address) {
        message.put(_ADDRESS, address);
        return message;
    }
}

