/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;

public class HotDeployUtil {
    private static final Log _log = LogFactoryUtil.getLog(HotDeployUtil.class);
    private static volatile boolean _capturePrematureEvents = true;
    private static final Queue<HotDeployEvent> _dependentHotDeployEvents = new ConcurrentLinkedQueue<HotDeployEvent>();
    private static final Set<String> _deployedServletContextNames = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final List<HotDeployListener> _hotDeployListeners = new CopyOnWriteArrayList<HotDeployListener>();

    public static void fireDeployEvent(HotDeployEvent hotDeployEvent) {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        ServletContextPool.put(servletContext.getServletContextName(), servletContext);
        if (_capturePrematureEvents) {
            DependencyManagerSyncUtil.registerSyncCallable(() -> {
                HotDeployUtil.fireDeployEvent(hotDeployEvent);
                return null;
            });
        } else {
            HotDeployUtil._fireDeployEvent(hotDeployEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireUndeployEvent(HotDeployEvent hotDeployEvent) {
        for (int i = _hotDeployListeners.size() - 1; i >= 0; --i) {
            HotDeployListener hotDeployListener = _hotDeployListeners.get(i);
            PortletClassLoaderUtil.setServletContextName(hotDeployEvent.getServletContextName());
            try {
                hotDeployListener.invokeUndeploy(hotDeployEvent);
                continue;
            }
            catch (HotDeployException hotDeployException) {
                _log.error(hotDeployException);
                continue;
            }
            finally {
                PortletClassLoaderUtil.setServletContextName(null);
            }
        }
        _deployedServletContextNames.remove(hotDeployEvent.getServletContextName());
    }

    public static void registerListener(HotDeployListener hotDeployListener) {
        _hotDeployListeners.add(hotDeployListener);
    }

    public static void reset() {
        _capturePrematureEvents = true;
        _dependentHotDeployEvents.clear();
        _deployedServletContextNames.clear();
        _hotDeployListeners.clear();
    }

    public static void setCapturePrematureEvents(boolean capturePrematureEvents) {
        _capturePrematureEvents = capturePrematureEvents;
    }

    public static void unregisterListener(HotDeployListener hotDeployListener) {
        _hotDeployListeners.remove(hotDeployListener);
    }

    public static void unregisterListeners() {
        _hotDeployListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _fireDeployEvent(HotDeployEvent hotDeployEvent) {
        String servletContextName = hotDeployEvent.getServletContextName();
        if (_deployedServletContextNames.contains(servletContextName)) {
            return;
        }
        boolean hasDependencies = true;
        for (String string : hotDeployEvent.getDependentServletContextNames()) {
            if (_deployedServletContextNames.contains(string)) continue;
            hasDependencies = false;
            break;
        }
        if (hasDependencies) {
            if (_log.isDebugEnabled()) {
                _log.debug("Deploying " + servletContextName + " from queue");
            }
            for (HotDeployListener hotDeployListener : _hotDeployListeners) {
                PortletClassLoaderUtil.setServletContextName(hotDeployEvent.getServletContextName());
                try {
                    hotDeployListener.invokeDeploy(hotDeployEvent);
                }
                catch (HotDeployException hotDeployException) {
                    _log.error(hotDeployException);
                }
                finally {
                    PortletClassLoaderUtil.setServletContextName(null);
                }
            }
            _deployedServletContextNames.add(servletContextName);
            _dependentHotDeployEvents.remove(hotDeployEvent);
            Throwable throwable = null;
            try (SafeCloseable safeCloseable1 = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
                ArrayList<HotDeployEvent> dependentEvents = new ArrayList<HotDeployEvent>(_dependentHotDeployEvents);
                for (HotDeployEvent dependentEvent : dependentEvents) {
                    SafeCloseable safeCloseable2 = ThreadContextClassLoaderUtil.swap((ClassLoader)dependentEvent.getContextClassLoader());
                    Throwable throwable2 = null;
                    try {
                        HotDeployUtil._fireDeployEvent(dependentEvent);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (safeCloseable2 == null) continue;
                        if (throwable2 != null) {
                            try {
                                safeCloseable2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        safeCloseable2.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
        }
        if (!_dependentHotDeployEvents.contains(hotDeployEvent)) {
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat((String[])new String[]{"Queueing ", servletContextName, " for deploy because it is missing ", HotDeployUtil._getRequiredServletContextNames(hotDeployEvent)}));
            }
            _dependentHotDeployEvents.add(hotDeployEvent);
        } else if (_log.isInfoEnabled()) {
            for (HotDeployEvent hotDeployEvent2 : _dependentHotDeployEvents) {
                _log.info(StringBundler.concat((String[])new String[]{servletContextName, " is still in queue because it is missing ", HotDeployUtil._getRequiredServletContextNames(hotDeployEvent2)}));
            }
        }
    }

    private static String _getRequiredServletContextNames(HotDeployEvent hotDeployEvent) {
        ArrayList<String> requiredServletContextNames = new ArrayList<String>();
        for (String dependentServletContextName : hotDeployEvent.getDependentServletContextNames()) {
            if (_deployedServletContextNames.contains(dependentServletContextName)) continue;
            requiredServletContextNames.add(dependentServletContextName);
        }
        Collections.sort(requiredServletContextNames);
        return StringUtil.merge(requiredServletContextNames, ", ");
    }
}

