/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.increment;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.util.ClassUtil;
import java.lang.reflect.Constructor;

public class IncrementFactory {
    public static Increment createIncrement(Class<? extends Increment<?>> counterClass, Object value) {
        if (counterClass == NumberIncrement.class && value instanceof Number) {
            return new NumberIncrement((Number)value);
        }
        try {
            Class<?> valueClass = value.getClass();
            while (true) {
                try {
                    Constructor<Increment<?>> constructor = counterClass.getConstructor(valueClass);
                    return constructor.newInstance(value);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!(valueClass = valueClass.getSuperclass()).equals(Object.class)) continue;
                    throw new SystemException(counterClass.getName() + " is unable to increment " + ClassUtil.getClassName(value), noSuchMethodException);
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
    }
}

