/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.instance;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class PortalInstancePool {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstancePool.class);
    private static volatile boolean _cacheEnabled;
    private static final Map<Long, String> _portalInstances;

    public static void add(Company company) {
        _portalInstances.put(company.getCompanyId(), company.getWebId());
    }

    public static void enableCache() {
        _cacheEnabled = true;
    }

    public static long getCompanyId(String webId) {
        if (_cacheEnabled) {
            for (Map.Entry<Long, String> entry : _portalInstances.entrySet()) {
                if (!Objects.equals(entry.getValue(), webId)) continue;
                return entry.getKey();
            }
            throw new IllegalArgumentException("Unable to get company ID with web ID" + webId);
        }
        try {
            return PortalInstancePool._getCompanyIdBySQL(webId);
        }
        catch (SQLException sqlException) {
            _log.error("Unable to get the company ID for web ID " + webId + " by SQL", sqlException);
            throw new RuntimeException(sqlException);
        }
    }

    public static long[] getCompanyIds() {
        if (_cacheEnabled) {
            return ArrayUtil.toLongArray(_portalInstances.keySet());
        }
        try {
            return PortalInstancePool._getCompanyIdsBySQL();
        }
        catch (SQLException sqlException) {
            _log.error("Unable to get the company IDs by SQL", sqlException);
            throw new RuntimeException(sqlException);
        }
    }

    public static long getDefaultCompanyId() {
        if (_cacheEnabled) {
            for (Map.Entry<Long, String> entry : _portalInstances.entrySet()) {
                if (!Objects.equals(PropsUtil.get("company.default.web.id"), entry.getValue())) continue;
                return entry.getKey();
            }
            throw new IllegalStateException("Unable to get default company ID");
        }
        try {
            return PortalInstancePool._getDefaultCompanyIdBySQL();
        }
        catch (SQLException sqlException) {
            _log.error("Unable to get the default company ID by SQL", sqlException);
            throw new RuntimeException(sqlException);
        }
    }

    public static String getWebId(long companyId) {
        if (_cacheEnabled) {
            return _portalInstances.get(companyId);
        }
        try {
            return PortalInstancePool._getWebIdBySQL(companyId);
        }
        catch (SQLException sqlException) {
            _log.error("Unable to get the web ID for company with companyID " + companyId + " by SQL", sqlException);
            throw new RuntimeException(sqlException);
        }
    }

    public static String[] getWebIds() {
        if (_cacheEnabled) {
            return ArrayUtil.toStringArray(_portalInstances.values());
        }
        try {
            return PortalInstancePool._getWebIdsBySQL();
        }
        catch (SQLException sqlException) {
            _log.error("Unable to get the web IDs by SQL", sqlException);
            throw new RuntimeException(sqlException);
        }
    }

    public static void remove(long companyId) {
        _portalInstances.remove(companyId);
    }

    private static long _getCompanyIdBySQL(String webId) throws SQLException {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = ?");){
            preparedStatement.setString(1, webId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
        }
        throw new IllegalArgumentException("Invalid web ID" + webId);
    }

    private static long[] _getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        long defaultCompanyId = PortalInstancePool._getDefaultCompanyIdBySQL();
        if (defaultCompanyId != 0L) {
            companyIds.add(defaultCompanyId);
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                if (companyId == defaultCompanyId) continue;
                companyIds.add(companyId);
            }
        }
        return ArrayUtil.toArray(companyIds.toArray(new Long[0]));
    }

    private static long _getDefaultCompanyIdBySQL() throws SQLException {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = ?");){
            preparedStatement.setString(1, PropsUtil.get("company.default.web.id"));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
        }
        return 0L;
    }

    private static String _getWebIdBySQL(long companyId) throws SQLException {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select webId from Company where companyId = ?");){
            preparedStatement.setLong(1, companyId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    return string;
                }
            }
        }
        throw new IllegalArgumentException("Invalid company ID" + companyId);
    }

    private static String[] _getWebIdsBySQL() throws SQLException {
        ArrayList<String> webIds = new ArrayList<String>();
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select webId from Company");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String webId = resultSet.getString("webId");
                webIds.add(webId);
            }
        }
        return webIds.toArray(new String[0]);
    }

    static {
        _portalInstances = new ConcurrentHashMap<Long, String>();
    }
}

