/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.service.persistence.change.tracking;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.internal.service.persistence.ReverseTableMapper;
import com.liferay.portal.kernel.internal.service.persistence.TableMapperImpl;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.ModelListenerRegistrationUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class CTTableMapper<L extends BaseModel<L>, R extends BaseModel<R>>
extends TableMapperImpl<L, R> {
    private static final ParamSetter _booleanParamSetter = (ps, index, param) -> ps.setBoolean(index, (Boolean)param);
    private SqlUpdate _addCTTableMappingSqlUpdate;
    private MappingSqlQuery<Integer> _containsCTTableMappingSQL;
    private MappingSqlQuery<Long> _getCTLeftPrimaryKeysSqlQuery;
    private MappingSqlQuery<Long> _getCTRightPrimaryKeysSqlQuery;
    private SqlUpdate _updateCTTableMappingSqlUpdate;

    public CTTableMapper(String tableName, String companyColumnName, String leftColumnName, String rightColumnName, Class<L> leftModelClass, Class<R> rightModelClass, BasePersistence<L> leftBasePersistence, BasePersistence<R> rightBasePersistence, boolean cacheless) {
        super(tableName, companyColumnName, leftColumnName, rightColumnName, leftModelClass, rightModelClass, leftBasePersistence, rightBasePersistence, cacheless);
    }

    @Override
    public boolean addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey);
        }
        if (this._containsTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId)) {
            return false;
        }
        this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey, ctCollectionId);
        return true;
    }

    @Override
    public long[] addTableMappings(long companyId, long leftPrimaryKey, long[] rightPrimaryKeys) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.addTableMappings(companyId, leftPrimaryKey, rightPrimaryKeys);
        }
        ArrayList<Long> addedRightPrimaryKeys = new ArrayList<Long>();
        for (long rightPrimaryKey : rightPrimaryKeys) {
            if (this._containsTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId)) continue;
            addedRightPrimaryKeys.add(rightPrimaryKey);
            this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey, ctCollectionId);
        }
        return ArrayUtil.toLongArray(addedRightPrimaryKeys);
    }

    @Override
    public long[] addTableMappings(long companyId, long[] leftPrimaryKeys, long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.addTableMappings(companyId, leftPrimaryKeys, rightPrimaryKey);
        }
        ArrayList<Long> addedLeftPrimaryKeys = new ArrayList<Long>();
        for (long leftPrimaryKey : leftPrimaryKeys) {
            if (this._containsTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId)) continue;
            addedLeftPrimaryKeys.add(leftPrimaryKey);
            this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey, ctCollectionId);
        }
        return ArrayUtil.toLongArray(addedLeftPrimaryKeys);
    }

    @Override
    public int deleteLeftPrimaryKeyTableMappings(long leftPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.deleteLeftPrimaryKeyTableMappings(leftPrimaryKey);
        }
        return this._deleteTableMappings(this.leftModelClass, this.rightModelClass, this._getCTRightPrimaryKeysSqlQuery, leftPrimaryKey, ctCollectionId, true);
    }

    @Override
    public int deleteRightPrimaryKeyTableMappings(long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.deleteRightPrimaryKeyTableMappings(rightPrimaryKey);
        }
        return this._deleteTableMappings(this.rightModelClass, this.leftModelClass, this._getCTLeftPrimaryKeysSqlQuery, rightPrimaryKey, ctCollectionId, false);
    }

    @Override
    public boolean deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.deleteTableMapping(leftPrimaryKey, rightPrimaryKey);
        }
        if (this._containsTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId)) {
            this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId);
            return true;
        }
        return false;
    }

    @Override
    public long[] deleteTableMappings(long leftPrimaryKey, long[] rightPrimaryKeys) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.deleteTableMappings(leftPrimaryKey, rightPrimaryKeys);
        }
        long[] currentRightPrimaryKeys = this._getPrimaryKeys(this._getCTRightPrimaryKeysSqlQuery, leftPrimaryKey, ctCollectionId);
        ArrayList<Long> deletedRightPrimaryKeys = new ArrayList<Long>();
        for (long rightPrimaryKey : rightPrimaryKeys) {
            if (Arrays.binarySearch(currentRightPrimaryKeys, rightPrimaryKey) < 0) continue;
            this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId);
            deletedRightPrimaryKeys.add(rightPrimaryKey);
        }
        return ArrayUtil.toLongArray(deletedRightPrimaryKeys);
    }

    @Override
    public long[] deleteTableMappings(long[] leftPrimaryKeys, long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.deleteTableMappings(leftPrimaryKeys, rightPrimaryKey);
        }
        long[] currentLeftPrimaryKeys = this._getPrimaryKeys(this._getCTLeftPrimaryKeysSqlQuery, rightPrimaryKey, ctCollectionId);
        ArrayList<Long> deletedLeftPrimaryKeys = new ArrayList<Long>();
        for (long leftPrimaryKey : leftPrimaryKeys) {
            if (Arrays.binarySearch(currentLeftPrimaryKeys, leftPrimaryKey) < 0) continue;
            this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey, ctCollectionId);
            deletedLeftPrimaryKeys.add(leftPrimaryKey);
        }
        return ArrayUtil.toLongArray(deletedLeftPrimaryKeys);
    }

    @Override
    public List<L> getLeftBaseModels(long rightPrimaryKey, int start, int end, OrderByComparator<L> orderByComparator) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.getLeftBaseModels(rightPrimaryKey, start, end, orderByComparator);
        }
        return this._getBaseModels(this._getCTLeftPrimaryKeysSqlQuery, rightPrimaryKey, ctCollectionId, this.leftBasePersistence, start, end, orderByComparator);
    }

    @Override
    public long[] getLeftPrimaryKeys(long rightPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.getLeftPrimaryKeys(rightPrimaryKey);
        }
        return this._getPrimaryKeys(this._getCTLeftPrimaryKeysSqlQuery, rightPrimaryKey, ctCollectionId);
    }

    @Override
    public List<R> getRightBaseModels(long leftPrimaryKey, int start, int end, OrderByComparator<R> orderByComparator) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.getRightBaseModels(leftPrimaryKey, start, end, orderByComparator);
        }
        return this._getBaseModels(this._getCTRightPrimaryKeysSqlQuery, leftPrimaryKey, ctCollectionId, this.rightBasePersistence, start, end, orderByComparator);
    }

    @Override
    public long[] getRightPrimaryKeys(long leftPrimaryKey) {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return super.getRightPrimaryKeys(leftPrimaryKey);
        }
        return this._getPrimaryKeys(this._getCTRightPrimaryKeysSqlQuery, leftPrimaryKey, ctCollectionId);
    }

    @Override
    protected void init(String tableName, String companyColumnName, String leftColumnName, String rightColumnName) {
        DataSource dataSource = this.leftBasePersistence.getDataSource();
        this.addTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"INSERT INTO ", tableName, " (", companyColumnName, ", ", leftColumnName, ", ", rightColumnName, ", ctCollectionId) VALUES (?, ?, ?, 0)"}), ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.containsTableMappingSQL = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT * FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ? AND ctCollectionId = 0"}), RowMapper.COUNT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.deleteLeftPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ctCollectionId = 0"}), ParamSetter.BIGINT);
        this.deleteRightPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", rightColumnName, " = ? AND ctCollectionId = 0"}), ParamSetter.BIGINT);
        this.deleteTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ? AND ctCollectionId = 0"}), ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.getLeftPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT ", leftColumnName, " FROM ", tableName, " WHERE ", rightColumnName, " = ? AND ctCollectionId = 0"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.getRightPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT ", rightColumnName, " FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ctCollectionId = 0"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.reverseTableMapper = new ReverseTableMapper(this);
        this._addCTTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"INSERT INTO ", tableName, " (", companyColumnName, ", ", leftColumnName, ", ", rightColumnName, ", ctCollectionId, ctChangeType) VALUES (?, ?, ?, ?, ?)"}), ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, _booleanParamSetter);
        DB db = DBManagerUtil.getDB();
        this._containsCTTableMappingSQL = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT * FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ? AND (ctCollectionId = 0 OR ctCollectionId = ?) AND ", "(ctChangeType is NULL or ctChangeType = ", db.getTemplateTrue(), ") AND NOT EXISTS (SELECT * FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ? AND ctCollectionId = ? AND ctChangeType = ", db.getTemplateFalse(), ")"}), RowMapper.COUNT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this._getCTLeftPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT DISTINCT (", leftColumnName, ") FROM ", tableName, " WHERE ", rightColumnName, " = ? AND ((", leftColumnName, " NOT IN (SELECT ", leftColumnName, " FROM ", tableName, " WHERE ", rightColumnName, " = ? AND ctCollectionId = ? ", "AND ctChangeType = ", db.getTemplateFalse(), ") AND ", "ctCollectionId = 0) OR (ctCollectionId = ? AND ", "ctChangeType = ", db.getTemplateTrue(), "))"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this._getCTRightPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT DISTINCT (", rightColumnName, ") FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ((", rightColumnName, " NOT IN (SELECT ", rightColumnName, " FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ctCollectionId = ? ", "AND ctChangeType = ", db.getTemplateFalse(), ") AND ", "ctCollectionId = 0) OR (ctCollectionId = ? AND ", "ctChangeType = ", db.getTemplateTrue(), "))"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        this._updateCTTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"UPDATE ", tableName, " SET ctChangeType = ? WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ? AND ctCollectionId = ?"}), _booleanParamSetter, ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
    }

    private void _addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey, long ctCollectionId) {
        ModelListener<T>[] rightModelListeners;
        ModelListener<T>[] leftModelListeners;
        for (ModelListener leftModelListener : leftModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.leftModelClass)) {
            leftModelListener.onBeforeAddAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener rightModelListener : rightModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.rightModelClass)) {
            rightModelListener.onBeforeAddAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
        this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey, ctCollectionId, true);
        for (ModelListener leftModelListener : leftModelListeners) {
            leftModelListener.onAfterAddAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener rightModelListener : rightModelListeners) {
            rightModelListener.onAfterAddAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
    }

    private void _addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey, long ctCollectionId, boolean ctChangeType) {
        try {
            int count = this._updateCTTableMappingSqlUpdate.update(ctChangeType, leftPrimaryKey, rightPrimaryKey, ctCollectionId);
            if (count == 0) {
                this._addCTTableMappingSqlUpdate.update(companyId, leftPrimaryKey, rightPrimaryKey, ctCollectionId, ctChangeType);
            }
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
    }

    private boolean _containsTableMapping(long leftPrimaryKey, long rightPrimaryKey, long ctCollectionId) {
        List<Integer> counts = null;
        try {
            counts = this._containsCTTableMappingSQL.execute(leftPrimaryKey, rightPrimaryKey, ctCollectionId, leftPrimaryKey, rightPrimaryKey, ctCollectionId);
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
        if (counts.isEmpty()) {
            return false;
        }
        int count = counts.get(0);
        return count != 0;
    }

    private void _deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey, long ctCollectionId) {
        ModelListener<T>[] rightModelListeners;
        ModelListener<T>[] leftModelListeners;
        for (ModelListener leftModelListener : leftModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.leftModelClass)) {
            leftModelListener.onBeforeRemoveAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener rightModelListener : rightModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.rightModelClass)) {
            rightModelListener.onBeforeRemoveAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
        this._addTableMapping(CompanyThreadLocal.getCompanyId(), leftPrimaryKey, rightPrimaryKey, ctCollectionId, false);
        for (ModelListener leftModelListener : leftModelListeners) {
            leftModelListener.onAfterRemoveAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener rightModelListener : rightModelListeners) {
            rightModelListener.onAfterRemoveAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
    }

    private <M extends BaseModel<M>, S extends BaseModel<S>> int _deleteTableMappings(Class<M> masterModelClass, Class<S> slaveModelClass, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, long ctCollectionId, boolean leftToRight) {
        ModelListener<M>[] masterModelListeners = ModelListenerRegistrationUtil.getModelListeners(masterModelClass);
        ModelListener<S>[] slaveModelListeners = ModelListenerRegistrationUtil.getModelListeners(slaveModelClass);
        long[] slavePrimaryKeys = this._getPrimaryKeys(mappingSqlQuery, masterPrimaryKey, ctCollectionId);
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onBeforeRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onBeforeRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        for (long slavePrimaryKey : slavePrimaryKeys) {
            if (leftToRight) {
                this._addTableMapping(companyId, masterPrimaryKey, slavePrimaryKey, ctCollectionId, false);
                continue;
            }
            this._addTableMapping(companyId, slavePrimaryKey, masterPrimaryKey, ctCollectionId, false);
        }
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onAfterRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onAfterRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        return slavePrimaryKeys.length;
    }

    private <T extends BaseModel<T>> List<T> _getBaseModels(MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, long ctCollectionId, BasePersistence<T> slaveBasePersistence, int start, int end, OrderByComparator<T> orderByComparator) {
        long[] slavePrimaryKeys = this._getPrimaryKeys(mappingSqlQuery, masterPrimaryKey, ctCollectionId);
        if (slavePrimaryKeys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> slaveBaseModels = new ArrayList<T>(slavePrimaryKeys.length);
        try {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                slaveBaseModels.add(slaveBasePersistence.findByPrimaryKey(Long.valueOf(slavePrimaryKey)));
            }
        }
        catch (NoSuchModelException noSuchModelException) {
            throw new SystemException(noSuchModelException);
        }
        if (orderByComparator != null) {
            slaveBaseModels.sort(orderByComparator);
        }
        return ListUtil.subList(slaveBaseModels, start, end);
    }

    private long[] _getPrimaryKeys(MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, long ctCollectionId) {
        List<Long> primaryKeysList = null;
        try {
            primaryKeysList = mappingSqlQuery.execute(masterPrimaryKey, masterPrimaryKey, ctCollectionId, ctCollectionId);
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
        long[] primaryKeys = new long[primaryKeysList.size()];
        for (int i = 0; i < primaryKeys.length; ++i) {
            primaryKeys[i] = primaryKeysList.get(i);
        }
        Arrays.sort(primaryKeys);
        return primaryKeys;
    }
}

