/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lock;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.module.service.Snapshot;

public class LockManagerUtil {
    private static final Snapshot<LockManager> _lockManagerSnapshot = new Snapshot<LockManager>(LockManagerUtil.class, LockManager.class);

    public static Lock createLock(long lockId, long companyId, long userId, String userName) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.createLock(lockId, companyId, userId, userName);
    }

    public static Lock fetchLock(String className, long key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.fetchLock(className, key);
    }

    public static Lock fetchLock(String className, String key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.fetchLock(className, key);
    }

    public static Lock getLock(String className, long key) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.getLock(className, key);
    }

    public static Lock getLock(String className, String key) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.getLock(className, key);
    }

    public static Lock getLockByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.getLockByUuidAndCompanyId(uuid, companyId);
    }

    public static boolean hasLock(long userId, String className, long key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.hasLock(userId, className, key);
    }

    public static boolean hasLock(long userId, String className, String key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.hasLock(userId, className, key);
    }

    public static boolean isLocked(String className, long key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.isLocked(className, key);
    }

    public static boolean isLocked(String className, String key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.isLocked(className, key);
    }

    public static Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(userId, className, key, owner, inheritable, expirationTime);
    }

    public static Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(userId, className, key, owner, inheritable, expirationTime, renew);
    }

    public static Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(userId, className, key, owner, inheritable, expirationTime);
    }

    public static Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime, boolean renew) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(userId, className, key, owner, inheritable, expirationTime, renew);
    }

    public static Lock lock(String className, String key, String owner) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(className, key, owner);
    }

    public static Lock lock(String className, String key, String expectedOwner, String updatedOwner) {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.lock(className, key, expectedOwner, updatedOwner);
    }

    public static Lock refresh(String uuid, long companyId, long expirationTime) throws PortalException {
        LockManager lockManager = _lockManagerSnapshot.get();
        return lockManager.refresh(uuid, companyId, expirationTime);
    }

    public static void unlock(String className, long key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        lockManager.unlock(className, key);
    }

    public static void unlock(String className, String key) {
        LockManager lockManager = _lockManagerSnapshot.get();
        lockManager.unlock(className, key);
    }

    public static void unlock(String className, String key, String owner) {
        LockManager lockManager = _lockManagerSnapshot.get();
        lockManager.unlock(className, key, owner);
    }
}

