/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.util;

import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceLatch {
    private final BundleContext _bundleContext;
    private Runnable _openRunnable;
    private final Queue<ServiceTracker<?, ?>> _serviceTrackers = new ConcurrentLinkedQueue();
    private final AtomicInteger _serviceTrackersCount = new AtomicInteger();

    public ServiceLatch(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void openOn(Consumer<BundleContext> consumer) {
        this.openOn(() -> consumer.accept(this._bundleContext));
    }

    public void openOn(Runnable runnable) {
        this._openRunnable = runnable;
        for (ServiceTracker serviceTracker : this._serviceTrackers) {
            serviceTracker.open();
        }
    }

    public <S> ServiceLatch waitFor(Class<S> serviceClass) {
        return this.waitFor(serviceClass, (S s) -> {});
    }

    public <S> ServiceLatch waitFor(Class<S> serviceClass, Consumer<S> serviceConsumer) {
        CapturingServiceTrackerCustomizer capturingServiceTrackerCustomizer = new CapturingServiceTrackerCustomizer(serviceConsumer);
        ServiceTracker serviceTracker = new ServiceTracker(this._bundleContext, serviceClass, capturingServiceTrackerCustomizer);
        capturingServiceTrackerCustomizer.setServiceTracker(serviceTracker);
        this._serviceTrackers.add(serviceTracker);
        this._serviceTrackersCount.incrementAndGet();
        return this;
    }

    public <S> ServiceLatch waitFor(String filterString) {
        return this.waitFor(filterString, (S s) -> {});
    }

    public <S> ServiceLatch waitFor(String filterString, Consumer<S> serviceConsumer) {
        CapturingServiceTrackerCustomizer capturingServiceTrackerCustomizer = new CapturingServiceTrackerCustomizer(serviceConsumer);
        try {
            ServiceTracker serviceTracker = new ServiceTracker(this._bundleContext, this._bundleContext.createFilter(filterString), capturingServiceTrackerCustomizer);
            capturingServiceTrackerCustomizer.setServiceTracker(serviceTracker);
            this._serviceTrackers.add(serviceTracker);
            this._serviceTrackersCount.incrementAndGet();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException(invalidSyntaxException);
        }
        return this;
    }

    private class CapturingServiceTrackerCustomizer<S>
    implements ServiceTrackerCustomizer<S, S> {
        private final Consumer<S> _serviceConsumer;
        private ServiceTracker<S, S> _serviceTracker;

        public S addingService(ServiceReference<S> serviceReference) {
            Object service = ServiceLatch.this._bundleContext.getService(serviceReference);
            this._serviceConsumer.accept(service);
            if (ServiceLatch.this._serviceTrackersCount.decrementAndGet() == 0) {
                ServiceLatch.this._openRunnable.run();
                DependencyManagerSyncUtil.registerSyncCallable(() -> {
                    for (ServiceTracker serviceTracker : ServiceLatch.this._serviceTrackers) {
                        serviceTracker.close();
                    }
                    return null;
                });
            }
            return (S)service;
        }

        public void modifiedService(ServiceReference<S> serviceReference, S service) {
        }

        public void removedService(ServiceReference<S> serviceReference, S service) {
            ServiceLatch.this._bundleContext.ungetService(serviceReference);
        }

        public void setServiceTracker(ServiceTracker<S, S> serviceTracker) {
            this._serviceTracker = serviceTracker;
        }

        private CapturingServiceTrackerCustomizer(Consumer<S> serviceConsumer) {
            this._serviceConsumer = serviceConsumer;
        }
    }
}

